/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import org.acra.ACRA;
import org.acra.ErrorReporter;

public class CrashReportDialog
extends Activity {
    private static final int CRASH_DIALOG_LEFT_ICON = 17301543;
    private EditText userComment = null;
    String mReportFileName = null;

    protected void onCreate(Bundle savedInstanceState) {
        int resLeftIcon;
        super.onCreate(savedInstanceState);
        this.mReportFileName = this.getIntent().getStringExtra("REPORT_FILE_NAME");
        if (this.mReportFileName == null) {
            this.finish();
        }
        this.requestWindowFeature(3);
        final Bundle crashResources = ACRA.getCrashResources();
        LinearLayout root = new LinearLayout((Context)this);
        root.setOrientation(1);
        root.setPadding(10, 10, 10, 10);
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        ScrollView scroll = new ScrollView((Context)this);
        root.addView((View)scroll, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        TextView text = new TextView((Context)this);
        text.setText(this.getText(crashResources.getInt("RES_DIALOG_TEXT")));
        scroll.addView((View)text, -1, -1);
        int commentPromptId = crashResources.getInt("RES_DIALOG_COMMENT_PROMPT");
        if (commentPromptId != 0) {
            TextView label = new TextView((Context)this);
            label.setText(this.getText(commentPromptId));
            label.setPadding(label.getPaddingLeft(), 10, label.getPaddingRight(), label.getPaddingBottom());
            root.addView((View)label, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.userComment = new EditText((Context)this);
            this.userComment.setLines(2);
            root.addView((View)this.userComment, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        LinearLayout buttons = new LinearLayout((Context)this);
        buttons.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        buttons.setPadding(buttons.getPaddingLeft(), 10, buttons.getPaddingRight(), buttons.getPaddingBottom());
        Button yes = new Button((Context)this);
        yes.setText(17039379);
        yes.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ErrorReporter err = ErrorReporter.getInstance();
                if (CrashReportDialog.this.userComment != null) {
                    err.setUserComment(CrashReportDialog.this.userComment.getText().toString());
                }
                ErrorReporter.ReportsSenderWorker worker = new ErrorReporter.ReportsSenderWorker(err);
                worker.setCommentReportFileName(CrashReportDialog.this.mReportFileName);
                worker.start();
                int toastId = crashResources.getInt("RES_DIALOG_OK_TOAST");
                if (toastId != 0) {
                    Toast.makeText((Context)CrashReportDialog.this.getApplicationContext(), (int)toastId, (int)1).show();
                }
                CrashReportDialog.this.finish();
            }
        });
        buttons.addView((View)yes, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        Button no = new Button((Context)this);
        no.setText(17039369);
        no.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ErrorReporter.getInstance().deletePendingReports();
                CrashReportDialog.this.finish();
            }
        });
        buttons.addView((View)no, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        root.addView((View)buttons, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.setContentView((View)root);
        int resTitle = crashResources.getInt("RES_DIALOG_TITLE");
        if (resTitle != 0) {
            this.setTitle(resTitle);
        }
        if ((resLeftIcon = crashResources.getInt("RES_DIALOG_ICON")) != 0) {
            this.getWindow().setFeatureDrawableResource(3, resLeftIcon);
        } else {
            this.getWindow().setFeatureDrawableResource(3, 17301543);
        }
        this.cancelNotification();
    }

    protected void cancelNotification() {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.cancel(666);
    }
}

