// https://github.com/slapperwan/gh4a/blob/master/src/com/gh4a/utils/TypefaceCache.java
package com.ruesga.rview.misc;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.util.SparseArray;

public class TypefaceCache {
    public static final int TF_REGULAR = 0;
    public static final int TF_BOLD = 2;
    public static final int TF_ITALIC = 3;
    public static final int TF_CONDENSED = 4;
    public static final int TF_BOLD_CONDENSED = 5;
    public static final int TF_MONOSPACE = 6;
    public static final int TF_BOLD_MONOSPACE = 7;

    private static final String[] FONT_FILENAMES = new String[] {
        "fonts/Roboto-Regular.ttf",
        "fonts/Roboto-Medium.ttf",
        "fonts/Roboto-Bold.ttf",
        "fonts/Roboto-Italic.ttf",
        "fonts/Roboto-Condensed-Regular.ttf",
        "fonts/Roboto-Condensed-Bold.ttf",
        "fonts/Roboto-Mono-Regular.ttf",
        "fonts/Roboto-Mono-Bold.ttf"
    };

    private static final String[] FONT_FAMILIES = new String[] {
        "sans-serif",
        "sans-serif-medium",
        "sans-serif",
        "sans-serif",
        "sans-serif-condensed",
        "sans-serif-condensed",
        "serif-monospace",
        "serif-monospace"
    };
    private static final int[] FONT_STYLES = new int[] {
        Typeface.NORMAL,
        Typeface.NORMAL,
        Typeface.BOLD,
        Typeface.ITALIC,
        Typeface.NORMAL,
        Typeface.BOLD,
        Typeface.NORMAL,
        Typeface.BOLD
    };

    private static SparseArray<Typeface> sTypefaces = new SparseArray<>();

    public static Typeface getTypeface(Context context, int typeface, int style) {
        switch (style) {
            case Typeface.BOLD:
                switch (typeface) {
                    case TF_REGULAR: typeface = TF_BOLD; break;
                    case TF_CONDENSED: typeface = TF_BOLD_CONDENSED; break;
                    case TF_MONOSPACE: typeface = TF_BOLD_MONOSPACE; break;
                }
                break;
            case Typeface.ITALIC:
                switch (typeface) {
                    case TF_REGULAR: typeface = TF_ITALIC; break;
                }
                break;
        }
        return getTypeface(context, typeface);
    }

    public static Typeface getTypeface(Context context, int typeface) {
        if (typeface < TF_REGULAR || typeface > TF_BOLD_MONOSPACE) {
            return null;
        }

        Typeface tf = sTypefaces.get(typeface);
        if (tf == null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && typeface < TF_MONOSPACE) {
                // L has all typefaces we need, use system fonts
                tf = Typeface.create(FONT_FAMILIES[typeface], FONT_STYLES[typeface]);
            } else {
                // use our fonts
                AssetManager assets = context.getApplicationContext().getAssets();
                tf = Typeface.createFromAsset(assets, FONT_FILENAMES[typeface]);
            }
            sTypefaces.put(typeface, tf);
        }

        return tf;
    }
}
