/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglClipboard;
import com.badlogic.gdx.backends.lwjgl.LwjglFiles;
import com.badlogic.gdx.backends.lwjgl.LwjglGraphics;
import com.badlogic.gdx.backends.lwjgl.LwjglInput;
import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import com.badlogic.gdx.backends.lwjgl.LwjglNet;
import com.badlogic.gdx.backends.lwjgl.LwjglPreferences;
import com.badlogic.gdx.backends.openal.OpenALAudio;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.awt.Canvas;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;

public class LwjglApplication
implements Application {
    protected final LwjglGraphics graphics;
    protected final OpenALAudio audio;
    protected final LwjglFiles files;
    protected final LwjglInput input;
    protected final LwjglNet net;
    protected final ApplicationListener listener;
    protected Thread mainLoopThread;
    protected boolean running = true;
    protected final Array<Runnable> runnables = new Array();
    protected final Array<Runnable> executedRunnables = new Array();
    protected int logLevel = 2;
    Map<String, Preferences> preferences = new HashMap<String, Preferences>();

    public LwjglApplication(ApplicationListener listener, String title, int width, int height, boolean useGL2) {
        this(listener, LwjglApplication.createConfig(title, width, height, useGL2));
    }

    public LwjglApplication(ApplicationListener listener) {
        this(listener, new LwjglApplicationConfiguration());
    }

    public LwjglApplication(ApplicationListener listener, LwjglApplicationConfiguration config) {
        this(listener, config, new LwjglGraphics(config));
    }

    public LwjglApplication(ApplicationListener listener, boolean useGL2, Canvas canvas) {
        this(listener, new LwjglApplicationConfiguration(), new LwjglGraphics(canvas, useGL2));
    }

    public LwjglApplication(ApplicationListener listener, LwjglApplicationConfiguration config, Canvas canvas) {
        this(listener, config, new LwjglGraphics(canvas, config));
    }

    public LwjglApplication(ApplicationListener listener, LwjglApplicationConfiguration config, LwjglGraphics graphics) {
        LwjglNativesLoader.load();
        this.graphics = graphics;
        this.audio = new OpenALAudio(16, config.audioDeviceBufferCount, config.audioDeviceBufferSize);
        this.files = new LwjglFiles();
        this.input = new LwjglInput();
        this.net = new LwjglNet();
        this.listener = listener;
        Gdx.app = this;
        Gdx.graphics = graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
        Gdx.net = this.net;
        this.initialize();
    }

    private static LwjglApplicationConfiguration createConfig(String title, int width, int height, boolean useGL2) {
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.title = title;
        config.width = width;
        config.height = height;
        config.useGL20 = useGL2;
        config.vSyncEnabled = true;
        return config;
    }

    private void initialize() {
        this.mainLoopThread = new Thread("LWJGL Application"){

            @Override
            public void run() {
                LwjglApplication.this.graphics.setVSync(LwjglApplication.this.graphics.config.vSyncEnabled);
                try {
                    LwjglApplication.this.mainLoop();
                }
                catch (Throwable t) {
                    LwjglApplication.this.audio.dispose();
                    throw new GdxRuntimeException(t);
                }
            }
        };
        this.mainLoopThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainLoop() {
        try {
            this.graphics.setupDisplay();
        }
        catch (LWJGLException e) {
            throw new GdxRuntimeException((Throwable)e);
        }
        this.listener.create();
        this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
        this.graphics.resize = false;
        int lastWidth = this.graphics.getWidth();
        int lastHeight = this.graphics.getHeight();
        this.graphics.lastTime = System.nanoTime();
        while (this.running) {
            Display.processMessages();
            if (Display.isCloseRequested()) {
                this.exit();
            }
            boolean shouldRender = false;
            Array<Runnable> array = this.runnables;
            synchronized (array) {
                this.executedRunnables.clear();
                this.executedRunnables.addAll(this.runnables);
                this.runnables.clear();
                for (int i = 0; i < this.executedRunnables.size; ++i) {
                    shouldRender = true;
                    try {
                        ((Runnable)this.executedRunnables.get(i)).run();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            if (!this.running) break;
            this.input.update();
            shouldRender |= this.graphics.shouldRender();
            if (this.graphics.canvas != null) {
                int width = this.graphics.canvas.getWidth();
                int height = this.graphics.canvas.getHeight();
                if (lastWidth != width || lastHeight != height) {
                    lastWidth = width;
                    lastHeight = height;
                    Gdx.gl.glViewport(0, 0, lastWidth, lastHeight);
                    this.listener.resize(lastWidth, lastHeight);
                    shouldRender = true;
                }
            } else {
                this.graphics.config.x = Display.getX();
                this.graphics.config.y = Display.getY();
                if (this.graphics.resize || Display.wasResized() || Display.getWidth() != this.graphics.config.width || Display.getHeight() != this.graphics.config.height) {
                    this.graphics.resize = false;
                    Gdx.gl.glViewport(0, 0, Display.getWidth(), Display.getHeight());
                    this.graphics.config.width = Display.getWidth();
                    this.graphics.config.height = Display.getHeight();
                    if (this.listener != null) {
                        this.listener.resize(Display.getWidth(), Display.getHeight());
                    }
                    this.graphics.requestRendering();
                }
            }
            this.input.processEvents();
            this.audio.update();
            if (shouldRender) {
                this.graphics.updateTime();
                this.listener.render();
                Display.update();
                if (!this.graphics.vsync || !this.graphics.config.useCPUSynch) continue;
                Display.sync(60);
                continue;
            }
            Display.sync(60);
        }
        this.listener.pause();
        this.listener.dispose();
        Display.destroy();
        this.audio.dispose();
        if (this.graphics.config.forceExit) {
            System.exit(-1);
        }
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Files getFiles() {
        return this.files;
    }

    public LwjglGraphics getGraphics() {
        return this.graphics;
    }

    public Input getInput() {
        return this.input;
    }

    public Net getNet() {
        return this.net;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    public int getVersion() {
        return 0;
    }

    public void stop() {
        this.running = false;
        try {
            this.mainLoopThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey(name)) {
            return this.preferences.get(name);
        }
        LwjglPreferences prefs = new LwjglPreferences(name);
        this.preferences.put(name, prefs);
        return prefs;
    }

    public Clipboard getClipboard() {
        return new LwjglClipboard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
            Gdx.graphics.requestRendering();
        }
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
        }
    }

    public void log(String tag, String message, Exception exception) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
            exception.printStackTrace(System.err);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void exit() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                LwjglApplication.this.running = false;
            }
        });
    }
}

