/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglGL10;
import com.badlogic.gdx.backends.lwjgl.LwjglGL11;
import com.badlogic.gdx.backends.lwjgl.LwjglGL20;
import com.badlogic.gdx.backends.lwjgl.LwjglGLU;
import com.badlogic.gdx.graphics.GL10;
import com.badlogic.gdx.graphics.GL11;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLCommon;
import com.badlogic.gdx.graphics.GLU;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.awt.Canvas;
import java.awt.Toolkit;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;

public class LwjglGraphics
implements Graphics {
    static int major;
    static int minor;
    GLCommon gl;
    GL10 gl10;
    GL11 gl11;
    GL20 gl20;
    GLU glu;
    float deltaTime = 0.0f;
    long frameStart = 0L;
    int frames = 0;
    int fps;
    long lastTime = System.nanoTime();
    Canvas canvas;
    boolean vsync = false;
    boolean resize = false;
    LwjglApplicationConfiguration config;
    Graphics.BufferFormat bufferFormat = new Graphics.BufferFormat(8, 8, 8, 8, 16, 8, 0, false);
    String extensions;
    volatile boolean isContinuous = true;
    volatile boolean requestRendering = false;

    LwjglGraphics(LwjglApplicationConfiguration config) {
        this.config = config;
    }

    LwjglGraphics(Canvas canvas, boolean useGL2IfAvailable) {
        this.config = new LwjglApplicationConfiguration();
        this.config.width = canvas.getWidth();
        this.config.height = canvas.getHeight();
        this.config.useGL20 = useGL2IfAvailable;
        this.canvas = canvas;
    }

    LwjglGraphics(Canvas canvas, LwjglApplicationConfiguration config) {
        this.config = config;
        this.config.width = canvas.getWidth();
        this.config.height = canvas.getHeight();
        this.canvas = canvas;
    }

    public GL10 getGL10() {
        return this.gl10;
    }

    public GL11 getGL11() {
        return this.gl11;
    }

    public GL20 getGL20() {
        return this.gl20;
    }

    public GLU getGLU() {
        return this.glu;
    }

    public int getHeight() {
        if (this.canvas != null) {
            return this.canvas.getHeight();
        }
        return Display.getHeight();
    }

    public int getWidth() {
        if (this.canvas != null) {
            return this.canvas.getWidth();
        }
        return Display.getWidth();
    }

    public boolean isGL11Available() {
        return this.gl11 != null;
    }

    public boolean isGL20Available() {
        return this.gl20 != null;
    }

    public float getDeltaTime() {
        return this.deltaTime;
    }

    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.LWJGL;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public GLCommon getGLCommon() {
        return this.gl;
    }

    void updateTime() {
        long time = System.nanoTime();
        this.deltaTime = (float)(time - this.lastTime) / 1.0E9f;
        this.lastTime = time;
        if (time - this.frameStart >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = time;
        }
        ++this.frames;
    }

    void setupDisplay() throws LWJGLException {
        if (this.canvas != null) {
            Display.setParent(this.canvas);
        } else if (!this.setDisplayMode(this.config.width, this.config.height, this.config.fullscreen)) {
            throw new GdxRuntimeException("Couldn't set display mode " + this.config.width + "x" + this.config.height + ", fullscreen: " + this.config.fullscreen);
        }
        Display.setTitle(this.config.title);
        Display.setResizable(this.config.resizable);
        Display.setInitialBackground(this.config.initialBackgroundColor.r, this.config.initialBackgroundColor.g, this.config.initialBackgroundColor.b);
        if (this.config.iconPaths.size > 0) {
            ByteBuffer[] icons = new ByteBuffer[this.config.iconPaths.size];
            int n = this.config.iconPaths.size;
            for (int i = 0; i < n; ++i) {
                Pixmap pixmap = new Pixmap(Gdx.files.getFileHandle((String)this.config.iconPaths.get(i), (Files.FileType)this.config.iconFileTypes.get(i)));
                if (pixmap.getFormat() != Pixmap.Format.RGBA8888) {
                    Pixmap rgba = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), Pixmap.Format.RGBA8888);
                    rgba.drawPixmap(pixmap, 0, 0);
                    pixmap = rgba;
                }
                icons[i] = ByteBuffer.allocateDirect(pixmap.getPixels().limit());
                icons[i].put(pixmap.getPixels()).flip();
                pixmap.dispose();
            }
            Display.setIcon(icons);
        }
        if (this.config.x != -1 && this.config.y != -1) {
            Display.setLocation(this.config.x, this.config.y);
        }
        this.createDisplayPixelFormat();
        this.config.x = Display.getX();
        this.config.y = Display.getY();
        this.initiateGLInstances();
    }

    private void createDisplayPixelFormat() {
        block12: {
            boolean samples = false;
            try {
                Display.create(new PixelFormat(this.config.r + this.config.g + this.config.b, this.config.a, this.config.depth, this.config.stencil, this.config.samples));
                this.bufferFormat = new Graphics.BufferFormat(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil, this.config.samples, false);
            }
            catch (Exception ex) {
                Display.destroy();
                try {
                    Display.create(new PixelFormat(0, 16, 8));
                    if (this.getDesktopDisplayMode().bitsPerPixel == 16) {
                        this.bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 16, 8, 0, false);
                    }
                    if (this.getDesktopDisplayMode().bitsPerPixel == 24) {
                        this.bufferFormat = new Graphics.BufferFormat(8, 8, 8, 0, 16, 8, 0, false);
                    }
                    if (this.getDesktopDisplayMode().bitsPerPixel == 32) {
                        this.bufferFormat = new Graphics.BufferFormat(8, 8, 8, 8, 16, 8, 0, false);
                    }
                }
                catch (Exception ex2) {
                    Display.destroy();
                    try {
                        Display.create(new PixelFormat());
                        if (this.getDesktopDisplayMode().bitsPerPixel == 16) {
                            this.bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 8, 0, 0, false);
                        }
                        if (this.getDesktopDisplayMode().bitsPerPixel == 24) {
                            this.bufferFormat = new Graphics.BufferFormat(8, 8, 8, 0, 8, 0, 0, false);
                        }
                        if (this.getDesktopDisplayMode().bitsPerPixel == 32) {
                            this.bufferFormat = new Graphics.BufferFormat(8, 8, 8, 8, 8, 0, 0, false);
                        }
                    }
                    catch (Exception ex3) {
                        if (!ex3.getMessage().contains("Pixel format not accelerated")) break block12;
                        throw new GdxRuntimeException("OpenGL is not supported by the video driver.", (Throwable)ex3);
                    }
                }
            }
        }
    }

    public void initiateGLInstances() {
        String version = org.lwjgl.opengl.GL11.glGetString(7938);
        major = Integer.parseInt("" + version.charAt(0));
        minor = Integer.parseInt("" + version.charAt(2));
        if (this.config.useGL20 && (major >= 2 || version.contains("2.1"))) {
            this.gl20 = new LwjglGL20();
            this.gl = this.gl20;
        } else {
            this.gl20 = null;
            if (major == 1 && minor < 5) {
                this.gl10 = new LwjglGL10();
            } else {
                this.gl11 = new LwjglGL11();
                this.gl10 = this.gl11;
            }
            this.gl = this.gl10;
        }
        Gdx.glu = this.glu = new LwjglGLU();
        Gdx.gl = this.gl;
        Gdx.gl10 = this.gl10;
        Gdx.gl11 = this.gl11;
        Gdx.gl20 = this.gl20;
    }

    public float getPpiX() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public float getPpiY() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public float getPpcX() {
        return (float)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54f;
    }

    public float getPpcY() {
        return (float)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54f;
    }

    public float getDensity() {
        return (float)Toolkit.getDefaultToolkit().getScreenResolution() / 160.0f;
    }

    public boolean supportsDisplayModeChange() {
        return true;
    }

    public boolean setDisplayMode(Graphics.DisplayMode displayMode) {
        DisplayMode mode = ((LwjglDisplayMode)displayMode).mode;
        try {
            if (!mode.isFullscreenCapable()) {
                Display.setDisplayMode(mode);
            } else {
                Display.setDisplayModeAndFullscreen(mode);
            }
            if (Gdx.gl != null) {
                Gdx.gl.glViewport(0, 0, displayMode.width, displayMode.height);
            }
            this.config.width = displayMode.width;
            this.config.height = displayMode.height;
            this.resize = true;
            return true;
        }
        catch (LWJGLException e) {
            return false;
        }
    }

    public boolean setDisplayMode(int width, int height, boolean fullscreen) {
        if (this.getWidth() == width && this.getHeight() == height && Display.isFullscreen() == fullscreen) {
            return true;
        }
        try {
            DisplayMode targetDisplayMode = null;
            if (fullscreen) {
                DisplayMode[] modes = Display.getAvailableDisplayModes();
                int freq = 0;
                for (int i = 0; i < modes.length; ++i) {
                    DisplayMode current = modes[i];
                    if (current.getWidth() != width || current.getHeight() != height) continue;
                    if (!(targetDisplayMode != null && current.getFrequency() < freq || targetDisplayMode != null && current.getBitsPerPixel() <= targetDisplayMode.getBitsPerPixel())) {
                        targetDisplayMode = current;
                        freq = targetDisplayMode.getFrequency();
                    }
                    if (current.getBitsPerPixel() != Display.getDesktopDisplayMode().getBitsPerPixel() || current.getFrequency() != Display.getDesktopDisplayMode().getFrequency()) continue;
                    targetDisplayMode = current;
                    break;
                }
            } else {
                targetDisplayMode = new DisplayMode(width, height);
            }
            if (targetDisplayMode == null) {
                return false;
            }
            Display.setDisplayMode(targetDisplayMode);
            Display.setFullscreen(fullscreen);
            if (Gdx.gl != null) {
                Gdx.gl.glViewport(0, 0, targetDisplayMode.getWidth(), targetDisplayMode.getHeight());
            }
            this.config.width = targetDisplayMode.getWidth();
            this.config.height = targetDisplayMode.getHeight();
            this.resize = true;
            return true;
        }
        catch (LWJGLException e) {
            return false;
        }
    }

    public Graphics.DisplayMode[] getDisplayModes() {
        try {
            DisplayMode[] availableDisplayModes = Display.getAvailableDisplayModes();
            Graphics.DisplayMode[] modes = new Graphics.DisplayMode[availableDisplayModes.length];
            int idx = 0;
            for (DisplayMode mode : availableDisplayModes) {
                if (!mode.isFullscreenCapable()) continue;
                modes[idx++] = new LwjglDisplayMode(mode.getWidth(), mode.getHeight(), mode.getFrequency(), mode.getBitsPerPixel(), mode);
            }
            return modes;
        }
        catch (LWJGLException e) {
            throw new GdxRuntimeException("Couldn't fetch available display modes", (Throwable)e);
        }
    }

    public Graphics.DisplayMode getDesktopDisplayMode() {
        DisplayMode mode = Display.getDesktopDisplayMode();
        return new LwjglDisplayMode(mode.getWidth(), mode.getHeight(), mode.getFrequency(), mode.getBitsPerPixel(), mode);
    }

    public void setTitle(String title) {
        Display.setTitle(title);
    }

    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    public void setVSync(boolean vsync) {
        this.vsync = vsync;
        if (vsync && !this.config.useCPUSynch) {
            Display.setVSyncEnabled(true);
        }
        if (!vsync && !this.config.useCPUSynch) {
            Display.setVSyncEnabled(false);
        }
    }

    public boolean supportsExtension(String extension) {
        if (this.extensions == null) {
            this.extensions = Gdx.gl.glGetString(7939);
        }
        return this.extensions.contains(extension);
    }

    public LwjglApplicationConfiguration getConfig() {
        return this.config;
    }

    public void setContinuousRendering(boolean isContinuous) {
        this.isContinuous = isContinuous;
    }

    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRendering() {
        LwjglGraphics lwjglGraphics = this;
        synchronized (lwjglGraphics) {
            this.requestRendering = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRender() {
        LwjglGraphics lwjglGraphics = this;
        synchronized (lwjglGraphics) {
            boolean rq = this.requestRendering;
            this.requestRendering = false;
            return rq || this.isContinuous || Display.isDirty();
        }
    }

    public boolean isFullscreen() {
        return Display.isFullscreen();
    }

    private class LwjglDisplayMode
    extends Graphics.DisplayMode {
        DisplayMode mode;

        public LwjglDisplayMode(int width, int height, int refreshRate, int bitsPerPixel, DisplayMode mode) {
            super(width, height, refreshRate, bitsPerPixel);
            this.mode = mode;
        }
    }
}

