/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.utils.GdxNativesLoader;
import java.lang.reflect.Method;

final class LwjglNativesLoader {
    public static boolean load = true;

    LwjglNativesLoader() {
    }

    static void load() {
        GdxNativesLoader.load();
        if (GdxNativesLoader.disableNativesLoading) {
            return;
        }
        if (!load) {
            return;
        }
        if (GdxNativesLoader.isWindows) {
            GdxNativesLoader.extractLibrary((String)"OpenAL32.dll", (String)"OpenAL64.dll");
            GdxNativesLoader.extractLibrary((String)"lwjgl.dll", (String)"lwjgl64.dll");
        } else if (GdxNativesLoader.isMac) {
            GdxNativesLoader.extractLibrary((String)"openal.dylib", (String)"openal.dylib");
            GdxNativesLoader.extractLibrary((String)"liblwjgl.jnilib", (String)"liblwjgl.jnilib");
        } else if (GdxNativesLoader.isLinux) {
            GdxNativesLoader.extractLibrary((String)"libopenal.so", (String)"libopenal64.so");
            GdxNativesLoader.extractLibrary((String)"liblwjgl.so", (String)"liblwjgl64.so");
        }
        System.setProperty("org.lwjgl.librarypath", GdxNativesLoader.nativesDir.getAbsolutePath());
        load = false;
    }

    static {
        System.setProperty("org.lwjgl.input.Mouse.allowNegativeMouseCoords", "true");
        try {
            Method method = Class.forName("javax.jnlp.ServiceManager").getDeclaredMethod("lookup", String.class);
            method.invoke(null, "javax.jnlp.PersistenceService");
            load = false;
        }
        catch (Throwable ex) {
            load = true;
        }
    }
}

