/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.md5;

public class MD5AnimationInfo {
    int currFrame = 0;
    int nextFrame = 1;
    int maxFrame;
    float lastTime;
    float maxTime;

    public MD5AnimationInfo(int maxFrame, float maxTime) {
        this.maxFrame = maxFrame;
        this.maxTime = maxTime;
    }

    public void reset() {
        this.reset(this.maxFrame, this.maxTime);
    }

    public void reset(int maxFrame, float maxTime) {
        this.maxFrame = maxFrame;
        this.maxTime = maxTime;
        this.currFrame = 0;
        this.nextFrame = 1;
        this.lastTime = 0.0f;
    }

    public void update(float delta) {
        this.lastTime += delta;
        this.lastTime %= this.maxTime * (float)this.maxFrame;
        while (this.lastTime >= this.maxTime) {
            ++this.currFrame;
            ++this.nextFrame;
            this.lastTime -= this.maxTime;
            if (this.currFrame >= this.maxFrame) {
                this.currFrame = 0;
            }
            if (this.nextFrame < this.maxFrame) continue;
            this.nextFrame = 0;
        }
    }

    public int getCurrentFrame() {
        return this.currFrame;
    }

    public int getNextFrame() {
        return this.nextFrame;
    }

    public float getInterpolation() {
        return this.lastTime / this.maxTime;
    }
}

