/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect;

import android.content.Context;
import com.swarmconnect.SwarmLeaderboard;
import com.swarmconnect.SwarmLeaderboardScore;
import com.swarmconnect.SwarmNotification;
import com.swarmconnect.ao;

public class NotificationLeaderboard
extends SwarmNotification {
    public SwarmLeaderboardScore score;
    public SwarmLeaderboard.LeaderboardFormat format;

    protected NotificationLeaderboard(SwarmLeaderboardScore swarmLeaderboardScore, SwarmLeaderboard.LeaderboardFormat leaderboardFormat) {
        this.score = swarmLeaderboardScore;
        this.format = leaderboardFormat;
        this.type = SwarmNotification.NotificationType.LEADERBOARD;
    }

    @Override
    public int getIconId(Context context) {
        String string = context.getPackageName();
        return context.getResources().getIdentifier("@drawable/swarm_leaderboards_dark_sm", null, string);
    }

    @Override
    public String getTitle(Context context) {
        String string = context.getPackageName();
        return context.getString(context.getResources().getIdentifier("@string/score_submitted", null, string));
    }

    @Override
    public String getMessage(Context context) {
        if (this.format == SwarmLeaderboard.LeaderboardFormat.INTEGER) {
            return String.format(context.getString(ao.getResource("@string/your_score_int", context)), (int)this.score.score);
        }
        if (this.format == SwarmLeaderboard.LeaderboardFormat.FLOAT) {
            return String.format(context.getString(ao.getResource("@string/your_score_string", context)), Float.toString(this.score.score));
        }
        if (this.format == SwarmLeaderboard.LeaderboardFormat.TIME) {
            return String.format(context.getString(ao.getResource("@string/your_score_string", context)), String.format("%d:%02d:%02d", (int)this.score.score / 3600, (int)this.score.score % 3600 / 60, (int)this.score.score % 60));
        }
        return "";
    }
}

