/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect;

import android.content.Context;
import android.content.Intent;
import com.swarmconnect.APICall;
import com.swarmconnect.NotificationLeaderboard;
import com.swarmconnect.Swarm;
import com.swarmconnect.SwarmLeaderboardScore;
import com.swarmconnect.SwarmMainActivity;
import com.swarmconnect.SwarmUser;
import com.swarmconnect.am;
import com.swarmconnect.bk;
import com.swarmconnect.q;
import com.swarmconnect.s;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SwarmLeaderboard
implements Serializable {
    public int id;
    public String name;
    public LeaderboardFormat format;
    public int min_version;
    public int max_version;
    public Direction direction = Direction.DESC;
    public KeepScores keep_scores = KeepScores.BEST;
    public int keep_count = 1;

    public void showLeaderboard() {
        this.showLeaderboard(DateRange.WEEK);
    }

    public void showLeaderboard(DateRange dateRange) {
        if (Swarm.b != null) {
            Intent intent = new Intent((Context)Swarm.b, SwarmMainActivity.class);
            intent.putExtra("screenType", 7);
            intent.putExtra("leaderboard", (Serializable)this);
            intent.putExtra("dateRange", (Serializable)((Object)dateRange));
            Swarm.b.startActivity(intent);
        }
    }

    public static void showLeaderboard(int n2) {
        SwarmLeaderboard.showLeaderboard(n2, DateRange.WEEK);
    }

    public static void showLeaderboard(int n2, DateRange dateRange) {
        SwarmLeaderboard.getLeaderboardById(n2, new GotLeaderboardCB(){

            @Override
            public void gotLeaderboard(SwarmLeaderboard swarmLeaderboard) {
                if (swarmLeaderboard != null) {
                    swarmLeaderboard.showLeaderboard();
                }
            }
        });
    }

    public void submitScore(float f2) {
        this.submitScore(f2, "", null);
    }

    public void submitScore(float f2, String string) {
        this.submitScore(f2, string, null);
    }

    public void submitScore(final float f2, final String string, final SubmitScoreCB submitScoreCB) {
        if (!Swarm.isLoggedIn()) {
            return;
        }
        bk.a(new bk.a(){

            @Override
            public void gotConfig(bk bk2) {
                List<SwarmLeaderboardScore> list;
                if (!Swarm.isLoggedIn()) {
                    return;
                }
                SwarmLeaderboardScore swarmLeaderboardScore = new SwarmLeaderboardScore();
                boolean bl2 = false;
                swarmLeaderboardScore.user = Swarm.user;
                swarmLeaderboardScore.score = f2;
                swarmLeaderboardScore.timestamp = (int)(System.currentTimeMillis() / 1000L);
                swarmLeaderboardScore.rank = -1;
                if (bk2 != null) {
                    list = bk2.b(SwarmLeaderboard.this.id);
                    if (list == null) {
                        list = new ArrayList<SwarmLeaderboardScore>();
                    }
                    if (list.size() >= SwarmLeaderboard.this.keep_count) {
                        boolean bl3;
                        SwarmLeaderboard.this.a(list);
                        SwarmLeaderboardScore swarmLeaderboardScore2 = (SwarmLeaderboardScore)list.get(list.size() - 1);
                        boolean bl4 = bl3 = SwarmLeaderboard.this.direction == Direction.DESC && f2 >= swarmLeaderboardScore2.score || SwarmLeaderboard.this.direction == Direction.ASC && f2 <= swarmLeaderboardScore2.score;
                        if (SwarmLeaderboard.this.keep_scores == KeepScores.RECENT || SwarmLeaderboard.this.keep_scores == KeepScores.BEST && bl3) {
                            swarmLeaderboardScore2.score = f2;
                            swarmLeaderboardScore2.timestamp = (int)(System.currentTimeMillis() / 1000L);
                            bk2.a(SwarmLeaderboard.this.id, list);
                            bl2 = true;
                        }
                    } else {
                        list.add(swarmLeaderboardScore);
                        SwarmLeaderboard.this.a(list);
                        bk2.a(SwarmLeaderboard.this.id, list);
                        bl2 = true;
                    }
                }
                Swarm.a(new NotificationLeaderboard(swarmLeaderboardScore, SwarmLeaderboard.this.format));
                if (bl2) {
                    list = new com.swarmconnect.c();
                    ((com.swarmconnect.c)((Object)list)).leaderboardId = SwarmLeaderboard.this.id;
                    ((com.swarmconnect.c)((Object)list)).score = f2;
                    ((com.swarmconnect.c)((Object)list)).data = string;
                    ((com.swarmconnect.c)((Object)list)).cb = new APICall.APICallback(){

                        @Override
                        public void gotAPI(APICall aPICall) {
                            com.swarmconnect.c c2 = (com.swarmconnect.c)aPICall;
                            if (submitScoreCB != null) {
                                submitScoreCB.scoreSubmitted(c2.rank);
                            }
                        }

                        @Override
                        public void requestFailed() {
                            if (submitScoreCB != null) {
                                submitScoreCB.scoreSubmitted(-1);
                            }
                        }
                    };
                    ((APICall)((Object)list)).run();
                }
            }
        });
    }

    public static void submitScore(int n2, float f2) {
        SwarmLeaderboard.submitScore(n2, f2, null, null);
    }

    public static void submitScore(int n2, float f2, String string) {
        SwarmLeaderboard.submitScore(n2, f2, string, null);
    }

    public static void submitScore(int n2, final float f2, final String string, final SubmitScoreCB submitScoreCB) {
        SwarmLeaderboard.getLeaderboardById(n2, new GotLeaderboardCB(){

            @Override
            public void gotLeaderboard(SwarmLeaderboard swarmLeaderboard) {
                if (swarmLeaderboard != null) {
                    swarmLeaderboard.submitScore(f2, string, submitScoreCB);
                } else if (submitScoreCB != null) {
                    submitScoreCB.scoreSubmitted(-1);
                }
            }
        });
    }

    public static void submitScoreAndShowLeaderboard(int n2, float f2) {
        SwarmLeaderboard.submitScoreAndShowLeaderboard(n2, f2, null);
    }

    public static void submitScoreAndShowLeaderboard(int n2, final float f2, final String string) {
        SwarmLeaderboard.getLeaderboardById(n2, new GotLeaderboardCB(){

            @Override
            public void gotLeaderboard(final SwarmLeaderboard swarmLeaderboard) {
                if (swarmLeaderboard != null) {
                    swarmLeaderboard.submitScore(f2, string, new SubmitScoreCB(){

                        @Override
                        public void scoreSubmitted(int n2) {
                            swarmLeaderboard.showLeaderboard();
                        }
                    });
                }
            }
        });
    }

    public void getTopScores(DateRange dateRange, GotScoresCB gotScoresCB) {
        this.getPageOfScores(0, dateRange, SocialScope.ALL, gotScoresCB);
    }

    public void getPageOfScoresForCurrentUser(DateRange dateRange, GotScoresCB gotScoresCB) {
        this.getPageOfScores(-1, dateRange, SocialScope.ALL, gotScoresCB);
    }

    public void getPageOfScores(int n2, final DateRange dateRange, final SocialScope socialScope, final GotScoresCB gotScoresCB) {
        if (gotScoresCB == null) {
            return;
        }
        s s2 = new s();
        s2.pageNum = n2;
        s2.leaderboardId = this.id;
        s2.time = dateRange;
        s2.scope = socialScope;
        s2.cb = new APICall.APICallback(){

            @Override
            public void gotAPI(APICall aPICall) {
                s s2 = (s)aPICall;
                gotScoresCB.gotScores(s2.pageNum, s2.scores);
            }

            @Override
            public void requestFailed() {
                if (socialScope == SocialScope.SELF) {
                    bk.a(new bk.a(){

                        @Override
                        public void gotConfig(bk bk2) {
                            if (bk2 != null) {
                                gotScoresCB.gotScores(0, bk2.a((this).SwarmLeaderboard.this.id, dateRange));
                            } else {
                                gotScoresCB.gotScores(0, null);
                            }
                        }
                    });
                } else {
                    gotScoresCB.gotScores(-1, null);
                }
            }
        };
        s2.run();
    }

    public void getScoreForUser(final int n2, final GotScoreCB gotScoreCB) {
        if (gotScoreCB == null) {
            return;
        }
        q q2 = new q();
        q2.scoreUserId = n2;
        q2.leaderboardId = this.id;
        q2.cb = new APICall.APICallback(){

            @Override
            public void gotAPI(APICall aPICall) {
                q q2 = (q)aPICall;
                gotScoreCB.gotScore(q2.score);
            }

            @Override
            public void requestFailed() {
                if (Swarm.user != null && Swarm.user.userId == n2) {
                    bk.a(new bk.a(){

                        @Override
                        public void gotConfig(bk bk2) {
                            List<SwarmLeaderboardScore> list = bk2.a((this).SwarmLeaderboard.this.id, DateRange.ALL);
                            if (list != null && list.size() > 0) {
                                SwarmLeaderboard.this.a(list);
                                gotScoreCB.gotScore(list.get(0));
                            } else {
                                gotScoreCB.gotScore(null);
                            }
                        }
                    });
                } else {
                    gotScoreCB.gotScore(null);
                }
            }
        };
        q2.run();
    }

    public void getScoreForUser(SwarmUser swarmUser, GotScoreCB gotScoreCB) {
        if (swarmUser != null) {
            this.getScoreForUser(swarmUser.userId, gotScoreCB);
        } else if (gotScoreCB != null) {
            gotScoreCB.gotScore(null);
        }
    }

    public static void getLeaderboardById(final int n2, final GotLeaderboardCB gotLeaderboardCB) {
        if (gotLeaderboardCB == null) {
            return;
        }
        am.a(new am.a(){

            @Override
            public void gotConfig(am am2) {
                if (am2 != null) {
                    gotLeaderboardCB.gotLeaderboard(am2.a(n2));
                } else {
                    gotLeaderboardCB.gotLeaderboard(null);
                }
            }
        });
    }

    public static void getLeaderboardsList(final GotLeaderboardsListCB gotLeaderboardsListCB) {
        if (gotLeaderboardsListCB == null) {
            return;
        }
        am.a(new am.a(){

            @Override
            public void gotConfig(am am2) {
                if (am2 != null) {
                    gotLeaderboardsListCB.gotList(am2.b());
                } else {
                    gotLeaderboardsListCB.gotList(null);
                }
            }
        });
    }

    private void a(List<SwarmLeaderboardScore> list) {
        if (list == null) {
            return;
        }
        if (this.keep_scores == KeepScores.BEST) {
            if (this.direction == Direction.ASC) {
                Collections.sort(list, new a());
            } else if (this.direction == Direction.DESC) {
                Collections.sort(list, new b());
            }
        } else if (this.keep_scores == KeepScores.RECENT) {
            Collections.sort(list, new c());
        }
        int n2 = 0;
        while (n2 < list.size()) {
            SwarmLeaderboardScore swarmLeaderboardScore = list.get(n2);
            swarmLeaderboardScore.rank = n2 + 1;
            ++n2;
        }
    }

    public static enum DateRange {
        TODAY,
        WEEK,
        MONTH,
        ALL;

    }

    public static enum Direction {
        DESC,
        ASC;

    }

    public static abstract class GotLeaderboardCB {
        public abstract void gotLeaderboard(SwarmLeaderboard var1);
    }

    public static abstract class GotLeaderboardsListCB {
        public abstract void gotList(List<SwarmLeaderboard> var1);
    }

    public static abstract class GotScoreCB {
        public abstract void gotScore(SwarmLeaderboardScore var1);
    }

    public static abstract class GotScoresCB {
        public abstract void gotScores(int var1, List<SwarmLeaderboardScore> var2);
    }

    public static enum KeepScores {
        BEST,
        RECENT;

    }

    public static enum LeaderboardFormat {
        INTEGER,
        FLOAT,
        TIME;

    }

    public static enum SocialScope {
        SELF,
        FRIENDS,
        ALL;

    }

    private class a
    implements Comparator<SwarmLeaderboardScore> {
        private a() {
        }

        @Override
        public int compare(SwarmLeaderboardScore swarmLeaderboardScore, SwarmLeaderboardScore swarmLeaderboardScore2) {
            return swarmLeaderboardScore.score > swarmLeaderboardScore2.score ? 1 : (swarmLeaderboardScore == swarmLeaderboardScore2 ? 0 : -1);
        }
    }

    private class b
    implements Comparator<SwarmLeaderboardScore> {
        private b() {
        }

        @Override
        public int compare(SwarmLeaderboardScore swarmLeaderboardScore, SwarmLeaderboardScore swarmLeaderboardScore2) {
            return swarmLeaderboardScore.score > swarmLeaderboardScore2.score ? -1 : (swarmLeaderboardScore == swarmLeaderboardScore2 ? 0 : 1);
        }
    }

    private class c
    implements Comparator<SwarmLeaderboardScore> {
        private c() {
        }

        @Override
        public int compare(SwarmLeaderboardScore swarmLeaderboardScore, SwarmLeaderboardScore swarmLeaderboardScore2) {
            return swarmLeaderboardScore.timestamp > swarmLeaderboardScore2.timestamp ? -1 : (swarmLeaderboardScore == swarmLeaderboardScore2 ? 0 : 1);
        }
    }

    public static abstract class SubmitScoreCB {
        public abstract void scoreSubmitted(int var1);
    }
}

