/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.TextView;
import com.swarmconnect.APICall;
import com.swarmconnect.NotificationPurchase;
import com.swarmconnect.Swarm;
import com.swarmconnect.SwarmActiveUser;
import com.swarmconnect.SwarmStore;
import com.swarmconnect.SwarmStoreItem;
import com.swarmconnect.ah;
import com.swarmconnect.ao;
import com.swarmconnect.ui.AsyncImageView;
import java.io.Serializable;

public class SwarmStoreListing
implements Serializable {
    public static final int PURCHASE_FAILED_ALREADY_PURCHASED = -1006;
    public static final int PURCHASE_FAILED_NO_INTERNET = -1005;
    public static final int PURCHASE_FAILED_OTHER = -1004;
    public static final int PURCHASE_FAILED_INVALID_ITEM = -1003;
    public static final int PURCHASE_FAILED_INVALID_STORE = -1002;
    public static final int PURCHASE_FAILED_NO_COINS = -1001;
    public static final int PURCHASE_CANCELED = -1000;
    public static final int PURCHASE_SUCCESS = 1;
    public int id;
    public SwarmStoreItem item;
    public String title;
    public int price;
    public int quantity;
    public String imageUrl;
    public int orderId;

    public void purchase(final Context context, final ItemPurchaseCB itemPurchaseCB) {
        if (!Swarm.isOnline()) {
            if (itemPurchaseCB != null) {
                itemPurchaseCB.purchaseFailed(-1005);
            }
            return;
        }
        final Dialog dialog = new Dialog(context, ao.getResource("@style/ActivityDialog", context));
        dialog.requestWindowFeature(1);
        dialog.setContentView(ao.getResource("@layout/swarm_purchase_popup", context));
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                if (itemPurchaseCB != null) {
                    itemPurchaseCB.purchaseFailed(-1000);
                }
            }
        });
        ((TextView)dialog.findViewById(ao.getResource("@id/purchase", context))).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SwarmStoreListing.this.a(context, itemPurchaseCB);
                dialog.dismiss();
            }
        });
        ((TextView)dialog.findViewById(ao.getResource("@id/cancel", context))).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.cancel();
            }
        });
        ((TextView)dialog.findViewById(ao.getResource("@id/title", context))).setText((CharSequence)this.title);
        ((TextView)dialog.findViewById(ao.getResource("@id/desc", context))).setText((CharSequence)String.format(context.getString(ao.getResource("@string/pur_purchase_for_price_coins", context)), this.price));
        ((TextView)dialog.findViewById(ao.getResource("@id/coins", context))).setText((CharSequence)("" + this.price));
        if (this.imageUrl != null && this.imageUrl.length() > 0) {
            ((AsyncImageView)dialog.findViewById(ao.getResource("@id/image", context))).getUrl(this.imageUrl);
        }
        final TextView textView = (TextView)dialog.findViewById(ao.getResource("@id/desc", context));
        final TextView textView2 = (TextView)dialog.findViewById(ao.getResource("@id/purchase", context));
        Swarm.user.getCoins(new SwarmActiveUser.GotUserCoinsCB(){

            @Override
            public void gotCoins(int n2) {
                if (n2 < SwarmStoreListing.this.price) {
                    textView.setText((CharSequence)context.getString(ao.getResource("@string/pur_need_more_coins", context)));
                    textView2.setText((CharSequence)"Get Coins");
                    textView2.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Swarm.showGetCoins();
                            dialog.cancel();
                        }
                    });
                }
            }
        });
        dialog.show();
    }

    public static void purchase(Context context, int n2) {
        SwarmStoreListing.purchase(context, n2, null);
    }

    public static void purchase(final Context context, int n2, final ItemPurchaseCB itemPurchaseCB) {
        SwarmStore.getListingById(n2, new SwarmStore.GotStoreListingCB(){

            @Override
            public void gotStoreListing(SwarmStoreListing swarmStoreListing) {
                if (swarmStoreListing != null) {
                    swarmStoreListing.purchase(context, new ItemPurchaseCB(){

                        @Override
                        public void purchaseSuccess() {
                            if (itemPurchaseCB != null) {
                                itemPurchaseCB.purchaseSuccess();
                            }
                        }

                        @Override
                        public void purchaseFailed(int n2) {
                            if (itemPurchaseCB != null) {
                                itemPurchaseCB.purchaseFailed(n2);
                            }
                        }
                    });
                } else if (itemPurchaseCB != null) {
                    itemPurchaseCB.purchaseFailed(-1004);
                }
            }
        });
    }

    private void a(final Context context, final ItemPurchaseCB itemPurchaseCB) {
        Swarm.a(String.format(context.getString(ao.getResource("@string/pur_purchasing_title", context)), this.title));
        ah ah2 = new ah();
        ah2.listingId = this.id;
        ah2.cb = new APICall.APICallback(){

            @Override
            public void gotAPI(APICall aPICall) {
                Swarm.e();
                ah ah2 = (ah)aPICall;
                if (itemPurchaseCB != null) {
                    if (ah2.purchaseStatus == 1) {
                        Swarm.a(new NotificationPurchase(SwarmStoreListing.this));
                        itemPurchaseCB.purchaseSuccess();
                    } else {
                        Swarm.b(SwarmStoreListing.this.a(ah2.purchaseStatus, context));
                        itemPurchaseCB.purchaseFailed(ah2.purchaseStatus);
                    }
                }
            }

            @Override
            public void requestFailed() {
                Swarm.e();
                Swarm.b(context.getString(ao.getResource("@string/sto_no_internet", context)));
                if (itemPurchaseCB != null) {
                    itemPurchaseCB.purchaseFailed(-1005);
                }
            }
        };
        ah2.run();
    }

    private String a(int n2, Context context) {
        switch (n2) {
            case -1000: {
                return context.getString(ao.getResource("@string/sto_purchase_canceled", context));
            }
            case -1001: {
                return context.getString(ao.getResource("@string/sto_no_coins", context));
            }
            case -1002: {
                return context.getString(ao.getResource("@string/sto_invalid_store", context));
            }
            case -1003: {
                return context.getString(ao.getResource("@string/sto_invalid_item", context));
            }
            case -1004: {
                return context.getString(ao.getResource("@string/sto_failed_other", context));
            }
            case -1005: {
                return context.getString(ao.getResource("@string/sto_no_internet", context));
            }
            case -1006: {
                return context.getString(ao.getResource("@string/sto_already_purchased", context));
            }
        }
        return context.getString(ao.getResource("@string/sto_failed_other", context));
    }

    public static abstract class ItemPurchaseCB {
        public abstract void purchaseSuccess();

        public abstract void purchaseFailed(int var1);
    }
}

