/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson;

import com.swarmconnect.gson.FieldNamingPolicy;
import com.swarmconnect.gson.FieldNamingStrategy;
import com.swarmconnect.gson.InstanceCreator;
import com.swarmconnect.gson.JsonDeserializationContext;
import com.swarmconnect.gson.JsonElement;
import com.swarmconnect.gson.JsonIOException;
import com.swarmconnect.gson.JsonNull;
import com.swarmconnect.gson.JsonParseException;
import com.swarmconnect.gson.JsonSerializationContext;
import com.swarmconnect.gson.JsonSyntaxException;
import com.swarmconnect.gson.LongSerializationPolicy;
import com.swarmconnect.gson.TypeAdapter;
import com.swarmconnect.gson.TypeAdapterFactory;
import com.swarmconnect.gson.internal.ConstructorConstructor;
import com.swarmconnect.gson.internal.Excluder;
import com.swarmconnect.gson.internal.Primitives;
import com.swarmconnect.gson.internal.Streams;
import com.swarmconnect.gson.internal.bind.ArrayTypeAdapter;
import com.swarmconnect.gson.internal.bind.CollectionTypeAdapterFactory;
import com.swarmconnect.gson.internal.bind.DateTypeAdapter;
import com.swarmconnect.gson.internal.bind.JsonTreeReader;
import com.swarmconnect.gson.internal.bind.JsonTreeWriter;
import com.swarmconnect.gson.internal.bind.MapTypeAdapterFactory;
import com.swarmconnect.gson.internal.bind.ObjectTypeAdapter;
import com.swarmconnect.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.swarmconnect.gson.internal.bind.SqlDateTypeAdapter;
import com.swarmconnect.gson.internal.bind.TimeTypeAdapter;
import com.swarmconnect.gson.internal.bind.TypeAdapters;
import com.swarmconnect.gson.reflect.TypeToken;
import com.swarmconnect.gson.stream.JsonReader;
import com.swarmconnect.gson.stream.JsonToken;
import com.swarmconnect.gson.stream.JsonWriter;
import com.swarmconnect.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Gson {
    private final ThreadLocal<Map<TypeToken<?>, a<?>>> c = new ThreadLocal<Map<TypeToken<?>, a<?>>>(){

        protected Map<TypeToken<?>, a<?>> a() {
            return new HashMap();
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.a();
        }
    };
    private final Map<TypeToken<?>, TypeAdapter<?>> d = Collections.synchronizedMap(new HashMap());
    private final List<TypeAdapterFactory> e;
    private final ConstructorConstructor f;
    private final boolean g;
    private final boolean h;
    private final boolean i;
    private final boolean j;
    final JsonDeserializationContext a = new JsonDeserializationContext(){

        @Override
        public <T> T deserialize(JsonElement jsonElement, Type type) throws JsonParseException {
            return Gson.this.fromJson(jsonElement, type);
        }
    };
    final JsonSerializationContext b = new JsonSerializationContext(){

        public JsonElement serialize(Object object) {
            return Gson.this.toJsonTree(object);
        }

        public JsonElement serialize(Object object, Type type) {
            return Gson.this.toJsonTree(object, type);
        }
    };

    public Gson() {
        this(Excluder.DEFAULT, FieldNamingPolicy.IDENTITY, Collections.emptyMap(), false, false, false, true, false, false, LongSerializationPolicy.DEFAULT, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> map, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, LongSerializationPolicy longSerializationPolicy, List<TypeAdapterFactory> list) {
        this.f = new ConstructorConstructor(map);
        this.g = bl2;
        this.i = bl4;
        this.h = bl5;
        this.j = bl6;
        ArrayList<TypeAdapterFactory> arrayList = new ArrayList<TypeAdapterFactory>();
        arrayList.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        arrayList.add(ObjectTypeAdapter.FACTORY);
        arrayList.addAll(list);
        arrayList.add(TypeAdapters.STRING_FACTORY);
        arrayList.add(TypeAdapters.INTEGER_FACTORY);
        arrayList.add(TypeAdapters.BOOLEAN_FACTORY);
        arrayList.add(TypeAdapters.BYTE_FACTORY);
        arrayList.add(TypeAdapters.SHORT_FACTORY);
        arrayList.add(TypeAdapters.newFactory(Long.TYPE, Long.class, this.a(longSerializationPolicy)));
        arrayList.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.a(bl7)));
        arrayList.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.b(bl7)));
        arrayList.add(TypeAdapters.NUMBER_FACTORY);
        arrayList.add(TypeAdapters.CHARACTER_FACTORY);
        arrayList.add(TypeAdapters.STRING_BUILDER_FACTORY);
        arrayList.add(TypeAdapters.STRING_BUFFER_FACTORY);
        arrayList.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        arrayList.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        arrayList.add(TypeAdapters.URL_FACTORY);
        arrayList.add(TypeAdapters.URI_FACTORY);
        arrayList.add(TypeAdapters.UUID_FACTORY);
        arrayList.add(TypeAdapters.LOCALE_FACTORY);
        arrayList.add(TypeAdapters.INET_ADDRESS_FACTORY);
        arrayList.add(TypeAdapters.BIT_SET_FACTORY);
        arrayList.add(DateTypeAdapter.FACTORY);
        arrayList.add(TypeAdapters.CALENDAR_FACTORY);
        arrayList.add(TimeTypeAdapter.FACTORY);
        arrayList.add(SqlDateTypeAdapter.FACTORY);
        arrayList.add(TypeAdapters.TIMESTAMP_FACTORY);
        arrayList.add(ArrayTypeAdapter.FACTORY);
        arrayList.add(TypeAdapters.ENUM_FACTORY);
        arrayList.add(TypeAdapters.CLASS_FACTORY);
        arrayList.add(excluder);
        arrayList.add(new CollectionTypeAdapterFactory(this.f));
        arrayList.add(new MapTypeAdapterFactory(this.f, bl3));
        arrayList.add(new ReflectiveTypeAdapterFactory(this.f, fieldNamingStrategy, excluder));
        this.e = Collections.unmodifiableList(arrayList);
    }

    private TypeAdapter<Number> a(boolean bl2) {
        if (bl2) {
            return TypeAdapters.DOUBLE;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Double read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                double d2 = number.doubleValue();
                Gson.this.a(d2);
                jsonWriter.value(number);
            }
        };
    }

    private TypeAdapter<Number> b(boolean bl2) {
        if (bl2) {
            return TypeAdapters.FLOAT;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Float read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                float f2 = number.floatValue();
                Gson.this.a(f2);
                jsonWriter.value(number);
            }
        };
    }

    private void a(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(d2 + " is not a valid double value as per JSON specification. To override this" + " behavior, use GsonBuilder.serializeSpecialDoubleValues() method.");
        }
    }

    private TypeAdapter<Number> a(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextLong();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(number.toString());
            }
        };
    }

    public <T> TypeAdapter<T> getAdapter(TypeToken<T> typeToken) {
        TypeAdapter<?> typeAdapter = this.d.get(typeToken);
        if (typeAdapter != null) {
            return typeAdapter;
        }
        Map<TypeToken<?>, a<?>> map = this.c.get();
        a<?> a2 = map.get(typeToken);
        if (a2 != null) {
            return a2;
        }
        a<T> a3 = new a<T>();
        map.put(typeToken, a3);
        try {
            for (TypeAdapterFactory typeAdapterFactory : this.e) {
                TypeAdapter<T> typeAdapter2 = typeAdapterFactory.create(this, typeToken);
                if (typeAdapter2 == null) continue;
                a3.setDelegate(typeAdapter2);
                this.d.put(typeToken, typeAdapter2);
                TypeAdapter<T> typeAdapter3 = typeAdapter2;
                return typeAdapter3;
            }
            throw new IllegalArgumentException("GSON cannot handle " + typeToken);
        }
        finally {
            map.remove(typeToken);
        }
    }

    public <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken<T> typeToken) {
        boolean bl2 = false;
        for (TypeAdapterFactory typeAdapterFactory2 : this.e) {
            if (!bl2) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl2 = true;
                continue;
            }
            TypeAdapter<T> typeAdapter = typeAdapterFactory2.create(this, typeToken);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + typeToken);
    }

    public <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public JsonElement toJsonTree(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        return this.toJsonTree(object, object.getClass());
    }

    public JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public String toJson(Object object) {
        if (object == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        return this.toJson(object, object.getClass());
    }

    public String toJson(Object object, Type type) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, type, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(Object object, Appendable appendable) throws JsonIOException {
        if (object != null) {
            this.toJson(object, object.getClass(), appendable);
        } else {
            this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
        }
    }

    public void toJson(Object object, Type type, Appendable appendable) throws JsonIOException {
        try {
            JsonWriter jsonWriter = this.a(Streams.writerForAppendable(appendable));
            this.toJson(object, type, jsonWriter);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public void toJson(Object object, Type type, JsonWriter jsonWriter) throws JsonIOException {
        TypeAdapter<?> typeAdapter = this.getAdapter(TypeToken.get(type));
        boolean bl2 = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl3 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.h);
        boolean bl4 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.g);
        try {
            typeAdapter.write(jsonWriter, object);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        finally {
            jsonWriter.setLenient(bl2);
            jsonWriter.setHtmlSafe(bl3);
            jsonWriter.setSerializeNulls(bl4);
        }
    }

    public String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    public void toJson(JsonElement jsonElement, Appendable appendable) throws JsonIOException {
        try {
            JsonWriter jsonWriter = this.a(Streams.writerForAppendable(appendable));
            this.toJson(jsonElement, jsonWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private JsonWriter a(Writer writer) throws IOException {
        if (this.i) {
            writer.write(")]}'\n");
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        if (this.j) {
            jsonWriter.setIndent("  ");
        }
        jsonWriter.setSerializeNulls(this.g);
        return jsonWriter;
    }

    public void toJson(JsonElement jsonElement, JsonWriter jsonWriter) throws JsonIOException {
        boolean bl2 = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl3 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.h);
        boolean bl4 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.g);
        try {
            Streams.write(jsonElement, jsonWriter);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        finally {
            jsonWriter.setLenient(bl2);
            jsonWriter.setHtmlSafe(bl3);
            jsonWriter.setSerializeNulls(bl4);
        }
    }

    public <T> T fromJson(String string, Class<T> clazz) throws JsonSyntaxException {
        T t2 = this.fromJson(string, (Type)clazz);
        return Primitives.wrap(clazz).cast(t2);
    }

    public <T> T fromJson(String string, Type type) throws JsonSyntaxException {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        T t2 = this.fromJson((Reader)stringReader, type);
        return t2;
    }

    public <T> T fromJson(Reader reader, Class<T> clazz) throws JsonSyntaxException, JsonIOException {
        JsonReader jsonReader = new JsonReader(reader);
        T t2 = this.fromJson(jsonReader, clazz);
        Gson.a(t2, jsonReader);
        return Primitives.wrap(clazz).cast(t2);
    }

    public <T> T fromJson(Reader reader, Type type) throws JsonIOException, JsonSyntaxException {
        JsonReader jsonReader = new JsonReader(reader);
        T t2 = this.fromJson(jsonReader, type);
        Gson.a(t2, jsonReader);
        return t2;
    }

    private static void a(Object object, JsonReader jsonReader) {
        try {
            if (object != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public <T> T fromJson(JsonReader jsonReader, Type type) throws JsonIOException, JsonSyntaxException {
        boolean bl2 = true;
        boolean bl3 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            jsonReader.peek();
            bl2 = false;
            TypeAdapter<?> typeAdapter = this.getAdapter(TypeToken.get(type));
            Object obj = typeAdapter.read(jsonReader);
            return (T)obj;
        }
        catch (EOFException eOFException) {
            if (bl2) {
                T t2 = null;
                return t2;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        finally {
            jsonReader.setLenient(bl3);
        }
    }

    public <T> T fromJson(JsonElement jsonElement, Class<T> clazz) throws JsonSyntaxException {
        T t2 = this.fromJson(jsonElement, (Type)clazz);
        return Primitives.wrap(clazz).cast(t2);
    }

    public <T> T fromJson(JsonElement jsonElement, Type type) throws JsonSyntaxException {
        if (jsonElement == null) {
            return null;
        }
        return this.fromJson(new JsonTreeReader(jsonElement), type);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{").append("serializeNulls:").append(this.g).append("factories:").append(this.e).append(",instanceCreators:").append(this.f).append("}");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class a<T>
    extends TypeAdapter<T> {
        private TypeAdapter<T> a;

        a() {
        }

        public void setDelegate(TypeAdapter<T> typeAdapter) {
            if (this.a != null) {
                throw new AssertionError();
            }
            this.a = typeAdapter;
        }

        @Override
        public T read(JsonReader jsonReader) throws IOException {
            if (this.a == null) {
                throw new IllegalStateException();
            }
            return this.a.read(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, T t2) throws IOException {
            if (this.a == null) {
                throw new IllegalStateException();
            }
            this.a.write(jsonWriter, t2);
        }
    }
}

