/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson;

import com.swarmconnect.gson.JsonElement;
import com.swarmconnect.gson.JsonIOException;
import com.swarmconnect.gson.JsonParseException;
import com.swarmconnect.gson.JsonSyntaxException;
import com.swarmconnect.gson.internal.Streams;
import com.swarmconnect.gson.stream.JsonReader;
import com.swarmconnect.gson.stream.JsonToken;
import com.swarmconnect.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader a;
    private final Object b;

    public JsonStreamParser(String string) {
        this(new StringReader(string));
    }

    public JsonStreamParser(Reader reader) {
        this.a = new JsonReader(reader);
        this.a.setLenient(true);
        this.b = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.a);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new JsonParseException("Failed parsing JSON source to Json", stackOverflowError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JsonParseException("Failed parsing JSON source to Json", outOfMemoryError);
        }
        catch (JsonParseException jsonParseException) {
            throw jsonParseException.getCause() instanceof EOFException ? new NoSuchElementException() : jsonParseException;
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.b;
        synchronized (object) {
            try {
                return this.a.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException malformedJsonException) {
                throw new JsonSyntaxException(malformedJsonException);
            }
            catch (IOException iOException) {
                throw new JsonIOException(iOException);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

