/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson.internal;

import com.swarmconnect.gson.InstanceCreator;
import com.swarmconnect.gson.internal.ObjectConstructor;
import com.swarmconnect.gson.internal.UnsafeAllocator;
import com.swarmconnect.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> a;

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> map) {
        this.a = map;
    }

    public ConstructorConstructor() {
        this(Collections.emptyMap());
    }

    public <T> ObjectConstructor<T> get(TypeToken<T> typeToken) {
        final Type type = typeToken.getType();
        Class<T> clazz = typeToken.getRawType();
        final InstanceCreator<?> instanceCreator = this.a.get(type);
        if (instanceCreator != null) {
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return instanceCreator.createInstance(type);
                }
            };
        }
        ObjectConstructor<T> objectConstructor = this.a(clazz);
        if (objectConstructor != null) {
            return objectConstructor;
        }
        ObjectConstructor<T> objectConstructor2 = this.b(clazz);
        if (objectConstructor2 != null) {
            return objectConstructor2;
        }
        return this.a(type, clazz);
    }

    private <T> ObjectConstructor<T> a(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    try {
                        Object[] objectArray = null;
                        return constructor.newInstance(objectArray);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new RuntimeException("Failed to invoke " + constructor + " with no args", instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException("Failed to invoke " + constructor + " with no args", invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> ObjectConstructor<T> b(Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new TreeSet();
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new ObjectConstructor<T>(){

                    @Override
                    public T construct() {
                        return new LinkedList();
                    }
                };
            }
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new ObjectConstructor<T>(){

                @Override
                public T construct() {
                    return new LinkedHashMap();
                }
            };
        }
        return null;
    }

    private <T> ObjectConstructor<T> a(final Type type, final Class<? super T> clazz) {
        return new ObjectConstructor<T>(){
            private final UnsafeAllocator d = UnsafeAllocator.create();

            @Override
            public T construct() {
                try {
                    Object t2 = this.d.newInstance(clazz);
                    return t2;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to invoke no-args constructor for " + type + ". " + "Register an InstanceCreator with Gson for this type may fix this problem.", exception);
                }
            }
        };
    }

    public String toString() {
        return this.a.toString();
    }
}

