/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson.internal.bind;

import com.swarmconnect.gson.Gson;
import com.swarmconnect.gson.JsonSyntaxException;
import com.swarmconnect.gson.TypeAdapter;
import com.swarmconnect.gson.TypeAdapterFactory;
import com.swarmconnect.gson.reflect.TypeToken;
import com.swarmconnect.gson.stream.JsonReader;
import com.swarmconnect.gson.stream.JsonToken;
import com.swarmconnect.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new DateTypeAdapter() : null;
        }
    };
    private final DateFormat a = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat b = DateFormat.getDateTimeInstance(2, 2);
    private final DateFormat c = DateTypeAdapter.a();

    private static DateFormat a() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    @Override
    public Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return this.a(jsonReader.nextString());
    }

    private synchronized Date a(String string) {
        try {
            return this.b.parse(string);
        }
        catch (ParseException parseException) {
            try {
                return this.a.parse(string);
            }
            catch (ParseException parseException2) {
                try {
                    return this.c.parse(string);
                }
                catch (ParseException parseException3) {
                    throw new JsonSyntaxException(string, parseException3);
                }
            }
        }
    }

    @Override
    public synchronized void write(JsonWriter jsonWriter, Date date) throws IOException {
        if (date == null) {
            jsonWriter.nullValue();
            return;
        }
        String string = this.a.format(date);
        jsonWriter.value(string);
    }
}

