/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson.internal.bind;

import com.swarmconnect.gson.JsonArray;
import com.swarmconnect.gson.JsonElement;
import com.swarmconnect.gson.JsonNull;
import com.swarmconnect.gson.JsonObject;
import com.swarmconnect.gson.JsonPrimitive;
import com.swarmconnect.gson.stream.JsonReader;
import com.swarmconnect.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JsonTreeReader
extends JsonReader {
    private static final Reader a = new Reader(){

        public int read(char[] cArray, int n2, int n3) throws IOException {
            throw new AssertionError();
        }

        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private static final Object b = new Object();
    private final List<Object> c = new ArrayList<Object>();

    public JsonTreeReader(JsonElement jsonElement) {
        super(a);
        this.c.add(jsonElement);
    }

    public void beginArray() throws IOException {
        this.a(JsonToken.BEGIN_ARRAY);
        JsonArray jsonArray = (JsonArray)this.a();
        this.c.add(jsonArray.iterator());
    }

    public void endArray() throws IOException {
        this.a(JsonToken.END_ARRAY);
        this.b();
        this.b();
    }

    public void beginObject() throws IOException {
        this.a(JsonToken.BEGIN_OBJECT);
        JsonObject jsonObject = (JsonObject)this.a();
        this.c.add(jsonObject.entrySet().iterator());
    }

    public void endObject() throws IOException {
        this.a(JsonToken.END_OBJECT);
        this.b();
        this.b();
    }

    public boolean hasNext() throws IOException {
        JsonToken jsonToken = this.peek();
        return jsonToken != JsonToken.END_OBJECT && jsonToken != JsonToken.END_ARRAY;
    }

    public JsonToken peek() throws IOException {
        if (this.c.isEmpty()) {
            return JsonToken.END_DOCUMENT;
        }
        Object object = this.a();
        if (object instanceof Iterator) {
            boolean bl2 = this.c.get(this.c.size() - 2) instanceof JsonObject;
            Iterator iterator = (Iterator)object;
            if (iterator.hasNext()) {
                if (bl2) {
                    return JsonToken.NAME;
                }
                this.c.add(iterator.next());
                return this.peek();
            }
            return bl2 ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
        }
        if (object instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (object instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (object instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
            if (jsonPrimitive.isString()) {
                return JsonToken.STRING;
            }
            if (jsonPrimitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (jsonPrimitive.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (object instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (object == b) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw new AssertionError();
    }

    private Object a() {
        return this.c.get(this.c.size() - 1);
    }

    private Object b() {
        return this.c.remove(this.c.size() - 1);
    }

    private void a(JsonToken jsonToken) throws IOException {
        if (this.peek() != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()));
        }
    }

    public String nextName() throws IOException {
        this.a(JsonToken.NAME);
        Iterator iterator = (Iterator)this.a();
        Map.Entry entry = (Map.Entry)iterator.next();
        this.c.add(entry.getValue());
        return (String)entry.getKey();
    }

    public String nextString() throws IOException {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.STRING && jsonToken != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.STRING) + " but was " + (Object)((Object)jsonToken));
        }
        return ((JsonPrimitive)this.b()).getAsString();
    }

    public boolean nextBoolean() throws IOException {
        this.a(JsonToken.BOOLEAN);
        return ((JsonPrimitive)this.b()).getAsBoolean();
    }

    public void nextNull() throws IOException {
        this.a(JsonToken.NULL);
        this.b();
    }

    public double nextDouble() throws IOException {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken));
        }
        double d2 = ((JsonPrimitive)this.a()).getAsDouble();
        if (!this.isLenient() && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new NumberFormatException("JSON forbids NaN and infinities: " + d2);
        }
        this.b();
        return d2;
    }

    public long nextLong() throws IOException {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken));
        }
        long l2 = ((JsonPrimitive)this.a()).getAsLong();
        this.b();
        return l2;
    }

    public int nextInt() throws IOException {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken));
        }
        int n2 = ((JsonPrimitive)this.a()).getAsInt();
        this.b();
        return n2;
    }

    public void close() throws IOException {
        this.c.clear();
        this.c.add(b);
    }

    public void skipValue() throws IOException {
        if (this.peek() == JsonToken.NAME) {
            this.nextName();
        } else {
            this.b();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void promoteNameToValue() throws IOException {
        this.a(JsonToken.NAME);
        Iterator iterator = (Iterator)this.a();
        Map.Entry entry = (Map.Entry)iterator.next();
        this.c.add(entry.getValue());
        this.c.add(new JsonPrimitive((String)entry.getKey()));
    }
}

