/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson.internal.bind;

import com.swarmconnect.gson.Gson;
import com.swarmconnect.gson.TypeAdapter;
import com.swarmconnect.gson.TypeAdapterFactory;
import com.swarmconnect.gson.internal.StringMap;
import com.swarmconnect.gson.reflect.TypeToken;
import com.swarmconnect.gson.stream.JsonReader;
import com.swarmconnect.gson.stream.JsonToken;
import com.swarmconnect.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() == Object.class) {
                return new ObjectTypeAdapter(gson);
            }
            return null;
        }
    };
    private final Gson a;

    private ObjectTypeAdapter(Gson gson) {
        this.a = gson;
    }

    @Override
    public Object read(JsonReader jsonReader) throws IOException {
        JsonToken jsonToken = jsonReader.peek();
        switch (jsonToken) {
            case BEGIN_ARRAY: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    arrayList.add(this.read(jsonReader));
                }
                jsonReader.endArray();
                return arrayList;
            }
            case BEGIN_OBJECT: {
                StringMap<Object> stringMap = new StringMap<Object>();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    stringMap.put(jsonReader.nextName(), this.read(jsonReader));
                }
                jsonReader.endObject();
                return stringMap;
            }
            case STRING: {
                return jsonReader.nextString();
            }
            case NUMBER: {
                return jsonReader.nextDouble();
            }
            case BOOLEAN: {
                return jsonReader.nextBoolean();
            }
            case NULL: {
                jsonReader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void write(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        TypeAdapter<?> typeAdapter = this.a.getAdapter(object.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            jsonWriter.beginObject();
            jsonWriter.endObject();
            return;
        }
        typeAdapter.write(jsonWriter, object);
    }
}

