/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson.internal.bind;

import com.swarmconnect.gson.Gson;
import com.swarmconnect.gson.JsonSyntaxException;
import com.swarmconnect.gson.TypeAdapter;
import com.swarmconnect.gson.TypeAdapterFactory;
import com.swarmconnect.gson.reflect.TypeToken;
import com.swarmconnect.gson.stream.JsonReader;
import com.swarmconnect.gson.stream.JsonToken;
import com.swarmconnect.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat a = new SimpleDateFormat("MMM d, yyyy");

    @Override
    public synchronized Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        try {
            long l2 = this.a.parse(jsonReader.nextString()).getTime();
            return new Date(l2);
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException(parseException);
        }
    }

    @Override
    public synchronized void write(JsonWriter jsonWriter, Date date) throws IOException {
        jsonWriter.value(date == null ? null : this.a.format(date));
    }
}

