/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson.internal.bind;

import com.swarmconnect.gson.Gson;
import com.swarmconnect.gson.JsonSyntaxException;
import com.swarmconnect.gson.TypeAdapter;
import com.swarmconnect.gson.TypeAdapterFactory;
import com.swarmconnect.gson.reflect.TypeToken;
import com.swarmconnect.gson.stream.JsonReader;
import com.swarmconnect.gson.stream.JsonToken;
import com.swarmconnect.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeTypeAdapter
extends TypeAdapter<Time> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new TimeTypeAdapter() : null;
        }
    };
    private final DateFormat a = new SimpleDateFormat("hh:mm:ss a");

    @Override
    public synchronized Time read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        try {
            Date date = this.a.parse(jsonReader.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException(parseException);
        }
    }

    @Override
    public synchronized void write(JsonWriter jsonWriter, Time time) throws IOException {
        jsonWriter.value(time == null ? null : this.a.format(time));
    }
}

