/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson.stream;

import com.swarmconnect.gson.internal.JsonReaderInternalAccess;
import com.swarmconnect.gson.internal.bind.JsonTreeReader;
import com.swarmconnect.gson.stream.JsonToken;
import com.swarmconnect.gson.stream.MalformedJsonException;
import com.swarmconnect.gson.stream.a;
import com.swarmconnect.gson.stream.b;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class JsonReader
implements Closeable {
    private static final char[] a = ")]}'\n".toCharArray();
    private final b b = new b();
    private final Reader c;
    private boolean d = false;
    private final char[] e = new char[1024];
    private int f = 0;
    private int g = 0;
    private int h = 1;
    private int i = 1;
    private a[] j = new a[32];
    private int k = 0;
    private JsonToken l;
    private String m;
    private String n;
    private int o;
    private int p;
    private boolean q;

    public JsonReader(Reader reader) {
        this.a(com.swarmconnect.gson.stream.a.EMPTY_DOCUMENT);
        this.q = false;
        if (reader == null) {
            throw new NullPointerException("in == null");
        }
        this.c = reader;
    }

    public final void setLenient(boolean bl2) {
        this.d = bl2;
    }

    public final boolean isLenient() {
        return this.d;
    }

    public void beginArray() throws IOException {
        this.a(JsonToken.BEGIN_ARRAY);
    }

    public void endArray() throws IOException {
        this.a(JsonToken.END_ARRAY);
    }

    public void beginObject() throws IOException {
        this.a(JsonToken.BEGIN_OBJECT);
    }

    public void endObject() throws IOException {
        this.a(JsonToken.END_OBJECT);
    }

    private void a(JsonToken jsonToken) throws IOException {
        this.peek();
        if (this.l != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()) + " at line " + this.e() + " column " + this.f());
        }
        this.b();
    }

    public boolean hasNext() throws IOException {
        this.peek();
        return this.l != JsonToken.END_OBJECT && this.l != JsonToken.END_ARRAY;
    }

    public JsonToken peek() throws IOException {
        if (this.l != null) {
            return this.l;
        }
        switch (this.j[this.k - 1]) {
            case EMPTY_DOCUMENT: {
                if (this.d) {
                    this.a();
                }
                this.j[this.k - 1] = com.swarmconnect.gson.stream.a.NONEMPTY_DOCUMENT;
                JsonToken jsonToken = this.d();
                if (!this.d && this.l != JsonToken.BEGIN_ARRAY && this.l != JsonToken.BEGIN_OBJECT) {
                    throw new IOException("Expected JSON document to start with '[' or '{' but was " + (Object)((Object)this.l) + " at line " + this.e() + " column " + this.f());
                }
                return jsonToken;
            }
            case EMPTY_ARRAY: {
                return this.a(true);
            }
            case NONEMPTY_ARRAY: {
                return this.a(false);
            }
            case EMPTY_OBJECT: {
                return this.b(true);
            }
            case DANGLING_NAME: {
                return this.c();
            }
            case NONEMPTY_OBJECT: {
                return this.b(false);
            }
            case NONEMPTY_DOCUMENT: {
                int n2 = this.c(false);
                if (n2 == -1) {
                    return JsonToken.END_DOCUMENT;
                }
                --this.f;
                if (!this.d) {
                    throw this.b("Expected EOF");
                }
                return this.d();
            }
            case CLOSED: {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        throw new AssertionError();
    }

    private void a() throws IOException {
        this.c(true);
        --this.f;
        if (this.f + a.length > this.g && !this.a(a.length)) {
            return;
        }
        for (int i2 = 0; i2 < a.length; ++i2) {
            if (this.e[this.f + i2] == a[i2]) continue;
            return;
        }
        this.f += a.length;
    }

    private JsonToken b() throws IOException {
        this.peek();
        JsonToken jsonToken = this.l;
        this.l = null;
        this.n = null;
        this.m = null;
        return jsonToken;
    }

    public String nextName() throws IOException {
        this.peek();
        if (this.l != JsonToken.NAME) {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()) + " at line " + this.e() + " column " + this.f());
        }
        String string = this.m;
        this.b();
        return string;
    }

    public String nextString() throws IOException {
        this.peek();
        if (this.l != JsonToken.STRING && this.l != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()) + " at line " + this.e() + " column " + this.f());
        }
        String string = this.n;
        this.b();
        return string;
    }

    public boolean nextBoolean() throws IOException {
        this.peek();
        if (this.l != JsonToken.BOOLEAN) {
            throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.l) + " at line " + this.e() + " column " + this.f());
        }
        boolean bl2 = this.n == "true";
        this.b();
        return bl2;
    }

    public void nextNull() throws IOException {
        this.peek();
        if (this.l != JsonToken.NULL) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.l) + " at line " + this.e() + " column " + this.f());
        }
        this.b();
    }

    public double nextDouble() throws IOException {
        this.peek();
        if (this.l != JsonToken.STRING && this.l != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.l) + " at line " + this.e() + " column " + this.f());
        }
        double d2 = Double.parseDouble(this.n);
        if (d2 >= 1.0 && this.n.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.n + " at line " + this.e() + " column " + this.f());
        }
        if (!this.d && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new MalformedJsonException("JSON forbids NaN and infinities: " + this.n + " at line " + this.e() + " column " + this.f());
        }
        this.b();
        return d2;
    }

    public long nextLong() throws IOException {
        long l2;
        block4: {
            this.peek();
            if (this.l != JsonToken.STRING && this.l != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.l) + " at line " + this.e() + " column " + this.f());
            }
            try {
                l2 = Long.parseLong(this.n);
            }
            catch (NumberFormatException numberFormatException) {
                double d2 = Double.parseDouble(this.n);
                l2 = (long)d2;
                if ((double)l2 == d2) break block4;
                throw new NumberFormatException("Expected a long but was " + this.n + " at line " + this.e() + " column " + this.f());
            }
        }
        if (l2 >= 1L && this.n.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.n + " at line " + this.e() + " column " + this.f());
        }
        this.b();
        return l2;
    }

    public int nextInt() throws IOException {
        int n2;
        block4: {
            this.peek();
            if (this.l != JsonToken.STRING && this.l != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.l) + " at line " + this.e() + " column " + this.f());
            }
            try {
                n2 = Integer.parseInt(this.n);
            }
            catch (NumberFormatException numberFormatException) {
                double d2 = Double.parseDouble(this.n);
                n2 = (int)d2;
                if ((double)n2 == d2) break block4;
                throw new NumberFormatException("Expected an int but was " + this.n + " at line " + this.e() + " column " + this.f());
            }
        }
        if ((long)n2 >= 1L && this.n.startsWith("0")) {
            throw new MalformedJsonException("JSON forbids octal prefixes: " + this.n + " at line " + this.e() + " column " + this.f());
        }
        this.b();
        return n2;
    }

    public void close() throws IOException {
        this.n = null;
        this.l = null;
        this.j[0] = com.swarmconnect.gson.stream.a.CLOSED;
        this.k = 1;
        this.c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipValue() throws IOException {
        this.q = true;
        try {
            int n2 = 0;
            do {
                JsonToken jsonToken;
                if ((jsonToken = this.b()) == JsonToken.BEGIN_ARRAY || jsonToken == JsonToken.BEGIN_OBJECT) {
                    ++n2;
                    continue;
                }
                if (jsonToken != JsonToken.END_ARRAY && jsonToken != JsonToken.END_OBJECT) continue;
                --n2;
            } while (n2 != 0);
        }
        finally {
            this.q = false;
        }
    }

    private void a(a a2) {
        if (this.k == this.j.length) {
            a[] aArray = new a[this.k * 2];
            System.arraycopy(this.j, 0, aArray, 0, this.k);
            this.j = aArray;
        }
        this.j[this.k++] = a2;
    }

    private JsonToken a(boolean bl2) throws IOException {
        if (bl2) {
            this.j[this.k - 1] = com.swarmconnect.gson.stream.a.NONEMPTY_ARRAY;
        } else {
            switch (this.c(true)) {
                case 93: {
                    --this.k;
                    this.l = JsonToken.END_ARRAY;
                    return this.l;
                }
                case 59: {
                    this.g();
                }
                case 44: {
                    break;
                }
                default: {
                    throw this.b("Unterminated array");
                }
            }
        }
        switch (this.c(true)) {
            case 93: {
                if (bl2) {
                    --this.k;
                    this.l = JsonToken.END_ARRAY;
                    return this.l;
                }
            }
            case 44: 
            case 59: {
                this.g();
                --this.f;
                this.n = "null";
                this.l = JsonToken.NULL;
                return this.l;
            }
        }
        --this.f;
        return this.d();
    }

    private JsonToken b(boolean bl2) throws IOException {
        if (bl2) {
            switch (this.c(true)) {
                case 125: {
                    --this.k;
                    this.l = JsonToken.END_OBJECT;
                    return this.l;
                }
            }
            --this.f;
        } else {
            switch (this.c(true)) {
                case 125: {
                    --this.k;
                    this.l = JsonToken.END_OBJECT;
                    return this.l;
                }
                case 44: 
                case 59: {
                    break;
                }
                default: {
                    throw this.b("Unterminated object");
                }
            }
        }
        int n2 = this.c(true);
        switch (n2) {
            case 39: {
                this.g();
            }
            case 34: {
                this.m = this.a((char)n2);
                break;
            }
            default: {
                this.g();
                --this.f;
                this.m = this.d(false);
                if (this.m.length() != 0) break;
                throw this.b("Expected name");
            }
        }
        this.j[this.k - 1] = com.swarmconnect.gson.stream.a.DANGLING_NAME;
        this.l = JsonToken.NAME;
        return this.l;
    }

    private JsonToken c() throws IOException {
        switch (this.c(true)) {
            case 58: {
                break;
            }
            case 61: {
                this.g();
                if (this.f >= this.g && !this.a(1) || this.e[this.f] != '>') break;
                ++this.f;
                break;
            }
            default: {
                throw this.b("Expected ':'");
            }
        }
        this.j[this.k - 1] = com.swarmconnect.gson.stream.a.NONEMPTY_OBJECT;
        return this.d();
    }

    private JsonToken d() throws IOException {
        int n2 = this.c(true);
        switch (n2) {
            case 123: {
                this.a(com.swarmconnect.gson.stream.a.EMPTY_OBJECT);
                this.l = JsonToken.BEGIN_OBJECT;
                return this.l;
            }
            case 91: {
                this.a(com.swarmconnect.gson.stream.a.EMPTY_ARRAY);
                this.l = JsonToken.BEGIN_ARRAY;
                return this.l;
            }
            case 39: {
                this.g();
            }
            case 34: {
                this.n = this.a((char)n2);
                this.l = JsonToken.STRING;
                return this.l;
            }
        }
        --this.f;
        return this.j();
    }

    private boolean a(int n2) throws IOException {
        int n3;
        char[] cArray = this.e;
        int n4 = this.h;
        int n5 = this.i;
        int n6 = this.f;
        for (n3 = 0; n3 < n6; ++n3) {
            if (cArray[n3] == '\n') {
                ++n4;
                n5 = 1;
                continue;
            }
            ++n5;
        }
        this.h = n4;
        this.i = n5;
        if (this.g != this.f) {
            this.g -= this.f;
            System.arraycopy(cArray, this.f, cArray, 0, this.g);
        } else {
            this.g = 0;
        }
        this.f = 0;
        while ((n3 = this.c.read(cArray, this.g, cArray.length - this.g)) != -1) {
            this.g += n3;
            if (this.h == 1 && this.i == 1 && this.g > 0 && cArray[0] == '\ufeff') {
                ++this.f;
                --this.i;
            }
            if (this.g < n2) continue;
            return true;
        }
        return false;
    }

    private int e() {
        int n2 = this.h;
        for (int i2 = 0; i2 < this.f; ++i2) {
            if (this.e[i2] != '\n') continue;
            ++n2;
        }
        return n2;
    }

    private int f() {
        int n2 = this.i;
        for (int i2 = 0; i2 < this.f; ++i2) {
            if (this.e[i2] == '\n') {
                n2 = 1;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    private int c(boolean bl2) throws IOException {
        block15: {
            char c2;
            char[] cArray = this.e;
            int n2 = this.f;
            int n3 = this.g;
            block9: while (true) {
                if (n2 == n3) {
                    this.f = n2;
                    if (!this.a(1)) break block15;
                    n2 = this.f;
                    n3 = this.g;
                }
                c2 = cArray[n2++];
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block9;
                    }
                    case '/': {
                        char c3;
                        this.f = n2;
                        if (n2 == n3) {
                            --this.f;
                            c3 = (char)(this.a(2) ? 1 : 0);
                            ++this.f;
                            if (c3 == '\u0000') {
                                return c2;
                            }
                        }
                        this.g();
                        c3 = cArray[this.f];
                        switch (c3) {
                            case '*': {
                                ++this.f;
                                if (!this.a("*/")) {
                                    throw this.b("Unterminated comment");
                                }
                                n2 = this.f + 2;
                                n3 = this.g;
                                continue block9;
                            }
                            case '/': {
                                ++this.f;
                                this.h();
                                n2 = this.f;
                                n3 = this.g;
                                continue block9;
                            }
                        }
                        return c2;
                    }
                    case '#': {
                        this.f = n2;
                        this.g();
                        this.h();
                        n2 = this.f;
                        n3 = this.g;
                        continue block9;
                    }
                }
                break;
            }
            this.f = n2;
            return c2;
        }
        if (bl2) {
            throw new EOFException("End of input at line " + this.e() + " column " + this.f());
        }
        return -1;
    }

    private void g() throws IOException {
        if (!this.d) {
            throw this.b("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void h() throws IOException {
        char c2;
        while ((this.f < this.g || this.a(1)) && (c2 = this.e[this.f++]) != '\r' && c2 != '\n') {
        }
    }

    private boolean a(String string) throws IOException {
        while (this.f + string.length() <= this.g || this.a(string.length())) {
            block3: {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    if (this.e[this.f + i2] == string.charAt(i2)) {
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++this.f;
        }
        return false;
    }

    private String a(char c2) throws IOException {
        char[] cArray = this.e;
        StringBuilder stringBuilder = null;
        do {
            int n2 = this.f;
            int n3 = this.g;
            int n4 = n2;
            while (n2 < n3) {
                char c3;
                if ((c3 = cArray[n2++]) == c2) {
                    this.f = n2;
                    if (this.q) {
                        return "skipped!";
                    }
                    if (stringBuilder == null) {
                        return this.b.get(cArray, n4, n2 - n4 - 1);
                    }
                    stringBuilder.append(cArray, n4, n2 - n4 - 1);
                    return stringBuilder.toString();
                }
                if (c3 != '\\') continue;
                this.f = n2;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(cArray, n4, n2 - n4 - 1);
                stringBuilder.append(this.i());
                n2 = this.f;
                n3 = this.g;
                n4 = n2;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(cArray, n4, n2 - n4);
            this.f = n2;
        } while (this.a(1));
        throw this.b("Unterminated string");
    }

    private String d(boolean bl2) throws IOException {
        String string;
        StringBuilder stringBuilder = null;
        this.o = -1;
        this.p = 0;
        int n2 = 0;
        block4: while (true) {
            if (this.f + n2 < this.g) {
                switch (this.e[this.f + n2]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.g();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++n2;
                        break;
                    }
                }
                continue;
            }
            if (n2 < this.e.length) {
                if (this.a(n2 + 1)) continue;
                this.e[this.g] = '\u0000';
                break;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.e, this.f, n2);
            this.p += n2;
            this.f += n2;
            n2 = 0;
            if (!this.a(1)) break;
        }
        if (bl2 && stringBuilder == null) {
            this.o = this.f;
            string = null;
        } else if (this.q) {
            string = "skipped!";
        } else if (stringBuilder == null) {
            string = this.b.get(this.e, this.f, n2);
        } else {
            stringBuilder.append(this.e, this.f, n2);
            string = stringBuilder.toString();
        }
        this.p += n2;
        this.f += n2;
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " at line " + this.e() + " column " + this.f();
    }

    private char i() throws IOException {
        if (this.f == this.g && !this.a(1)) {
            throw this.b("Unterminated escape sequence");
        }
        char c2 = this.e[this.f++];
        switch (c2) {
            case 'u': {
                int n2;
                if (this.f + 4 > this.g && !this.a(4)) {
                    throw this.b("Unterminated escape sequence");
                }
                char c3 = '\u0000';
                int n3 = n2 + 4;
                for (n2 = this.f; n2 < n3; ++n2) {
                    char c4 = this.e[n2];
                    c3 = (char)(c3 << 4);
                    if (c4 >= '0' && c4 <= '9') {
                        c3 = (char)(c3 + (c4 - 48));
                        continue;
                    }
                    if (c4 >= 'a' && c4 <= 'f') {
                        c3 = (char)(c3 + (c4 - 97 + 10));
                        continue;
                    }
                    if (c4 >= 'A' && c4 <= 'F') {
                        c3 = (char)(c3 + (c4 - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException("\\u" + this.b.get(this.e, this.f, 4));
                }
                this.f += 4;
                return c3;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return c2;
    }

    private JsonToken j() throws IOException {
        this.n = this.d(true);
        if (this.p == 0) {
            throw this.b("Expected literal value");
        }
        this.l = this.k();
        if (this.l == JsonToken.STRING) {
            this.g();
        }
        return this.l;
    }

    private JsonToken k() throws IOException {
        if (this.o == -1) {
            return JsonToken.STRING;
        }
        if (!(this.p != 4 || 'n' != this.e[this.o] && 'N' != this.e[this.o] || 'u' != this.e[this.o + 1] && 'U' != this.e[this.o + 1] || 'l' != this.e[this.o + 2] && 'L' != this.e[this.o + 2] || 'l' != this.e[this.o + 3] && 'L' != this.e[this.o + 3])) {
            this.n = "null";
            return JsonToken.NULL;
        }
        if (!(this.p != 4 || 't' != this.e[this.o] && 'T' != this.e[this.o] || 'r' != this.e[this.o + 1] && 'R' != this.e[this.o + 1] || 'u' != this.e[this.o + 2] && 'U' != this.e[this.o + 2] || 'e' != this.e[this.o + 3] && 'E' != this.e[this.o + 3])) {
            this.n = "true";
            return JsonToken.BOOLEAN;
        }
        if (!(this.p != 5 || 'f' != this.e[this.o] && 'F' != this.e[this.o] || 'a' != this.e[this.o + 1] && 'A' != this.e[this.o + 1] || 'l' != this.e[this.o + 2] && 'L' != this.e[this.o + 2] || 's' != this.e[this.o + 3] && 'S' != this.e[this.o + 3] || 'e' != this.e[this.o + 4] && 'E' != this.e[this.o + 4])) {
            this.n = "false";
            return JsonToken.BOOLEAN;
        }
        this.n = this.b.get(this.e, this.o, this.p);
        return this.a(this.e, this.o, this.p);
    }

    private JsonToken a(char[] cArray, int n2, int n3) {
        int n4 = n2;
        char c2 = cArray[n4];
        if (c2 == '-') {
            c2 = cArray[++n4];
        }
        if (c2 == '0') {
            c2 = cArray[++n4];
        } else if (c2 >= '1' && c2 <= '9') {
            c2 = cArray[++n4];
            while (c2 >= '0' && c2 <= '9') {
                c2 = cArray[++n4];
            }
        } else {
            return JsonToken.STRING;
        }
        if (c2 == '.') {
            c2 = cArray[++n4];
            while (c2 >= '0' && c2 <= '9') {
                c2 = cArray[++n4];
            }
        }
        if (c2 == 'e' || c2 == 'E') {
            if ((c2 = cArray[++n4]) == '+' || c2 == '-') {
                c2 = cArray[++n4];
            }
            if (c2 >= '0' && c2 <= '9') {
                c2 = cArray[++n4];
                while (c2 >= '0' && c2 <= '9') {
                    c2 = cArray[++n4];
                }
            } else {
                return JsonToken.STRING;
            }
        }
        if (n4 == n2 + n3) {
            return JsonToken.NUMBER;
        }
        return JsonToken.STRING;
    }

    private IOException b(String string) throws IOException {
        throw new MalformedJsonException(string + " at line " + this.e() + " column " + this.f());
    }

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            public void promoteNameToValue(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof JsonTreeReader) {
                    ((JsonTreeReader)jsonReader).promoteNameToValue();
                    return;
                }
                jsonReader.peek();
                if (jsonReader.l != JsonToken.NAME) {
                    throw new IllegalStateException("Expected a name but was " + (Object)((Object)jsonReader.peek()) + " " + " at line " + jsonReader.e() + " column " + jsonReader.f());
                }
                jsonReader.n = jsonReader.m;
                jsonReader.m = null;
                jsonReader.l = JsonToken.STRING;
            }
        };
    }
}

