/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.gson.stream;

import com.swarmconnect.gson.stream.a;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class JsonWriter
implements Closeable,
Flushable {
    private static final String[] a = new String[128];
    private static final String[] b;
    private final Writer c;
    private final List<a> d = new ArrayList<a>();
    private String e;
    private String f;
    private boolean g;
    private boolean h;
    private String i;
    private boolean j;

    public JsonWriter(Writer writer) {
        this.d.add(com.swarmconnect.gson.stream.a.EMPTY_DOCUMENT);
        this.f = ":";
        this.j = true;
        if (writer == null) {
            throw new NullPointerException("out == null");
        }
        this.c = writer;
    }

    public final void setIndent(String string) {
        if (string.length() == 0) {
            this.e = null;
            this.f = ":";
        } else {
            this.e = string;
            this.f = ": ";
        }
    }

    public final void setLenient(boolean bl2) {
        this.g = bl2;
    }

    public boolean isLenient() {
        return this.g;
    }

    public final void setHtmlSafe(boolean bl2) {
        this.h = bl2;
    }

    public final boolean isHtmlSafe() {
        return this.h;
    }

    public final void setSerializeNulls(boolean bl2) {
        this.j = bl2;
    }

    public final boolean getSerializeNulls() {
        return this.j;
    }

    public JsonWriter beginArray() throws IOException {
        this.b();
        return this.a(com.swarmconnect.gson.stream.a.EMPTY_ARRAY, "[");
    }

    public JsonWriter endArray() throws IOException {
        return this.a(com.swarmconnect.gson.stream.a.EMPTY_ARRAY, com.swarmconnect.gson.stream.a.NONEMPTY_ARRAY, "]");
    }

    public JsonWriter beginObject() throws IOException {
        this.b();
        return this.a(com.swarmconnect.gson.stream.a.EMPTY_OBJECT, "{");
    }

    public JsonWriter endObject() throws IOException {
        return this.a(com.swarmconnect.gson.stream.a.EMPTY_OBJECT, com.swarmconnect.gson.stream.a.NONEMPTY_OBJECT, "}");
    }

    private JsonWriter a(a a2, String string) throws IOException {
        this.a(true);
        this.d.add(a2);
        this.c.write(string);
        return this;
    }

    private JsonWriter a(a a2, a a3, String string) throws IOException {
        a a4 = this.a();
        if (a4 != a3 && a4 != a2) {
            throw new IllegalStateException("Nesting problem: " + this.d);
        }
        if (this.i != null) {
            throw new IllegalStateException("Dangling name: " + this.i);
        }
        this.d.remove(this.d.size() - 1);
        if (a4 == a3) {
            this.c();
        }
        this.c.write(string);
        return this;
    }

    private a a() {
        int n2 = this.d.size();
        if (n2 == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.d.get(n2 - 1);
    }

    private void a(a a2) {
        this.d.set(this.d.size() - 1, a2);
    }

    public JsonWriter name(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (this.i != null) {
            throw new IllegalStateException();
        }
        if (this.d.isEmpty()) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.i = string;
        return this;
    }

    private void b() throws IOException {
        if (this.i != null) {
            this.d();
            this.a(this.i);
            this.i = null;
        }
    }

    public JsonWriter value(String string) throws IOException {
        if (string == null) {
            return this.nullValue();
        }
        this.b();
        this.a(false);
        this.a(string);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.i != null) {
            if (this.j) {
                this.b();
            } else {
                this.i = null;
                return this;
            }
        }
        this.a(false);
        this.c.write("null");
        return this;
    }

    public JsonWriter value(boolean bl2) throws IOException {
        this.b();
        this.a(false);
        this.c.write(bl2 ? "true" : "false");
        return this;
    }

    public JsonWriter value(double d2) throws IOException {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + d2);
        }
        this.b();
        this.a(false);
        this.c.append(Double.toString(d2));
        return this;
    }

    public JsonWriter value(long l2) throws IOException {
        this.b();
        this.a(false);
        this.c.write(Long.toString(l2));
        return this;
    }

    public JsonWriter value(Number number) throws IOException {
        if (number == null) {
            return this.nullValue();
        }
        this.b();
        String string = number.toString();
        if (!this.g && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + number);
        }
        this.a(false);
        this.c.append(string);
        return this;
    }

    public void flush() throws IOException {
        if (this.d.isEmpty()) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.c.flush();
    }

    public void close() throws IOException {
        this.c.close();
        int n2 = this.d.size();
        if (n2 > 1 || n2 == 1 && this.d.get(n2 - 1) != com.swarmconnect.gson.stream.a.NONEMPTY_DOCUMENT) {
            throw new IOException("Incomplete document");
        }
        this.d.clear();
    }

    private void a(String string) throws IOException {
        String[] stringArray = this.h ? b : a;
        this.c.write("\"");
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string2;
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                string2 = stringArray[c2];
                if (string2 == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c2 != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n2 < i2) {
                this.c.write(string, n2, i2 - n2);
            }
            this.c.write(string2);
            n2 = i2 + 1;
        }
        if (n2 < n3) {
            this.c.write(string, n2, n3 - n2);
        }
        this.c.write("\"");
    }

    private void c() throws IOException {
        if (this.e == null) {
            return;
        }
        this.c.write("\n");
        for (int i2 = 1; i2 < this.d.size(); ++i2) {
            this.c.write(this.e);
        }
    }

    private void d() throws IOException {
        a a2 = this.a();
        if (a2 == com.swarmconnect.gson.stream.a.NONEMPTY_OBJECT) {
            this.c.write(44);
        } else if (a2 != com.swarmconnect.gson.stream.a.EMPTY_OBJECT) {
            throw new IllegalStateException("Nesting problem: " + this.d);
        }
        this.c();
        this.a(com.swarmconnect.gson.stream.a.DANGLING_NAME);
    }

    private void a(boolean bl2) throws IOException {
        switch (this.a()) {
            case NONEMPTY_DOCUMENT: {
                if (!this.g) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case EMPTY_DOCUMENT: {
                if (!this.g && !bl2) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.a(com.swarmconnect.gson.stream.a.NONEMPTY_DOCUMENT);
                break;
            }
            case EMPTY_ARRAY: {
                this.a(com.swarmconnect.gson.stream.a.NONEMPTY_ARRAY);
                this.c();
                break;
            }
            case NONEMPTY_ARRAY: {
                this.c.append(',');
                this.c();
                break;
            }
            case DANGLING_NAME: {
                this.c.append(this.f);
                this.a(com.swarmconnect.gson.stream.a.NONEMPTY_OBJECT);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem: " + this.d);
            }
        }
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            JsonWriter.a[i2] = String.format("\\u%04x", i2);
        }
        JsonWriter.a[34] = "\\\"";
        JsonWriter.a[92] = "\\\\";
        JsonWriter.a[9] = "\\t";
        JsonWriter.a[8] = "\\b";
        JsonWriter.a[10] = "\\n";
        JsonWriter.a[13] = "\\r";
        JsonWriter.a[12] = "\\f";
        b = (String[])a.clone();
        JsonWriter.b[60] = "\\u003c";
        JsonWriter.b[62] = "\\u003e";
        JsonWriter.b[38] = "\\u0026";
        JsonWriter.b[61] = "\\u003d";
        JsonWriter.b[39] = "\\u0027";
    }
}

