/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.loopj.android.http;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.swarmconnect.loopj.android.http.SerializableCookie;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;

public class PersistentCookieStore
implements CookieStore {
    private final ConcurrentHashMap<String, Cookie> a;
    private final SharedPreferences b;

    public PersistentCookieStore(Context context) {
        this.b = context.getSharedPreferences("CookiePrefsFile", 0);
        this.a = new ConcurrentHashMap();
        String string = this.b.getString("names", null);
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = TextUtils.split((String)string, (String)",");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Cookie cookie;
                String string2 = stringArray2[n3];
                String string3 = this.b.getString("cookie_" + string2, null);
                if (string3 != null && (cookie = this.a(string3)) != null) {
                    this.a.put(string2, cookie);
                }
                ++n3;
            }
            this.clearExpired(new Date());
        }
    }

    public void addCookie(Cookie cookie) {
        String string = cookie.getName();
        if (!cookie.isExpired(new Date())) {
            this.a.put(string, cookie);
        } else {
            this.a.remove(string);
        }
        SharedPreferences.Editor editor = this.b.edit();
        editor.putString("names", TextUtils.join((CharSequence)",", (Iterable)this.a.keySet()));
        editor.putString("cookie_" + string, this.a(new SerializableCookie(cookie)));
        editor.commit();
    }

    public void clear() {
        this.a.clear();
        SharedPreferences.Editor editor = this.b.edit();
        for (String string : this.a.keySet()) {
            editor.remove("cookie_" + string);
        }
        editor.remove("names");
        editor.commit();
    }

    public boolean clearExpired(Date date) {
        boolean bl2 = false;
        SharedPreferences.Editor editor = this.b.edit();
        for (Map.Entry<String, Cookie> entry : this.a.entrySet()) {
            String string = entry.getKey();
            Cookie cookie = entry.getValue();
            if (!cookie.isExpired(date)) continue;
            this.a.remove(string);
            editor.remove("cookie_" + string);
            bl2 = true;
        }
        if (bl2) {
            editor.putString("names", TextUtils.join((CharSequence)",", (Iterable)this.a.keySet()));
        }
        editor.commit();
        return bl2;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.a.values());
    }

    protected String a(SerializableCookie serializableCookie) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializableCookie);
        }
        catch (Exception exception) {
            return null;
        }
        return this.a(byteArrayOutputStream.toByteArray());
    }

    protected Cookie a(String string) {
        byte[] byArray = this.b(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Cookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableCookie)objectInputStream.readObject()).getCookie();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cookie;
    }

    protected String a(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by2 = byArray2[n3];
            int n4 = by2 & 0xFF;
            if (n4 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n4));
            ++n3;
        }
        return stringBuffer.toString().toUpperCase();
    }

    protected byte[] b(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3 / 2] = (byte)((Character.digit(string.charAt(n3), 16) << 4) + Character.digit(string.charAt(n3 + 1), 16));
            n3 += 2;
        }
        return byArray;
    }
}

