/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.packets;

import java.io.IOException;
import java.math.BigInteger;

public class TypesReader {
    byte[] a;
    int b = 0;
    int c = 0;

    public TypesReader(byte[] byArray) {
        this.a = byArray;
        this.b = 0;
        this.c = byArray.length;
    }

    public TypesReader(byte[] byArray, int n2) {
        this.a = byArray;
        this.b = n2;
        this.c = byArray.length;
        if (this.b < 0 || this.b > byArray.length) {
            throw new IllegalArgumentException("Illegal offset.");
        }
    }

    public TypesReader(byte[] byArray, int n2, int n3) {
        this.a = byArray;
        this.b = n2;
        this.c = n2 + n3;
        if (this.b < 0 || this.b > byArray.length) {
            throw new IllegalArgumentException("Illegal offset.");
        }
        if (this.c < 0 || this.c > byArray.length) {
            throw new IllegalArgumentException("Illegal length.");
        }
    }

    public int readByte() throws IOException {
        if (this.b >= this.c) {
            throw new IOException("Packet too short.");
        }
        return this.a[this.b++] & 0xFF;
    }

    public byte[] readBytes(int n2) throws IOException {
        if (this.b + n2 > this.c) {
            throw new IOException("Packet too short.");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.a, this.b, byArray, 0, n2);
        this.b += n2;
        return byArray;
    }

    public void readBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.b + n3 > this.c) {
            throw new IOException("Packet too short.");
        }
        System.arraycopy(this.a, this.b, byArray, n2, n3);
        this.b += n3;
    }

    public boolean readBoolean() throws IOException {
        if (this.b >= this.c) {
            throw new IOException("Packet too short.");
        }
        return this.a[this.b++] != 0;
    }

    public String[] readStringArray() throws IOException {
        int n2 = this.readUINT32();
        if (n2 > 0) {
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = this.readString();
                ++n3;
            }
            return stringArray;
        }
        return null;
    }

    public int[] readIntArray() throws IOException {
        int n2 = this.readUINT32();
        if (n2 < 1) {
            return null;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.readUINT32();
            ++n3;
        }
        return nArray;
    }

    public int readUINT32() throws IOException {
        if (this.b + 4 > this.c) {
            throw new IOException("Packet too short.");
        }
        return (this.a[this.b++] & 0xFF) << 24 | (this.a[this.b++] & 0xFF) << 16 | (this.a[this.b++] & 0xFF) << 8 | this.a[this.b++] & 0xFF;
    }

    public float readFloat() throws IOException {
        if (this.b + 4 > this.c) {
            throw new IOException("Packet too short.");
        }
        return Float.intBitsToFloat((this.a[this.b++] & 0xFF) << 24 | (this.a[this.b++] & 0xFF) << 16 | (this.a[this.b++] & 0xFF) << 8 | this.a[this.b++] & 0xFF);
    }

    public long readUINT64() throws IOException {
        if (this.b + 8 > this.c) {
            throw new IOException("Packet too short.");
        }
        long l2 = (this.a[this.b++] & 0xFF) << 24 | (this.a[this.b++] & 0xFF) << 16 | (this.a[this.b++] & 0xFF) << 8 | this.a[this.b++] & 0xFF;
        long l3 = (this.a[this.b++] & 0xFF) << 24 | (this.a[this.b++] & 0xFF) << 16 | (this.a[this.b++] & 0xFF) << 8 | this.a[this.b++] & 0xFF;
        return l2 << 32 | l3 & 0xFFFFFFFFL;
    }

    public BigInteger readMPINT() throws IOException {
        byte[] byArray = this.readByteString();
        BigInteger bigInteger = byArray.length == 0 ? BigInteger.ZERO : new BigInteger(byArray);
        return bigInteger;
    }

    public byte[] readByteString() throws IOException {
        int n2 = this.readUINT32();
        if (n2 + this.b > this.c) {
            throw new IOException("Malformed SSH byte string.");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.a, this.b, byArray, 0, n2);
        this.b += n2;
        return byArray;
    }

    public String readString(String string) throws IOException {
        int n2 = this.readUINT32();
        if (n2 + this.b > this.c) {
            throw new IOException("Malformed SSH string.");
        }
        String string2 = string == null ? new String(this.a, this.b, n2) : new String(this.a, this.b, n2, string);
        this.b += n2;
        return string2;
    }

    public String readString() throws IOException {
        int n2 = this.readUINT32();
        if (n2 + this.b > this.c) {
            throw new IOException("Malformed SSH string.");
        }
        String string = new String(this.a, this.b, n2, "ISO-8859-1");
        this.b += n2;
        return string;
    }

    public int remain() {
        return this.c - this.b;
    }
}

