/*
 * Decompiled with CFR 0.152.
 */
package com.swarmconnect.utils;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import java.util.LinkedHashMap;
import java.util.Map;

public class SeparatedListAdapter
extends BaseAdapter {
    public final Map<String, BaseAdapter> sections = new LinkedHashMap<String, BaseAdapter>();
    public final ArrayAdapter<String> headers;
    public static final int TYPE_SECTION_HEADER = 0;

    public SeparatedListAdapter(Context context, int n2) {
        this.headers = new ArrayAdapter(context, n2);
    }

    public void addSection(String string, BaseAdapter baseAdapter) {
        this.headers.add((Object)string);
        this.sections.put(string, baseAdapter);
        this.notifyDataSetChanged();
    }

    public void removeSection(String string) {
        this.headers.remove((Object)string);
        this.sections.remove(string);
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        for (BaseAdapter baseAdapter : this.sections.values()) {
            baseAdapter.notifyDataSetChanged();
        }
    }

    public int getSectionForPosition(int n2) {
        if (n2 < 0) {
            return -1;
        }
        int n3 = 0;
        for (String string : this.sections.keySet()) {
            Adapter adapter = (Adapter)this.sections.get(string);
            if (adapter.getCount() == 0) {
                ++n3;
                continue;
            }
            int n4 = adapter.getCount() + 1;
            if ((n2 -= n4) < 0) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    public Object getItem(int n2) {
        for (String string : this.sections.keySet()) {
            Adapter adapter = (Adapter)this.sections.get(string);
            if (adapter.getCount() == 0) continue;
            int n3 = adapter.getCount() + 1;
            if (n2 == 0) {
                return string;
            }
            if (n2 < n3) {
                return adapter.getItem(n2 - 1);
            }
            n2 -= n3;
        }
        return null;
    }

    public int getCount() {
        int n2 = 0;
        for (Adapter adapter : this.sections.values()) {
            if (adapter.getCount() == 0) continue;
            n2 += adapter.getCount() + 1;
        }
        return n2;
    }

    public int getViewTypeCount() {
        int n2 = 1;
        for (Adapter adapter : this.sections.values()) {
            n2 += adapter.getViewTypeCount();
        }
        return n2;
    }

    public int getItemViewType(int n2) {
        int n3 = 1;
        for (String string : this.sections.keySet()) {
            Adapter adapter = (Adapter)this.sections.get(string);
            if (adapter.getCount() == 0) continue;
            int n4 = adapter.getCount() + 1;
            if (n2 == 0) {
                return 0;
            }
            if (n2 < n4) {
                return n3 + adapter.getItemViewType(n2 - 1);
            }
            n2 -= n4;
            n3 += adapter.getViewTypeCount();
        }
        return -1;
    }

    public boolean areAllItemsSelectable() {
        return false;
    }

    public boolean isEnabled(int n2) {
        return this.getItemViewType(n2) != 0;
    }

    public View getView(int n2, View view, ViewGroup viewGroup) {
        int n3 = 0;
        for (String string : this.sections.keySet()) {
            Adapter adapter = (Adapter)this.sections.get(string);
            if (adapter.getCount() > 0) {
                int n4 = adapter.getCount() + 1;
                if (n2 == 0) {
                    return this.headers.getView(n3, view, viewGroup);
                }
                if (n2 < n4) {
                    return adapter.getView(n2 - 1, view, viewGroup);
                }
                n2 -= n4;
            }
            ++n3;
        }
        return null;
    }

    public long getItemId(int n2) {
        return n2;
    }
}

