/*
 * Decompiled with CFR 0.152.
 */
package avian;

import java.io.ByteArrayOutputStream;

public class Utf8 {
    public static boolean test(Object data) {
        if (!(data instanceof byte[])) {
            return false;
        }
        byte[] b = (byte[])data;
        for (int i = 0; i < b.length; ++i) {
            if ((b[i] & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    public static byte[] encode(char[] s16, int offset, int length) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        for (int i = offset; i < offset + length; ++i) {
            char c = s16[i];
            if (c == '\u0000') {
                buf.write(0);
                buf.write(0);
                continue;
            }
            if (c < '\u0080') {
                buf.write(c);
                continue;
            }
            if (c < '\u0800') {
                buf.write(0xC0 | c >>> 6);
                buf.write(0x80 | c & 0x3F);
                continue;
            }
            buf.write(0xE0 | c >>> 12 & 0xF);
            buf.write(0x80 | c >>> 6 & 0x3F);
            buf.write(0x80 | c & 0x3F);
        }
        return buf.toByteArray();
    }

    public static Object decode(byte[] s8, int offset, int length) {
        Object buf = new byte[length];
        boolean isMultiByte = false;
        int i = offset;
        int j = 0;
        while (i < offset + length) {
            byte y;
            byte x;
            if (((x = s8[i++]) & 0x80) == 0) {
                if (x == 0) {
                    ++i;
                }
                Utf8.cram(buf, j++, x);
                continue;
            }
            if ((x & 0xE0) == 192) {
                if (!isMultiByte) {
                    buf = Utf8.widen(buf, j, length - 1);
                    isMultiByte = true;
                }
                y = s8[i++];
                Utf8.cram(buf, j++, (x & 0x1F) << 6 | y & 0x3F);
                continue;
            }
            if ((x & 0xF0) != 224) continue;
            if (!isMultiByte) {
                buf = Utf8.widen(buf, j, length - 2);
                isMultiByte = true;
            }
            y = s8[i++];
            byte z = s8[i++];
            Utf8.cram(buf, j++, (x & 0xF) << 12 | (y & 0x3F) << 6 | z & 0x3F);
        }
        return Utf8.trim(buf, j);
    }

    public static char[] decode16(byte[] s8, int offset, int length) {
        Object decoded = Utf8.decode(s8, offset, length);
        if (decoded instanceof char[]) {
            return (char[])decoded;
        }
        return (char[])Utf8.widen(decoded, length, length);
    }

    private static void cram(Object data, int index, int val) {
        if (data instanceof byte[]) {
            ((byte[])data)[index] = (byte)val;
        } else {
            ((char[])data)[index] = (char)val;
        }
    }

    private static Object widen(Object data, int length, int capacity) {
        byte[] src = (byte[])data;
        char[] result = new char[capacity];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)(src[i] & 0xFF);
        }
        return result;
    }

    private static Object trim(Object data, int length) {
        if (data instanceof byte[]) {
            return data;
        }
        if (((char[])data).length == length) {
            return data;
        }
        char[] result = new char[length];
        System.arraycopy(data, 0, result, 0, length);
        return result;
    }
}

