/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.gwt.GwtApplicationConfiguration;
import com.badlogic.gdx.backends.gwt.GwtAudio;
import com.badlogic.gdx.backends.gwt.GwtFiles;
import com.badlogic.gdx.backends.gwt.GwtGraphics;
import com.badlogic.gdx.backends.gwt.GwtInput;
import com.badlogic.gdx.backends.gwt.GwtPreferences;
import com.badlogic.gdx.backends.gwt.preloader.Preloader;
import com.badlogic.gdx.backends.gwt.soundmanager2.SoundManager;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.TimeUtils;
import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class GwtApplication
implements EntryPoint,
Application {
    private ApplicationListener listener;
    private GwtApplicationConfiguration config;
    private GwtGraphics graphics;
    private GwtInput input;
    private Panel root = null;
    private TextArea log = null;
    private int logLevel = 1;
    private Array<Runnable> runnables = new Array();
    private int lastWidth;
    private int lastHeight;
    private Preloader preloader;
    private static AgentInfo agentInfo;
    private ObjectMap<String, Preferences> prefs = new ObjectMap();
    long loadStart = TimeUtils.nanoTime();

    public abstract GwtApplicationConfiguration getConfig();

    public abstract ApplicationListener getApplicationListener();

    public void onModuleLoad() {
        agentInfo = this.computeAgentInfo();
        this.listener = this.getApplicationListener();
        this.config = this.getConfig();
        if (this.config.rootPanel != null) {
            this.root = this.config.rootPanel;
        } else {
            Element element = Document.get().getElementById("embed-" + GWT.getModuleName());
            if (element == null) {
                VerticalPanel panel = new VerticalPanel();
                panel.setWidth("" + this.config.width + "px");
                panel.setHeight("" + this.config.height + "px");
                panel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                RootPanel.get().add((Widget)panel);
                RootPanel.get().setWidth("" + this.config.width + "px");
                RootPanel.get().setHeight("" + this.config.height + "px");
                this.root = panel;
            } else {
                VerticalPanel panel = new VerticalPanel();
                panel.setWidth("" + this.config.width + "px");
                panel.setHeight("" + this.config.height + "px");
                panel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                element.appendChild((Node)panel.getElement());
                this.root = panel;
            }
        }
        SoundManager.init(GWT.getModuleBaseURL(), 9);
        new Timer(){

            public void run() {
                if (SoundManager.swfLoaded()) {
                    final Preloader.PreloaderCallback callback = GwtApplication.this.getPreloaderCallback();
                    GwtApplication.this.preloader = new Preloader();
                    GwtApplication.this.preloader.preload("assets.txt", new Preloader.PreloaderCallback(){

                        @Override
                        public void loaded(String file, int loaded, int total) {
                            callback.loaded(file, loaded, total);
                        }

                        @Override
                        public void error(String file) {
                            callback.error(file);
                        }

                        @Override
                        public void done() {
                            callback.done();
                            GwtApplication.this.root.clear();
                            GwtApplication.this.setupLoop();
                        }
                    });
                    this.cancel();
                }
            }
        }.scheduleRepeating(100);
    }

    private void setupLoop() {
        try {
            this.graphics = new GwtGraphics(this.root, this.config);
        }
        catch (Throwable e) {
            this.root.clear();
            this.root.add((Widget)new Label("Sorry, your browser doesn't seem to support WebGL"));
            return;
        }
        this.lastWidth = this.graphics.getWidth();
        this.lastHeight = this.graphics.getHeight();
        Gdx.app = this;
        Gdx.audio = new GwtAudio();
        Gdx.graphics = this.graphics;
        Gdx.gl20 = this.graphics.getGL20();
        Gdx.gl = this.graphics.getGLCommon();
        Gdx.files = new GwtFiles(this.preloader);
        this.input = new GwtInput(this.graphics.canvas);
        Gdx.input = this.input;
        try {
            this.listener.create();
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
        }
        catch (Throwable t) {
            this.error("GwtApplication", "exception: " + t.getMessage(), t);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        new Timer(){

            public void run() {
                try {
                    GwtApplication.this.graphics.update();
                    if (Gdx.graphics.getWidth() != GwtApplication.this.lastWidth || Gdx.graphics.getHeight() != GwtApplication.this.lastHeight) {
                        GwtApplication.this.listener.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
                        GwtApplication.this.lastWidth = GwtApplication.this.graphics.getWidth();
                        GwtApplication.this.lastHeight = GwtApplication.this.graphics.getHeight();
                        Gdx.gl.glViewport(0, 0, GwtApplication.this.lastWidth, GwtApplication.this.lastHeight);
                    }
                    for (int i = 0; i < ((GwtApplication)GwtApplication.this).runnables.size; ++i) {
                        ((Runnable)GwtApplication.this.runnables.get(i)).run();
                    }
                    GwtApplication.this.runnables.clear();
                    GwtApplication.this.listener.render();
                    ((GwtApplication)GwtApplication.this).input.justTouched = false;
                }
                catch (Throwable t) {
                    GwtApplication.this.error("GwtApplication", "exception: " + t.getMessage(), t);
                    throw new RuntimeException(t);
                }
            }
        }.scheduleRepeating((int)(1.0f / (float)this.config.fps * 1000.0f));
    }

    public Panel getRootPanel() {
        return this.root;
    }

    public Preloader.PreloaderCallback getPreloaderCallback() {
        Canvas canvas = Canvas.createIfSupported();
        canvas.setWidth("" + (int)((float)this.config.width * 0.7f) + "px");
        canvas.setHeight("70px");
        this.getRootPanel().add((Widget)canvas);
        final Context2d context = canvas.getContext2d();
        context.setTextAlign(Context2d.TextAlign.CENTER);
        context.setTextBaseline(Context2d.TextBaseline.MIDDLE);
        context.setFont("18pt Calibri");
        return new Preloader.PreloaderCallback(){

            @Override
            public void done() {
                context.fillRect(0.0, 0.0, 300.0, 40.0);
            }

            @Override
            public void loaded(String file, int loaded, int total) {
                System.out.println("loaded " + file + "," + loaded + "/" + total);
                String color = Pixmap.make(30, 30, 30, 1.0f);
                context.setFillStyle(color);
                context.setStrokeStyle(color);
                context.fillRect(0.0, 0.0, 300.0, 70.0);
                color = Pixmap.make(200, 200, 200, (float)((TimeUtils.nanoTime() - GwtApplication.this.loadStart) % 1000000000L) / 1.0E9f);
                context.setFillStyle(color);
                context.setStrokeStyle(color);
                context.fillRect(0.0, 0.0, (double)(300.0f * ((float)loaded / (float)total) * 0.97f), 70.0);
                context.setFillStyle(Pixmap.make(50, 50, 50, 1.0f));
                context.fillText("loading", 150.0, 35.0);
            }

            @Override
            public void error(String file) {
                System.out.println("error: " + file);
            }
        };
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Audio getAudio() {
        return Gdx.audio;
    }

    public Input getInput() {
        return Gdx.input;
    }

    public Files getFiles() {
        return Gdx.files;
    }

    private void checkLogLabel() {
        if (this.log == null) {
            this.log = new TextArea();
            this.log.setSize(this.graphics.getWidth() + "px", "200px");
            this.log.setReadOnly(true);
            this.root.add((Widget)this.log);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message);
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.out.println(tag + ": " + message);
        }
    }

    public void log(String tag, String message, Exception exception) {
        if (this.logLevel >= 2) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n" + exception.getMessage() + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.out.println(tag + ": " + message + "\n" + exception.getMessage());
            System.out.println(this.getStackTrace(exception));
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message);
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.err.println(tag + ": " + message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n" + exception.getMessage());
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.err.println(tag + ": " + message + "\n" + exception.getMessage() + "\n");
            System.out.println(this.getStackTrace(exception));
        }
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.out.println(tag + ": " + message + "\n");
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.checkLogLabel();
            this.log.setText(this.log.getText() + "\n" + tag + ": " + message + "\n" + exception.getMessage() + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
            System.out.println(tag + ": " + message + "\n" + exception.getMessage());
            System.out.println(this.getStackTrace(exception));
        }
    }

    private String getStackTrace(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        for (StackTraceElement trace : e.getStackTrace()) {
            buffer.append(trace.toString() + "\n");
        }
        return buffer.toString();
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.WebGL;
    }

    public int getVersion() {
        return 0;
    }

    public long getJavaHeap() {
        return 0L;
    }

    public long getNativeHeap() {
        return 0L;
    }

    public Preferences getPreferences(String name) {
        Preferences pref = (Preferences)this.prefs.get((Object)name);
        if (pref == null) {
            pref = new GwtPreferences(name);
            this.prefs.put((Object)name, (Object)pref);
        }
        return pref;
    }

    public Clipboard getClipboard() {
        return new Clipboard(){

            public String getContents() {
                return null;
            }

            public void setContents(String content) {
            }
        };
    }

    public void postRunnable(Runnable runnable) {
        this.runnables.add(runnable);
    }

    public void exit() {
    }

    public static AgentInfo agentInfo() {
        return agentInfo;
    }

    private static native AgentInfo computeAgentInfo();

    public String getBaseUrl() {
        return this.preloader.baseUrl;
    }

    public Preloader getPreloader() {
        return this.preloader;
    }

    public static class AgentInfo
    extends JavaScriptObject {
        public final native boolean isFirefox();

        public final native boolean isChrome();

        public final native boolean isSafari();

        public final native boolean isOpera();

        public final native boolean isIE();

        public final native boolean isMacOS();

        public final native boolean isLinux();

        public final native boolean isWindows();

        protected AgentInfo() {
        }
    }
}

