/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.gwt.GwtApplicationConfiguration;
import com.badlogic.gdx.backends.gwt.GwtGL20;
import com.badlogic.gdx.backends.gwt.GwtGL20Debug;
import com.badlogic.gdx.graphics.GL10;
import com.badlogic.gdx.graphics.GL11;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLCommon;
import com.badlogic.gdx.graphics.GLU;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.webgl.client.WebGLContextAttributes;
import com.google.gwt.webgl.client.WebGLRenderingContext;

public class GwtGraphics
implements Graphics {
    CanvasElement canvas;
    WebGLRenderingContext context;
    GL20 gl;
    String extensions;
    float fps = 0.0f;
    long lastTimeStamp = System.currentTimeMillis();
    float deltaTime = 0.0f;
    float time = 0.0f;
    int frames;
    GwtApplicationConfiguration config;
    boolean inFullscreenMode = false;

    public GwtGraphics(Panel root, GwtApplicationConfiguration config) {
        Canvas canvasWidget = Canvas.createIfSupported();
        if (canvasWidget == null) {
            throw new GdxRuntimeException("Canvas not supported");
        }
        this.canvas = canvasWidget.getCanvasElement();
        root.add((Widget)canvasWidget);
        this.canvas.setWidth(config.width);
        this.canvas.setHeight(config.height);
        this.config = config;
        WebGLContextAttributes attributes = WebGLContextAttributes.create();
        attributes.setAntialias(config.antialiasing);
        attributes.setStencil(config.stencil);
        attributes.setAlpha(false);
        attributes.setPremultipliedAlpha(false);
        this.context = WebGLRenderingContext.getContext(this.canvas, attributes);
        this.context.viewport(0, 0, config.width, config.height);
        this.gl = config.useDebugGL ? new GwtGL20Debug(this.context) : new GwtGL20(this.context);
    }

    public WebGLRenderingContext getContext() {
        return this.context;
    }

    public boolean isGL11Available() {
        return false;
    }

    public boolean isGL20Available() {
        return true;
    }

    public GLCommon getGLCommon() {
        return this.gl;
    }

    public GL10 getGL10() {
        return null;
    }

    public GL11 getGL11() {
        return null;
    }

    public GL20 getGL20() {
        return this.gl;
    }

    public GLU getGLU() {
        return null;
    }

    public int getWidth() {
        return this.canvas.getWidth();
    }

    public int getHeight() {
        return this.canvas.getHeight();
    }

    public float getDeltaTime() {
        return this.deltaTime;
    }

    public int getFramesPerSecond() {
        return (int)this.fps;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.WebGL;
    }

    public float getPpiX() {
        return 96.0f;
    }

    public float getPpiY() {
        return 96.0f;
    }

    public float getPpcX() {
        return 37.795277f;
    }

    public float getPpcY() {
        return 37.795277f;
    }

    public boolean supportsDisplayModeChange() {
        return true;
    }

    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{new Graphics.DisplayMode(this.getScreenWidthJSNI(), this.getScreenHeightJSNI(), 60, 8){}};
    }

    private native int getScreenWidthJSNI();

    private native int getScreenHeightJSNI();

    private native boolean isFullscreenJSNI();

    private void fullscreenChanged() {
        if (!this.isFullscreen()) {
            this.canvas.setWidth(this.config.width);
            this.canvas.setHeight(this.config.height);
        }
    }

    private native boolean setFullscreenJSNI(GwtGraphics var1, CanvasElement var2);

    private native void exitFullscreen();

    public Graphics.DisplayMode getDesktopDisplayMode() {
        return new Graphics.DisplayMode(this.getScreenWidthJSNI(), this.getScreenHeightJSNI(), 60, 8){};
    }

    public boolean setDisplayMode(Graphics.DisplayMode displayMode) {
        if (displayMode.width != this.getScreenWidthJSNI() && displayMode.height != this.getScreenHeightJSNI()) {
            return false;
        }
        return this.setFullscreenJSNI(this, this.canvas);
    }

    public boolean setDisplayMode(int width, int height, boolean fullscreen) {
        if (fullscreen) {
            if (width != this.getScreenWidthJSNI() && height != this.getScreenHeightJSNI()) {
                return false;
            }
            return this.setFullscreenJSNI(this, this.canvas);
        }
        if (this.isFullscreenJSNI()) {
            this.exitFullscreen();
        }
        this.canvas.setWidth(width);
        this.canvas.setHeight(height);
        return true;
    }

    public Graphics.BufferFormat getBufferFormat() {
        return new Graphics.BufferFormat(8, 8, 8, 0, 16, this.config.stencil ? 8 : 0, 0, false);
    }

    public boolean supportsExtension(String extension) {
        if (this.extensions == null) {
            this.extensions = Gdx.gl.glGetString(7939);
        }
        return this.extensions.contains(extension);
    }

    public void update() {
        long currTimeStamp = System.currentTimeMillis();
        this.deltaTime = (float)(currTimeStamp - this.lastTimeStamp) / 1000.0f;
        this.lastTimeStamp = currTimeStamp;
        this.time += this.deltaTime;
        ++this.frames;
        if (this.time > 1.0f) {
            this.fps = this.frames;
            this.time = 0.0f;
            this.frames = 0;
        }
    }

    public void setTitle(String title) {
    }

    public void setVSync(boolean vsync) {
    }

    public float getDensity() {
        return 0.0f;
    }

    public void setContinuousRendering(boolean isContinuous) {
        throw new GdxRuntimeException("No supported");
    }

    public boolean isContinuousRendering() {
        throw new GdxRuntimeException("No supported");
    }

    public void requestRendering() {
        throw new GdxRuntimeException("No supported");
    }

    public float getRawDeltaTime() {
        return this.getDeltaTime();
    }

    public boolean isFullscreen() {
        return this.isFullscreenJSNI();
    }
}

