/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.gwt.widgets.TextInputDialogBox;
import com.badlogic.gdx.utils.TimeUtils;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import java.util.HashSet;
import java.util.Set;

public class GwtInput
implements Input {
    boolean touched = false;
    int mouseX;
    int mouseY;
    int deltaX;
    int deltaY;
    boolean justTouched = false;
    Set<Integer> pressedButtons = new HashSet<Integer>();
    Set<Integer> pressedKeys = new HashSet<Integer>();
    InputProcessor processor;
    char lastKeyCharPressed;
    float keyRepeatTimer;
    long currentEventTimeStamp;
    final CanvasElement canvas;
    boolean hasFocus = true;
    private static final int KEY_PAUSE = 19;
    private static final int KEY_CAPS_LOCK = 20;
    private static final int KEY_SPACE = 32;
    private static final int KEY_INSERT = 45;
    private static final int KEY_0 = 48;
    private static final int KEY_1 = 49;
    private static final int KEY_2 = 50;
    private static final int KEY_3 = 51;
    private static final int KEY_4 = 52;
    private static final int KEY_5 = 53;
    private static final int KEY_6 = 54;
    private static final int KEY_7 = 55;
    private static final int KEY_8 = 56;
    private static final int KEY_9 = 57;
    private static final int KEY_A = 65;
    private static final int KEY_B = 66;
    private static final int KEY_C = 67;
    private static final int KEY_D = 68;
    private static final int KEY_E = 69;
    private static final int KEY_F = 70;
    private static final int KEY_G = 71;
    private static final int KEY_H = 72;
    private static final int KEY_I = 73;
    private static final int KEY_J = 74;
    private static final int KEY_K = 75;
    private static final int KEY_L = 76;
    private static final int KEY_M = 77;
    private static final int KEY_N = 78;
    private static final int KEY_O = 79;
    private static final int KEY_P = 80;
    private static final int KEY_Q = 81;
    private static final int KEY_R = 82;
    private static final int KEY_S = 83;
    private static final int KEY_T = 84;
    private static final int KEY_U = 85;
    private static final int KEY_V = 86;
    private static final int KEY_W = 87;
    private static final int KEY_X = 88;
    private static final int KEY_Y = 89;
    private static final int KEY_Z = 90;
    private static final int KEY_LEFT_WINDOW_KEY = 91;
    private static final int KEY_RIGHT_WINDOW_KEY = 92;
    private static final int KEY_SELECT_KEY = 93;
    private static final int KEY_NUMPAD0 = 96;
    private static final int KEY_NUMPAD1 = 97;
    private static final int KEY_NUMPAD2 = 98;
    private static final int KEY_NUMPAD3 = 99;
    private static final int KEY_NUMPAD4 = 100;
    private static final int KEY_NUMPAD5 = 101;
    private static final int KEY_NUMPAD6 = 102;
    private static final int KEY_NUMPAD7 = 103;
    private static final int KEY_NUMPAD8 = 104;
    private static final int KEY_NUMPAD9 = 105;
    private static final int KEY_MULTIPLY = 106;
    private static final int KEY_ADD = 107;
    private static final int KEY_SUBTRACT = 109;
    private static final int KEY_DECIMAL_POINT_KEY = 110;
    private static final int KEY_DIVIDE = 111;
    private static final int KEY_F1 = 112;
    private static final int KEY_F2 = 113;
    private static final int KEY_F3 = 114;
    private static final int KEY_F4 = 115;
    private static final int KEY_F5 = 116;
    private static final int KEY_F6 = 117;
    private static final int KEY_F7 = 118;
    private static final int KEY_F8 = 119;
    private static final int KEY_F9 = 120;
    private static final int KEY_F10 = 121;
    private static final int KEY_F11 = 122;
    private static final int KEY_F12 = 123;
    private static final int KEY_NUM_LOCK = 144;
    private static final int KEY_SCROLL_LOCK = 145;
    private static final int KEY_SEMICOLON = 186;
    private static final int KEY_EQUALS = 187;
    private static final int KEY_COMMA = 188;
    private static final int KEY_DASH = 189;
    private static final int KEY_PERIOD = 190;
    private static final int KEY_FORWARD_SLASH = 191;
    private static final int KEY_GRAVE_ACCENT = 192;
    private static final int KEY_OPEN_BRACKET = 219;
    private static final int KEY_BACKSLASH = 220;
    private static final int KEY_CLOSE_BRACKET = 221;
    private static final int KEY_SINGLE_QUOTE = 222;

    public GwtInput(CanvasElement canvas) {
        this.canvas = canvas;
        this.hookEvents();
    }

    public float getAccelerometerX() {
        return 0.0f;
    }

    public float getAccelerometerY() {
        return 0.0f;
    }

    public float getAccelerometerZ() {
        return 0.0f;
    }

    public int getX() {
        return this.mouseX;
    }

    public int getX(int pointer) {
        if (pointer != 0) {
            return 0;
        }
        return this.mouseX;
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaX(int pointer) {
        if (pointer != 0) {
            return 0;
        }
        return this.deltaX;
    }

    public int getY() {
        return this.mouseY;
    }

    public int getY(int pointer) {
        if (pointer != 0) {
            return 0;
        }
        return this.mouseY;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public int getDeltaY(int pointer) {
        if (pointer != 0) {
            return 0;
        }
        return this.deltaY;
    }

    public boolean isTouched() {
        return this.touched;
    }

    public boolean justTouched() {
        return this.justTouched;
    }

    public boolean isTouched(int pointer) {
        if (pointer != 0) {
            return false;
        }
        return this.touched;
    }

    public boolean isButtonPressed(int button) {
        return button == 0 && this.touched;
    }

    public boolean isKeyPressed(int key) {
        if (key == -1) {
            return this.pressedKeys.size() > 0;
        }
        return this.pressedKeys.contains(key);
    }

    public void getTextInput(Input.TextInputListener listener, String title, String text) {
        TextInputDialogBox dialog = new TextInputDialogBox(title, text, null);
        final Input.TextInputListener capturedListener = listener;
        dialog.setListener(new TextInputDialogBox.TextInputDialogListener(){

            @Override
            public void onPositive(String text) {
                if (capturedListener != null) {
                    capturedListener.input(text);
                }
            }

            @Override
            public void onNegative() {
                if (capturedListener != null) {
                    capturedListener.canceled();
                }
            }
        });
    }

    public void getPlaceholderTextInput(Input.TextInputListener listener, String title, String placeholder) {
        TextInputDialogBox dialog = new TextInputDialogBox(title, null, placeholder);
        final Input.TextInputListener capturedListener = listener;
        dialog.setListener(new TextInputDialogBox.TextInputDialogListener(){

            @Override
            public void onPositive(String text) {
                if (capturedListener != null) {
                    capturedListener.input(text);
                }
            }

            @Override
            public void onNegative() {
                if (capturedListener != null) {
                    capturedListener.canceled();
                }
            }
        });
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    public void vibrate(int milliseconds) {
    }

    public void vibrate(long[] pattern, int repeat) {
    }

    public void cancelVibrate() {
    }

    public float getAzimuth() {
        return 0.0f;
    }

    public float getPitch() {
        return 0.0f;
    }

    public float getRoll() {
        return 0.0f;
    }

    public void getRotationMatrix(float[] matrix) {
    }

    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    public void setCatchBackKey(boolean catchBack) {
    }

    public void setCatchMenuKey(boolean catchMenu) {
    }

    public void setInputProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Accelerometer) {
            return false;
        }
        if (peripheral == Input.Peripheral.Compass) {
            return false;
        }
        if (peripheral == Input.Peripheral.HardwareKeyboard) {
            return true;
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return false;
        }
        if (peripheral == Input.Peripheral.OnscreenKeyboard) {
            return false;
        }
        if (peripheral == Input.Peripheral.Vibrator) {
            return false;
        }
        return false;
    }

    public int getRotation() {
        return 0;
    }

    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Landscape;
    }

    private native boolean isCursorCatchedJSNI();

    private native void setCursorCatchedJSNI(CanvasElement var1);

    private native void exitCursorCatchedJSNI();

    private native float getMovementXJSNI(NativeEvent var1);

    private native float getMovementYJSNI(NativeEvent var1);

    public void setCursorCatched(boolean catched) {
        if (catched) {
            this.setCursorCatchedJSNI(this.canvas);
        } else {
            this.exitCursorCatchedJSNI();
        }
    }

    public boolean isCursorCatched() {
        return this.isCursorCatchedJSNI();
    }

    public void setCursorPosition(int x, int y) {
    }

    static native void addEventListener(JavaScriptObject var0, String var1, GwtInput var2, boolean var3);

    private static native float getMouseWheelVelocity(NativeEvent var0);

    protected static native String getMouseWheelEvent();

    protected static float getRelativeX(NativeEvent e, Element target) {
        return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft();
    }

    protected static float getRelativeY(NativeEvent e, Element target) {
        return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
    }

    private void hookEvents() {
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "mousedown", this, true);
        GwtInput.addEventListener((JavaScriptObject)Document.get(), "mousedown", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "mouseup", this, true);
        GwtInput.addEventListener((JavaScriptObject)Document.get(), "mouseup", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, "mousemove", this, true);
        GwtInput.addEventListener((JavaScriptObject)Document.get(), "mousemove", this, true);
        GwtInput.addEventListener((JavaScriptObject)this.canvas, GwtInput.getMouseWheelEvent(), this, true);
        GwtInput.addEventListener((JavaScriptObject)Document.get(), "keydown", this, false);
        GwtInput.addEventListener((JavaScriptObject)Document.get(), "keyup", this, false);
        GwtInput.addEventListener((JavaScriptObject)Document.get(), "keypress", this, false);
    }

    private int getButton(int button) {
        if (button == 1) {
            return 0;
        }
        if (button == 2) {
            return 1;
        }
        if (button == 4) {
            return 2;
        }
        return 0;
    }

    private void handleEvent(NativeEvent e) {
        int code;
        if (e.getType().equals("mousedown")) {
            if (!e.getEventTarget().equals((Object)this.canvas) || this.touched) {
                float mouseX = (int)GwtInput.getRelativeX(e, (Element)this.canvas);
                float mouseY = (int)GwtInput.getRelativeY(e, (Element)this.canvas);
                if (mouseX < 0.0f || mouseX > (float)Gdx.graphics.getWidth() || mouseY < 0.0f || mouseY > (float)Gdx.graphics.getHeight()) {
                    this.hasFocus = false;
                }
                return;
            }
            this.hasFocus = true;
            this.justTouched = true;
            this.touched = true;
            this.pressedButtons.add(this.getButton(e.getButton()));
            this.deltaX = 0;
            this.deltaY = 0;
            if (this.isCursorCatched()) {
                this.mouseX = (int)((float)this.mouseX + this.getMovementXJSNI(e));
                this.mouseY = (int)((float)this.mouseY + this.getMovementYJSNI(e));
            } else {
                this.mouseX = (int)GwtInput.getRelativeX(e, (Element)this.canvas);
                this.mouseY = (int)GwtInput.getRelativeY(e, (Element)this.canvas);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            if (this.processor != null) {
                this.processor.touchDown(this.mouseX, this.mouseY, 0, this.getButton(e.getButton()));
            }
        }
        if (e.getType().equals("mousemove")) {
            if (this.isCursorCatched()) {
                this.deltaX = (int)this.getMovementXJSNI(e);
                this.deltaY = (int)this.getMovementYJSNI(e);
                this.mouseX = (int)((float)this.mouseX + this.getMovementXJSNI(e));
                this.mouseY = (int)((float)this.mouseY + this.getMovementYJSNI(e));
            } else {
                this.deltaX = (int)GwtInput.getRelativeX(e, (Element)this.canvas) - this.mouseX;
                this.deltaY = (int)GwtInput.getRelativeY(e, (Element)this.canvas) - this.mouseY;
                this.mouseX = (int)GwtInput.getRelativeX(e, (Element)this.canvas);
                this.mouseY = (int)GwtInput.getRelativeY(e, (Element)this.canvas);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            if (this.processor != null) {
                if (this.touched) {
                    this.processor.touchDragged(this.mouseX, this.mouseY, 0);
                } else {
                    this.processor.mouseMoved(this.mouseX, this.mouseY);
                }
            }
        }
        if (e.getType().equals("mouseup")) {
            if (!this.touched) {
                return;
            }
            this.pressedButtons.remove(this.getButton(e.getButton()));
            boolean bl = this.touched = this.pressedButtons.size() > 0;
            if (this.isCursorCatched()) {
                this.deltaX = (int)this.getMovementXJSNI(e);
                this.deltaY = (int)this.getMovementYJSNI(e);
                this.mouseX = (int)((float)this.mouseX + this.getMovementXJSNI(e));
                this.mouseY = (int)((float)this.mouseY + this.getMovementYJSNI(e));
            } else {
                this.deltaX = (int)GwtInput.getRelativeX(e, (Element)this.canvas) - this.mouseX;
                this.deltaY = (int)GwtInput.getRelativeY(e, (Element)this.canvas) - this.mouseY;
                this.mouseX = (int)GwtInput.getRelativeX(e, (Element)this.canvas);
                this.mouseY = (int)GwtInput.getRelativeY(e, (Element)this.canvas);
            }
            this.currentEventTimeStamp = TimeUtils.nanoTime();
            this.touched = false;
            if (this.processor != null) {
                this.processor.touchUp(this.mouseX, this.mouseY, 0, this.getButton(e.getButton()));
            }
        }
        if (e.getType().equals("keydown") && this.hasFocus) {
            System.out.println("keydown");
            code = GwtInput.keyForCode(e.getKeyCode());
            if (code == 67) {
                e.preventDefault();
                if (this.processor != null) {
                    this.processor.keyDown(code);
                    this.processor.keyTyped('\b');
                }
            } else {
                this.pressedKeys.add(code);
                if (this.processor != null) {
                    this.processor.keyDown(code);
                }
            }
        }
        if (e.getType().equals("keypress") && this.hasFocus) {
            System.out.println("keypress");
            char c = (char)e.getCharCode();
            if (this.processor != null) {
                this.processor.keyTyped(c);
            }
        }
        if (e.getType().equals("keyup") && this.hasFocus) {
            System.out.println("keyup");
            code = GwtInput.keyForCode(e.getKeyCode());
            this.pressedKeys.remove(code);
            if (this.processor != null) {
                this.processor.keyUp(code);
            }
        }
    }

    private static int keyForCode(int keyCode) {
        switch (keyCode) {
            case 18: {
                return 57;
            }
            case 8: {
                return 67;
            }
            case 17: {
                return 129;
            }
            case 46: {
                return 67;
            }
            case 40: {
                return 20;
            }
            case 35: {
                return 132;
            }
            case 13: {
                return 66;
            }
            case 27: {
                return 131;
            }
            case 36: {
                return 3;
            }
            case 37: {
                return 21;
            }
            case 34: {
                return 93;
            }
            case 33: {
                return 92;
            }
            case 39: {
                return 22;
            }
            case 16: {
                return 59;
            }
            case 9: {
                return 61;
            }
            case 38: {
                return 19;
            }
            case 19: {
                return 0;
            }
            case 20: {
                return 0;
            }
            case 32: {
                return 62;
            }
            case 45: {
                return 133;
            }
            case 48: {
                return 7;
            }
            case 49: {
                return 8;
            }
            case 50: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 52: {
                return 11;
            }
            case 53: {
                return 12;
            }
            case 54: {
                return 13;
            }
            case 55: {
                return 14;
            }
            case 56: {
                return 15;
            }
            case 57: {
                return 16;
            }
            case 65: {
                return 29;
            }
            case 66: {
                return 30;
            }
            case 67: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 69: {
                return 33;
            }
            case 70: {
                return 34;
            }
            case 71: {
                return 35;
            }
            case 72: {
                return 36;
            }
            case 73: {
                return 37;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 39;
            }
            case 76: {
                return 40;
            }
            case 77: {
                return 41;
            }
            case 78: {
                return 42;
            }
            case 79: {
                return 43;
            }
            case 80: {
                return 44;
            }
            case 81: {
                return 45;
            }
            case 82: {
                return 46;
            }
            case 83: {
                return 47;
            }
            case 84: {
                return 48;
            }
            case 85: {
                return 49;
            }
            case 86: {
                return 50;
            }
            case 87: {
                return 51;
            }
            case 88: {
                return 52;
            }
            case 89: {
                return 53;
            }
            case 90: {
                return 54;
            }
            case 91: {
                return 0;
            }
            case 92: {
                return 0;
            }
            case 96: {
                return 7;
            }
            case 97: {
                return 8;
            }
            case 98: {
                return 9;
            }
            case 99: {
                return 10;
            }
            case 100: {
                return 11;
            }
            case 101: {
                return 12;
            }
            case 102: {
                return 13;
            }
            case 103: {
                return 14;
            }
            case 104: {
                return 15;
            }
            case 105: {
                return 16;
            }
            case 106: {
                return 0;
            }
            case 107: {
                return 81;
            }
            case 109: {
                return 69;
            }
            case 110: {
                return 56;
            }
            case 111: {
                return 0;
            }
            case 112: {
                return 244;
            }
            case 113: {
                return 245;
            }
            case 114: {
                return 246;
            }
            case 115: {
                return 247;
            }
            case 116: {
                return 248;
            }
            case 117: {
                return 249;
            }
            case 118: {
                return 250;
            }
            case 119: {
                return 251;
            }
            case 120: {
                return 252;
            }
            case 121: {
                return 253;
            }
            case 122: {
                return 254;
            }
            case 123: {
                return 255;
            }
            case 144: {
                return 78;
            }
            case 145: {
                return 0;
            }
            case 186: {
                return 74;
            }
            case 187: {
                return 70;
            }
            case 188: {
                return 55;
            }
            case 189: {
                return 69;
            }
            case 190: {
                return 56;
            }
            case 191: {
                return 76;
            }
            case 192: {
                return 0;
            }
            case 219: {
                return 71;
            }
            case 220: {
                return 73;
            }
            case 221: {
                return 72;
            }
            case 222: {
                return 75;
            }
        }
        return 0;
    }
}

