/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.gwt.GwtApplication;
import com.badlogic.gdx.backends.gwt.soundmanager2.SMSound;
import com.badlogic.gdx.backends.gwt.soundmanager2.SoundManager;
import com.badlogic.gdx.files.FileHandle;

public class GwtMusic
implements Music {
    boolean isPlaying = false;
    boolean isLooping = false;
    SMSound sound;

    public GwtMusic(FileHandle file) {
        String url = ((GwtApplication)Gdx.app).getBaseUrl() + file.path();
        this.sound = SoundManager.createSound(url, url);
        this.sound.loops(0);
    }

    public void play() {
        if (this.isPlaying()) {
            return;
        }
        this.sound.play();
        this.isPlaying = true;
    }

    public void pause() {
        this.sound.pause();
        this.isPlaying = false;
    }

    public void stop() {
        this.sound.stop();
        this.isPlaying = false;
    }

    public boolean isPlaying() {
        this.isPlaying &= this.sound.playState() == 1;
        return this.isPlaying;
    }

    public void setLooping(boolean isLooping) {
        this.sound.loops(isLooping ? 999 : 0);
        this.isLooping = isLooping;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setVolume(float volume) {
        this.sound.setVolume((int)(volume * 100.0f));
    }

    public float getPosition() {
        return (float)this.sound.getPosition() / 1000.0f;
    }

    public void dispose() {
        this.sound.destruct();
    }
}

