/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.backends.gwt.preloader.LoaderCallback;
import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;
import java.io.IOException;
import java.io.InputStream;

public class BinaryLoader {
    private final LoaderCallback<Blob> callback;

    public BinaryLoader(String url, LoaderCallback<Blob> callback) {
        this.callback = callback;
        XMLHttpRequest request = XMLHttpRequest.create();
        request.setOnReadyStateChange(new ReadyStateChangeHandler(){

            public void onReadyStateChange(XMLHttpRequest xhr) {
                if (xhr.getReadyState() == 4) {
                    int status = xhr.getStatus();
                    if (status != 200) {
                        BinaryLoader.this.callback.error();
                    } else {
                        BinaryLoader.this.callback.success(new Blob(xhr.getResponseText()));
                    }
                }
            }
        });
        this.overrideMimeType(request, "text/plain; charset=x-user-defined");
        request.open("GET", url);
        request.send();
    }

    private native void overrideMimeType(XMLHttpRequest var1, String var2);

    private static class BlobInputStream
    extends InputStream {
        Blob blob;
        int pos;

        public BlobInputStream(Blob blob) {
            this.blob = blob;
        }

        @Override
        public int read() throws IOException {
            if (this.pos == this.blob.length()) {
                return -1;
            }
            return this.blob.get(this.pos++) & 0xFF;
        }
    }

    public static final class Blob {
        final String data;

        public Blob(String data) {
            this.data = data;
        }

        public int length() {
            return this.data.length();
        }

        public byte get(int i) {
            return this.get(this.data, i);
        }

        private native byte get(String var1, int var2);

        public InputStream read() {
            return new BlobInputStream(this);
        }
    }
}

