/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.backends.gwt.preloader.AssetFilter;

public class DefaultAssetFilter
implements AssetFilter {
    private String extension(String file) {
        String name = file;
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return name.substring(dotIndex + 1);
    }

    @Override
    public boolean accept(String file, boolean isDirectory) {
        return !isDirectory || !file.endsWith(".svn");
    }

    @Override
    public AssetFilter.AssetType getType(String file) {
        String extension = this.extension(file).toLowerCase();
        if (this.isImage(extension)) {
            return AssetFilter.AssetType.Image;
        }
        if (this.isAudio(extension)) {
            return AssetFilter.AssetType.Audio;
        }
        if (this.isText(extension)) {
            return AssetFilter.AssetType.Text;
        }
        return AssetFilter.AssetType.Binary;
    }

    private boolean isImage(String extension) {
        return extension.equals("jpg") || extension.equals("png") || extension.equals("bmp") || extension.equals("gif");
    }

    private boolean isText(String extension) {
        return extension.equals("json") || extension.equals("xml") || extension.equals("txt") || extension.equals("glsl") || extension.equals("fnt") || extension.equals("pack") || extension.equals("obj");
    }

    private boolean isAudio(String extension) {
        return extension.equals("mp3") || extension.equals("ogg") || extension.equals("wav");
    }
}

