/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class FileWrapper {
    protected File file;
    protected Files.FileType type;

    protected FileWrapper() {
    }

    public FileWrapper(String fileName) {
        this.file = new File(fileName);
        this.type = Files.FileType.Absolute;
    }

    public FileWrapper(File file) {
        this.file = file;
        this.type = Files.FileType.Absolute;
    }

    protected FileWrapper(String fileName, Files.FileType type) {
        this.type = type;
        this.file = new File(fileName);
    }

    protected FileWrapper(File file, Files.FileType type) {
        this.file = file;
        this.type = type;
    }

    public String path() {
        return this.file.getPath();
    }

    public String name() {
        return this.file.getName();
    }

    public String extension() {
        String name = this.file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return name.substring(dotIndex + 1);
    }

    public String nameWithoutExtension() {
        String name = this.file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public Files.FileType type() {
        return this.type;
    }

    public File file() {
        if (this.type == Files.FileType.External) {
            return new File(Gdx.files.getExternalStoragePath(), this.file.getPath());
        }
        return this.file;
    }

    public InputStream read() {
        if (this.type == Files.FileType.Classpath || this.type == Files.FileType.Internal && !this.file.exists() || this.type == Files.FileType.Local && !this.file.exists()) {
            InputStream input = FileWrapper.class.getResourceAsStream("/" + this.file.getPath().replace('\\', '/'));
            if (input == null) {
                throw new GdxRuntimeException("File not found: " + this.file + " (" + this.type + ")");
            }
            return input;
        }
        try {
            return new FileInputStream(this.file());
        }
        catch (Exception ex) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + this.type + ")", (Throwable)ex);
            }
            throw new GdxRuntimeException("Error reading file: " + this.file + " (" + this.type + ")", (Throwable)ex);
        }
    }

    public BufferedInputStream read(int bufferSize) {
        return new BufferedInputStream(this.read(), bufferSize);
    }

    public Reader reader() {
        return new InputStreamReader(this.read());
    }

    public Reader reader(String charset) {
        try {
            return new InputStreamReader(this.read(), charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new GdxRuntimeException("Error reading file: " + this, (Throwable)ex);
        }
    }

    public BufferedReader reader(int bufferSize) {
        return new BufferedReader(new InputStreamReader(this.read()), bufferSize);
    }

    public BufferedReader reader(int bufferSize, String charset) {
        try {
            return new BufferedReader(new InputStreamReader(this.read(), charset), bufferSize);
        }
        catch (UnsupportedEncodingException ex) {
            throw new GdxRuntimeException("Error reading file: " + this, (Throwable)ex);
        }
    }

    public String readString() {
        return this.readString(null);
    }

    public String readString(String charset) {
        int fileLength = (int)this.length();
        if (fileLength == 0) {
            fileLength = 512;
        }
        StringBuilder output = new StringBuilder(fileLength);
        InputStreamReader reader = null;
        try {
            int length;
            reader = charset == null ? new InputStreamReader(this.read()) : new InputStreamReader(this.read(), charset);
            char[] buffer = new char[256];
            while ((length = reader.read(buffer)) != -1) {
                output.append(buffer, 0, length);
            }
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading layout file: " + this, (Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ignored) {}
        }
        return output.toString();
    }

    public byte[] readBytes() {
        int length = (int)this.length();
        if (length == 0) {
            length = 512;
        }
        byte[] buffer = new byte[length];
        int position = 0;
        InputStream input = this.read();
        try {
            int count;
            while ((count = input.read(buffer, position, buffer.length - position)) != -1) {
                if ((position += count) != buffer.length) continue;
                byte[] newBuffer = new byte[buffer.length * 2];
                System.arraycopy(buffer, 0, newBuffer, 0, position);
                buffer = newBuffer;
            }
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading file: " + this, (Throwable)ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ignored) {}
        }
        if (position < buffer.length) {
            byte[] newBuffer = new byte[position];
            System.arraycopy(buffer, 0, newBuffer, 0, position);
            buffer = newBuffer;
        }
        return buffer;
    }

    public int readBytes(byte[] bytes, int offset, int size) {
        InputStream input = this.read();
        int position = 0;
        try {
            int count;
            while ((count = input.read(bytes, offset + position, size - position)) > 0) {
                position += count;
            }
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading file: " + this, (Throwable)ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ignored) {}
        }
        return position - offset;
    }

    public OutputStream write(boolean append) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot write to a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot write to an internal file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            return new FileOutputStream(this.file(), append);
        }
        catch (Exception ex) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + this.type + ")", (Throwable)ex);
            }
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + this.type + ")", (Throwable)ex);
        }
    }

    public void write(InputStream input, boolean append) {
        OutputStream output = null;
        try {
            int length;
            output = this.write(append);
            byte[] buffer = new byte[4096];
            while ((length = input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error stream writing to file: " + this.file + " (" + this.type + ")", (Throwable)ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception ignored) {}
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    public Writer writer(boolean append) {
        return this.writer(append, null);
    }

    public Writer writer(boolean append, String charset) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot write to a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot write to an internal file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            FileOutputStream output = new FileOutputStream(this.file(), append);
            if (charset == null) {
                return new OutputStreamWriter(output);
            }
            return new OutputStreamWriter(output, charset);
        }
        catch (IOException ex) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + this.type + ")", (Throwable)ex);
            }
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + this.type + ")", (Throwable)ex);
        }
    }

    public void writeString(String string, boolean append) {
        this.writeString(string, append, null);
    }

    public void writeString(String string, boolean append, String charset) {
        Writer writer = null;
        try {
            writer = this.writer(append, charset);
            writer.write(string);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + this.type + ")", (Throwable)ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    public void writeBytes(byte[] bytes, boolean append) {
        OutputStream output = this.write(append);
        try {
            output.write(bytes);
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + this.type + ")", (Throwable)ex);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException ignored) {}
        }
    }

    public void writeBytes(byte[] bytes, int offset, int length, boolean append) {
        OutputStream output = this.write(append);
        try {
            output.write(bytes, offset, length);
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + this.type + ")", (Throwable)ex);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException ignored) {}
        }
    }

    public FileWrapper[] list() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot list a classpath directory: " + this.file);
        }
        String[] relativePaths = this.file().list();
        if (relativePaths == null) {
            return new FileWrapper[0];
        }
        FileWrapper[] handles = new FileWrapper[relativePaths.length];
        int n = relativePaths.length;
        for (int i = 0; i < n; ++i) {
            handles[i] = this.child(relativePaths[i]);
        }
        return handles;
    }

    public FileWrapper[] list(String suffix) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot list a classpath directory: " + this.file);
        }
        String[] relativePaths = this.file().list();
        if (relativePaths == null) {
            return new FileWrapper[0];
        }
        FileWrapper[] handles = new FileWrapper[relativePaths.length];
        int count = 0;
        int n = relativePaths.length;
        for (int i = 0; i < n; ++i) {
            String path = relativePaths[i];
            if (!path.endsWith(suffix)) continue;
            handles[count] = this.child(path);
            ++count;
        }
        if (count < relativePaths.length) {
            FileWrapper[] newHandles = new FileWrapper[count];
            System.arraycopy(handles, 0, newHandles, 0, count);
            handles = newHandles;
        }
        return handles;
    }

    public boolean isDirectory() {
        if (this.type == Files.FileType.Classpath) {
            return false;
        }
        return this.file().isDirectory();
    }

    public FileWrapper child(String name) {
        if (this.file.getPath().length() == 0) {
            return new FileWrapper(new File(name), this.type);
        }
        return new FileWrapper(new File(this.file, name), this.type);
    }

    public FileWrapper parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new FileWrapper(parent, this.type);
    }

    public void mkdirs() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot mkdirs with a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot mkdirs with an internal file: " + this.file);
        }
        this.file().mkdirs();
    }

    public boolean exists() {
        switch (this.type) {
            case Internal: {
                if (this.file.exists()) {
                    return true;
                }
            }
            case Classpath: {
                return FileWrapper.class.getResource("/" + this.file.getPath().replace('\\', '/')) != null;
            }
        }
        return this.file().exists();
    }

    public boolean delete() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot delete a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot delete an internal file: " + this.file);
        }
        return this.file().delete();
    }

    public boolean deleteDirectory() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot delete a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot delete an internal file: " + this.file);
        }
        return FileWrapper.deleteDirectory(this.file());
    }

    public void copyTo(FileWrapper dest) {
        boolean sourceDir = this.isDirectory();
        if (!sourceDir) {
            if (dest.isDirectory()) {
                dest = dest.child(this.name());
            }
            FileWrapper.copyFile(this, dest);
            return;
        }
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                throw new GdxRuntimeException("Destination exists but is not a directory: " + dest);
            }
        } else {
            dest.mkdirs();
            if (!dest.isDirectory()) {
                throw new GdxRuntimeException("Destination directory cannot be created: " + dest);
            }
        }
        if (!sourceDir) {
            dest = dest.child(this.name());
        }
        FileWrapper.copyDirectory(this, dest);
    }

    public void moveTo(FileWrapper dest) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot move a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot move an internal file: " + this.file);
        }
        this.copyTo(dest);
        this.delete();
    }

    public long length() {
        return this.file().length();
    }

    public long lastModified() {
        return this.file().lastModified();
    }

    public String toString() {
        return this.file.getPath();
    }

    public static FileWrapper tempFile(String prefix) {
        try {
            return new FileWrapper(File.createTempFile(prefix, null));
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Unable to create temp file.", (Throwable)ex);
        }
    }

    public static FileWrapper tempDirectory(String prefix) {
        try {
            File file = File.createTempFile(prefix, null);
            if (!file.delete()) {
                throw new IOException("Unable to delete temp file: " + file);
            }
            if (!file.mkdir()) {
                throw new IOException("Unable to create temp directory: " + file);
            }
            return new FileWrapper(file);
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Unable to create temp file.", (Throwable)ex);
        }
    }

    private static boolean deleteDirectory(File file) {
        File[] files;
        if (file.exists() && (files = file.listFiles()) != null) {
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                if (files[i].isDirectory()) {
                    FileWrapper.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return file.delete();
    }

    private static void copyFile(FileWrapper source, FileWrapper dest) {
        try {
            dest.write(source.read(), false);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error copying source file: " + source.file + " (" + source.type + ")\n" + "To destination: " + dest.file + " (" + dest.type + ")", (Throwable)ex);
        }
    }

    private static void copyDirectory(FileWrapper sourceDir, FileWrapper destDir) {
        destDir.mkdirs();
        for (FileWrapper srcFile : sourceDir.list()) {
            FileWrapper destFile = destDir.child(srcFile.name());
            if (srcFile.isDirectory()) {
                FileWrapper.copyDirectory(srcFile, destFile);
                continue;
            }
            FileWrapper.copyFile(srcFile, destFile);
        }
    }
}

