/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.backends.gwt.preloader.AssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.DefaultAssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.FileWrapper;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PreloaderBundleGenerator
extends Generator {
    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        String assetPath = this.getAssetPath(context);
        String assetOutputPath = this.getAssetOutputPath(context);
        if (assetOutputPath == null) {
            assetOutputPath = "war/";
        }
        AssetFilter assetFilter = this.getAssetFilter(context);
        FileWrapper source = new FileWrapper(assetPath);
        if (!source.exists() && !(source = new FileWrapper("../" + assetPath)).exists()) {
            throw new RuntimeException("assets path '" + assetPath + "' does not exist. Check your gdx.assetpath property in your GWT project's module gwt.xml file");
        }
        if (!source.isDirectory()) {
            throw new RuntimeException("assets path '" + assetPath + "' is not a directory. Check your gdx.assetpath property in your GWT project's module gwt.xml file");
        }
        System.out.println("Copying resources from " + assetPath + " to " + assetOutputPath);
        System.out.println(source.file.getAbsolutePath());
        FileWrapper target = new FileWrapper("assets/");
        System.out.println(target.file.getAbsolutePath());
        if (!target.file.getAbsolutePath().replace("\\", "/").endsWith(assetOutputPath + "assets")) {
            target = new FileWrapper(assetOutputPath + "assets/");
        }
        if (target.exists() && !target.deleteDirectory()) {
            throw new RuntimeException("Couldn't clean target path '" + target + "'");
        }
        ArrayList<Asset> assets = new ArrayList<Asset>();
        this.copyDirectory(source, target, assetFilter, assets);
        StringBuffer buffer = new StringBuffer();
        for (Asset asset : assets) {
            String path = asset.file.path().replace('\\', '/').replace(assetOutputPath + "assets/", "").replaceFirst("assets", "");
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            buffer.append(asset.type.code);
            buffer.append(":");
            buffer.append(path);
            buffer.append("\n");
        }
        target.child("assets.txt").writeString(buffer.toString(), false);
        System.out.println(buffer.toString());
        return this.createDummyClass(logger, context);
    }

    private void copyFile(FileWrapper source, FileWrapper dest, AssetFilter filter, ArrayList<Asset> assets) {
        if (filter.accept(dest.path(), false)) {
            // empty if block
        }
        try {
            assets.add(new Asset(dest, filter.getType(dest.path())));
            dest.write(source.read(), false);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error copying source file: " + source + "\n" + "To destination: " + dest, (Throwable)ex);
        }
    }

    private void copyDirectory(FileWrapper sourceDir, FileWrapper destDir, AssetFilter filter, ArrayList<Asset> assets) {
        if (!filter.accept(destDir.path(), true)) {
            return;
        }
        assets.add(new Asset(destDir, AssetFilter.AssetType.Directory));
        destDir.mkdirs();
        for (FileWrapper srcFile : sourceDir.list()) {
            FileWrapper destFile = destDir.child(srcFile.name());
            if (srcFile.isDirectory()) {
                this.copyDirectory(srcFile, destFile, filter, assets);
                continue;
            }
            this.copyFile(srcFile, destFile, filter, assets);
        }
    }

    private AssetFilter getAssetFilter(GeneratorContext context) {
        ConfigurationProperty assetFilterClassProperty = null;
        try {
            assetFilterClassProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetfilterclass");
        }
        catch (BadPropertyValueException e) {
            return new DefaultAssetFilter();
        }
        if (assetFilterClassProperty.getValues().size() == 0) {
            return new DefaultAssetFilter();
        }
        String assetFilterClass = (String)assetFilterClassProperty.getValues().get(0);
        if (assetFilterClass == null) {
            return new DefaultAssetFilter();
        }
        try {
            return (AssetFilter)Class.forName(assetFilterClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate custom AssetFilter '" + assetFilterClass + "', make sure the class is public and has a public default constructor", e);
        }
    }

    private String getAssetPath(GeneratorContext context) {
        ConfigurationProperty assetPathProperty = null;
        try {
            assetPathProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetpath");
        }
        catch (BadPropertyValueException e) {
            throw new RuntimeException("No gdx.assetpath defined. Add <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> to your GWT projects gwt.xml file");
        }
        if (assetPathProperty.getValues().size() == 0) {
            throw new RuntimeException("No gdx.assetpath defined. Add <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> to your GWT projects gwt.xml file");
        }
        return (String)assetPathProperty.getValues().get(0);
    }

    private String getAssetOutputPath(GeneratorContext context) {
        ConfigurationProperty assetPathProperty = null;
        try {
            assetPathProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetoutputpath");
        }
        catch (BadPropertyValueException e) {
            return null;
        }
        if (assetPathProperty.getValues().size() == 0) {
            return null;
        }
        String path = (String)assetPathProperty.getValues().get(0);
        if (path != null && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private String createDummyClass(TreeLogger logger, GeneratorContext context) {
        String packageName = "com.badlogic.gdx.backends.gwt.preloader";
        String className = "PreloaderBundleImpl";
        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(packageName, className);
        composer.addImplementedInterface(packageName + ".PreloaderBundle");
        PrintWriter printWriter = context.tryCreate(logger, packageName, className);
        if (printWriter == null) {
            return packageName + "." + className;
        }
        SourceWriter sourceWriter = composer.createSourceWriter(context, printWriter);
        sourceWriter.commit(logger);
        return packageName + "." + className;
    }

    private class Asset {
        FileWrapper file;
        AssetFilter.AssetType type;

        public Asset(FileWrapper file, AssetFilter.AssetType type) {
            this.file = file;
            this.type = type;
        }
    }
}

