/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.IntBuffer;

public class Texture
implements Disposable {
    static IntBuffer buffer = BufferUtils.newIntBuffer(1);
    TextureFilter minFilter = TextureFilter.Nearest;
    TextureFilter magFilter = TextureFilter.Nearest;
    TextureWrap uWrap = TextureWrap.ClampToEdge;
    TextureWrap vWrap = TextureWrap.ClampToEdge;
    int glHandle;
    TextureData data;

    public Texture(String internalPath) {
        this(Gdx.files.internal(internalPath));
    }

    public Texture(FileHandle file) {
        this(file, null, false);
    }

    public Texture(FileHandle file, boolean useMipMaps) {
        this(file, null, useMipMaps);
    }

    public Texture(FileHandle file, Pixmap.Format format, boolean useMipMaps) {
        this.create(new FileTextureData(file, null, format, useMipMaps));
    }

    public Texture(Pixmap pixmap) {
        this((TextureData)new PixmapTextureData(pixmap, null, false, false));
    }

    public Texture(Pixmap pixmap, boolean useMipMaps) {
        this((TextureData)new PixmapTextureData(pixmap, null, useMipMaps, false));
    }

    public Texture(Pixmap pixmap, Pixmap.Format format, boolean useMipMaps) {
        this((TextureData)new PixmapTextureData(pixmap, format, useMipMaps, false));
    }

    public Texture(int width, int height, Pixmap.Format format) {
        this((TextureData)new PixmapTextureData(new Pixmap(width, height, format), null, false, true));
    }

    public Texture(TextureData data) {
        this.create(data);
    }

    private void create(TextureData data) {
        this.glHandle = Texture.createGLHandle();
        this.load(data);
    }

    public static int createGLHandle() {
        buffer.position(0);
        buffer.limit(buffer.capacity());
        Gdx.gl.glGenTextures(1, buffer);
        return buffer.get(0);
    }

    public void load(TextureData data) {
        this.data = data;
        if (data.getType() == TextureData.TextureDataType.Pixmap) {
            if (!data.isPrepared()) {
                data.prepare();
            }
            Pixmap pixmap = data.consumePixmap();
            this.uploadImageData(pixmap);
            if (data.disposePixmap()) {
                pixmap.dispose();
            }
            this.setFilter(this.minFilter, this.magFilter);
            this.setWrap(this.uWrap, this.vWrap);
            if (data.useMipMaps()) {
                Gdx.gl20.glGenerateMipmap(3553);
            }
        }
        Gdx.gl.glBindTexture(3553, 0);
    }

    private void uploadImageData(Pixmap pixmap) {
        Gdx.gl.glBindTexture(3553, this.glHandle);
        Gdx.gl.glPixelStorei(3317, 1);
        Gdx.gl.glTexImage2D(3553, 0, 6408, pixmap.getWidth(), pixmap.getHeight(), 0, 6408, 5121, pixmap.getPixels());
    }

    public void bind() {
        Gdx.gl.glBindTexture(3553, this.glHandle);
    }

    public void bind(int unit) {
        Gdx.gl.glActiveTexture(33984 + unit);
        Gdx.gl.glBindTexture(3553, this.glHandle);
    }

    public void draw(Pixmap pixmap, int x, int y) {
        if (this.data.isManaged()) {
            throw new GdxRuntimeException("can't draw to a managed texture");
        }
        Gdx.gl.glBindTexture(3553, this.glHandle);
        Gdx.gl.glTexSubImage2D(3553, 0, x, y, pixmap.getWidth(), pixmap.getHeight(), pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
    }

    public int getWidth() {
        return this.data.getWidth();
    }

    public int getHeight() {
        return this.data.getHeight();
    }

    public TextureFilter getMinFilter() {
        return this.minFilter;
    }

    public TextureFilter getMagFilter() {
        return this.magFilter;
    }

    public TextureWrap getUWrap() {
        return this.uWrap;
    }

    public TextureWrap getVWrap() {
        return this.vWrap;
    }

    public TextureData getTextureData() {
        return this.data;
    }

    public boolean isManaged() {
        return this.data.isManaged();
    }

    public int getTextureObjectHandle() {
        return this.glHandle;
    }

    public void setWrap(TextureWrap u, TextureWrap v) {
        this.uWrap = u;
        this.vWrap = v;
        this.bind();
        Gdx.gl.glTexParameterf(3553, 10242, (float)u.getGLEnum());
        Gdx.gl.glTexParameterf(3553, 10243, (float)v.getGLEnum());
    }

    public void setFilter(TextureFilter minFilter, TextureFilter magFilter) {
        this.minFilter = minFilter;
        this.magFilter = magFilter;
        this.bind();
        Gdx.gl.glTexParameterf(3553, 10241, (float)minFilter.getGLEnum());
        Gdx.gl.glTexParameterf(3553, 10240, (float)magFilter.getGLEnum());
    }

    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        buffer.clear();
        buffer.put(this.glHandle);
        buffer.flip();
        Gdx.gl.glDeleteTextures(1, buffer);
        this.glHandle = 0;
    }

    public static void setAssetManager(AssetManager manager) {
    }

    public static enum TextureWrap {
        ClampToEdge(33071),
        Repeat(10497);

        final int glEnum;

        private TextureWrap(int glEnum) {
            this.glEnum = glEnum;
        }

        public int getGLEnum() {
            return this.glEnum;
        }
    }

    public static enum TextureFilter {
        Nearest(9728),
        Linear(9729),
        MipMap(9987),
        MipMapNearestNearest(9984),
        MipMapLinearNearest(9985),
        MipMapNearestLinear(9986),
        MipMapLinearLinear(9987);

        final int glEnum;

        private TextureFilter(int glEnum) {
            this.glEnum = glEnum;
        }

        public boolean isMipMap() {
            return this.glEnum != 9728 && this.glEnum != 9729;
        }

        public int getGLEnum() {
            return this.glEnum;
        }
    }
}

