/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

public class Matrix4
implements Serializable {
    private static final long serialVersionUID = -2717655254359579617L;
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    public final float[] tmp = new float[16];
    public final float[] val = new float[16];
    static Quaternion quat = new Quaternion();
    static final Vector3 tmpV = new Vector3();
    static Vector3 l_vez = new Vector3();
    static Vector3 l_vex = new Vector3();
    static Vector3 l_vey = new Vector3();
    static final Vector3 tmpVec = new Vector3();
    static final Matrix4 tmpMat = new Matrix4();
    static Vector3 right = new Vector3();
    static Vector3 tmpForward = new Vector3();
    static Vector3 tmpUp = new Vector3();

    public Matrix4() {
        this.val[0] = 1.0f;
        this.val[5] = 1.0f;
        this.val[10] = 1.0f;
        this.val[15] = 1.0f;
    }

    public Matrix4(Matrix4 matrix) {
        this.set(matrix);
    }

    public Matrix4(float[] values) {
        this.set(values);
    }

    public Matrix4(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Matrix4 set(Matrix4 matrix) {
        return this.set(matrix.val);
    }

    public Matrix4 set(float[] values) {
        this.val[0] = values[0];
        this.val[1] = values[1];
        this.val[2] = values[2];
        this.val[3] = values[3];
        this.val[4] = values[4];
        this.val[5] = values[5];
        this.val[6] = values[6];
        this.val[7] = values[7];
        this.val[8] = values[8];
        this.val[9] = values[9];
        this.val[10] = values[10];
        this.val[11] = values[11];
        this.val[12] = values[12];
        this.val[13] = values[13];
        this.val[14] = values[14];
        this.val[15] = values[15];
        return this;
    }

    public Matrix4 set(Quaternion quaternion) {
        float l_xx = quaternion.x * quaternion.x;
        float l_xy = quaternion.x * quaternion.y;
        float l_xz = quaternion.x * quaternion.z;
        float l_xw = quaternion.x * quaternion.w;
        float l_yy = quaternion.y * quaternion.y;
        float l_yz = quaternion.y * quaternion.z;
        float l_yw = quaternion.y * quaternion.w;
        float l_zz = quaternion.z * quaternion.z;
        float l_zw = quaternion.z * quaternion.w;
        this.val[0] = 1.0f - 2.0f * (l_yy + l_zz);
        this.val[4] = 2.0f * (l_xy - l_zw);
        this.val[8] = 2.0f * (l_xz + l_yw);
        this.val[12] = 0.0f;
        this.val[1] = 2.0f * (l_xy + l_zw);
        this.val[5] = 1.0f - 2.0f * (l_xx + l_zz);
        this.val[9] = 2.0f * (l_yz - l_xw);
        this.val[13] = 0.0f;
        this.val[2] = 2.0f * (l_xz - l_yw);
        this.val[6] = 2.0f * (l_yz + l_xw);
        this.val[10] = 1.0f - 2.0f * (l_xx + l_yy);
        this.val[14] = 0.0f;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public void set(Vector3 xAxis, Vector3 yAxis, Vector3 zAxis, Vector3 pos) {
        this.val[0] = xAxis.x;
        this.val[4] = xAxis.y;
        this.val[8] = xAxis.z;
        this.val[1] = yAxis.x;
        this.val[5] = yAxis.y;
        this.val[9] = yAxis.z;
        this.val[2] = -zAxis.x;
        this.val[6] = -zAxis.y;
        this.val[10] = -zAxis.z;
        this.val[12] = pos.x;
        this.val[13] = pos.y;
        this.val[14] = pos.z;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
    }

    public Matrix4 cpy() {
        return new Matrix4(this);
    }

    public Matrix4 trn(Vector3 vector) {
        this.val[12] = this.val[12] + vector.x;
        this.val[13] = this.val[13] + vector.y;
        this.val[14] = this.val[14] + vector.z;
        return this;
    }

    public Matrix4 trn(float x, float y, float z) {
        this.val[12] = this.val[12] + x;
        this.val[13] = this.val[13] + y;
        this.val[14] = this.val[14] + z;
        return this;
    }

    public float[] getValues() {
        return this.val;
    }

    public Matrix4 mul(Matrix4 matrix) {
        this.tmp[0] = this.val[0] * matrix.val[0] + this.val[4] * matrix.val[1] + this.val[8] * matrix.val[2] + this.val[12] * matrix.val[3];
        this.tmp[4] = this.val[0] * matrix.val[4] + this.val[4] * matrix.val[5] + this.val[8] * matrix.val[6] + this.val[12] * matrix.val[7];
        this.tmp[8] = this.val[0] * matrix.val[8] + this.val[4] * matrix.val[9] + this.val[8] * matrix.val[10] + this.val[12] * matrix.val[11];
        this.tmp[12] = this.val[0] * matrix.val[12] + this.val[4] * matrix.val[13] + this.val[8] * matrix.val[14] + this.val[12] * matrix.val[15];
        this.tmp[1] = this.val[1] * matrix.val[0] + this.val[5] * matrix.val[1] + this.val[9] * matrix.val[2] + this.val[13] * matrix.val[3];
        this.tmp[5] = this.val[1] * matrix.val[4] + this.val[5] * matrix.val[5] + this.val[9] * matrix.val[6] + this.val[13] * matrix.val[7];
        this.tmp[9] = this.val[1] * matrix.val[8] + this.val[5] * matrix.val[9] + this.val[9] * matrix.val[10] + this.val[13] * matrix.val[11];
        this.tmp[13] = this.val[1] * matrix.val[12] + this.val[5] * matrix.val[13] + this.val[9] * matrix.val[14] + this.val[13] * matrix.val[15];
        this.tmp[2] = this.val[2] * matrix.val[0] + this.val[6] * matrix.val[1] + this.val[10] * matrix.val[2] + this.val[14] * matrix.val[3];
        this.tmp[6] = this.val[2] * matrix.val[4] + this.val[6] * matrix.val[5] + this.val[10] * matrix.val[6] + this.val[14] * matrix.val[7];
        this.tmp[10] = this.val[2] * matrix.val[8] + this.val[6] * matrix.val[9] + this.val[10] * matrix.val[10] + this.val[14] * matrix.val[11];
        this.tmp[14] = this.val[2] * matrix.val[12] + this.val[6] * matrix.val[13] + this.val[10] * matrix.val[14] + this.val[14] * matrix.val[15];
        this.tmp[3] = this.val[3] * matrix.val[0] + this.val[7] * matrix.val[1] + this.val[11] * matrix.val[2] + this.val[15] * matrix.val[3];
        this.tmp[7] = this.val[3] * matrix.val[4] + this.val[7] * matrix.val[5] + this.val[11] * matrix.val[6] + this.val[15] * matrix.val[7];
        this.tmp[11] = this.val[3] * matrix.val[8] + this.val[7] * matrix.val[9] + this.val[11] * matrix.val[10] + this.val[15] * matrix.val[11];
        this.tmp[15] = this.val[3] * matrix.val[12] + this.val[7] * matrix.val[13] + this.val[11] * matrix.val[14] + this.val[15] * matrix.val[15];
        return this.set(this.tmp);
    }

    public Matrix4 tra() {
        this.tmp[0] = this.val[0];
        this.tmp[4] = this.val[1];
        this.tmp[8] = this.val[2];
        this.tmp[12] = this.val[3];
        this.tmp[1] = this.val[4];
        this.tmp[5] = this.val[5];
        this.tmp[9] = this.val[6];
        this.tmp[13] = this.val[7];
        this.tmp[2] = this.val[8];
        this.tmp[6] = this.val[9];
        this.tmp[10] = this.val[10];
        this.tmp[14] = this.val[11];
        this.tmp[3] = this.val[12];
        this.tmp[7] = this.val[13];
        this.tmp[11] = this.val[14];
        this.tmp[15] = this.val[15];
        return this.set(this.tmp);
    }

    public Matrix4 idt() {
        this.val[0] = 1.0f;
        this.val[4] = 0.0f;
        this.val[8] = 0.0f;
        this.val[12] = 0.0f;
        this.val[1] = 0.0f;
        this.val[5] = 1.0f;
        this.val[9] = 0.0f;
        this.val[13] = 0.0f;
        this.val[2] = 0.0f;
        this.val[6] = 0.0f;
        this.val[10] = 1.0f;
        this.val[14] = 0.0f;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public Matrix4 inv() {
        float l_det = this.val[3] * this.val[6] * this.val[9] * this.val[12] - this.val[2] * this.val[7] * this.val[9] * this.val[12] - this.val[3] * this.val[5] * this.val[10] * this.val[12] + this.val[1] * this.val[7] * this.val[10] * this.val[12] + this.val[2] * this.val[5] * this.val[11] * this.val[12] - this.val[1] * this.val[6] * this.val[11] * this.val[12] - this.val[3] * this.val[6] * this.val[8] * this.val[13] + this.val[2] * this.val[7] * this.val[8] * this.val[13] + this.val[3] * this.val[4] * this.val[10] * this.val[13] - this.val[0] * this.val[7] * this.val[10] * this.val[13] - this.val[2] * this.val[4] * this.val[11] * this.val[13] + this.val[0] * this.val[6] * this.val[11] * this.val[13] + this.val[3] * this.val[5] * this.val[8] * this.val[14] - this.val[1] * this.val[7] * this.val[8] * this.val[14] - this.val[3] * this.val[4] * this.val[9] * this.val[14] + this.val[0] * this.val[7] * this.val[9] * this.val[14] + this.val[1] * this.val[4] * this.val[11] * this.val[14] - this.val[0] * this.val[5] * this.val[11] * this.val[14] - this.val[2] * this.val[5] * this.val[8] * this.val[15] + this.val[1] * this.val[6] * this.val[8] * this.val[15] + this.val[2] * this.val[4] * this.val[9] * this.val[15] - this.val[0] * this.val[6] * this.val[9] * this.val[15] - this.val[1] * this.val[4] * this.val[10] * this.val[15] + this.val[0] * this.val[5] * this.val[10] * this.val[15];
        if (l_det == 0.0f) {
            throw new RuntimeException("non-invertible matrix");
        }
        float inv_det = 1.0f / l_det;
        this.tmp[0] = this.val[9] * this.val[14] * this.val[7] - this.val[13] * this.val[10] * this.val[7] + this.val[13] * this.val[6] * this.val[11] - this.val[5] * this.val[14] * this.val[11] - this.val[9] * this.val[6] * this.val[15] + this.val[5] * this.val[10] * this.val[15];
        this.tmp[4] = this.val[12] * this.val[10] * this.val[7] - this.val[8] * this.val[14] * this.val[7] - this.val[12] * this.val[6] * this.val[11] + this.val[4] * this.val[14] * this.val[11] + this.val[8] * this.val[6] * this.val[15] - this.val[4] * this.val[10] * this.val[15];
        this.tmp[8] = this.val[8] * this.val[13] * this.val[7] - this.val[12] * this.val[9] * this.val[7] + this.val[12] * this.val[5] * this.val[11] - this.val[4] * this.val[13] * this.val[11] - this.val[8] * this.val[5] * this.val[15] + this.val[4] * this.val[9] * this.val[15];
        this.tmp[12] = this.val[12] * this.val[9] * this.val[6] - this.val[8] * this.val[13] * this.val[6] - this.val[12] * this.val[5] * this.val[10] + this.val[4] * this.val[13] * this.val[10] + this.val[8] * this.val[5] * this.val[14] - this.val[4] * this.val[9] * this.val[14];
        this.tmp[1] = this.val[13] * this.val[10] * this.val[3] - this.val[9] * this.val[14] * this.val[3] - this.val[13] * this.val[2] * this.val[11] + this.val[1] * this.val[14] * this.val[11] + this.val[9] * this.val[2] * this.val[15] - this.val[1] * this.val[10] * this.val[15];
        this.tmp[5] = this.val[8] * this.val[14] * this.val[3] - this.val[12] * this.val[10] * this.val[3] + this.val[12] * this.val[2] * this.val[11] - this.val[0] * this.val[14] * this.val[11] - this.val[8] * this.val[2] * this.val[15] + this.val[0] * this.val[10] * this.val[15];
        this.tmp[9] = this.val[12] * this.val[9] * this.val[3] - this.val[8] * this.val[13] * this.val[3] - this.val[12] * this.val[1] * this.val[11] + this.val[0] * this.val[13] * this.val[11] + this.val[8] * this.val[1] * this.val[15] - this.val[0] * this.val[9] * this.val[15];
        this.tmp[13] = this.val[8] * this.val[13] * this.val[2] - this.val[12] * this.val[9] * this.val[2] + this.val[12] * this.val[1] * this.val[10] - this.val[0] * this.val[13] * this.val[10] - this.val[8] * this.val[1] * this.val[14] + this.val[0] * this.val[9] * this.val[14];
        this.tmp[2] = this.val[5] * this.val[14] * this.val[3] - this.val[13] * this.val[6] * this.val[3] + this.val[13] * this.val[2] * this.val[7] - this.val[1] * this.val[14] * this.val[7] - this.val[5] * this.val[2] * this.val[15] + this.val[1] * this.val[6] * this.val[15];
        this.tmp[6] = this.val[12] * this.val[6] * this.val[3] - this.val[4] * this.val[14] * this.val[3] - this.val[12] * this.val[2] * this.val[7] + this.val[0] * this.val[14] * this.val[7] + this.val[4] * this.val[2] * this.val[15] - this.val[0] * this.val[6] * this.val[15];
        this.tmp[10] = this.val[4] * this.val[13] * this.val[3] - this.val[12] * this.val[5] * this.val[3] + this.val[12] * this.val[1] * this.val[7] - this.val[0] * this.val[13] * this.val[7] - this.val[4] * this.val[1] * this.val[15] + this.val[0] * this.val[5] * this.val[15];
        this.tmp[14] = this.val[12] * this.val[5] * this.val[2] - this.val[4] * this.val[13] * this.val[2] - this.val[12] * this.val[1] * this.val[6] + this.val[0] * this.val[13] * this.val[6] + this.val[4] * this.val[1] * this.val[14] - this.val[0] * this.val[5] * this.val[14];
        this.tmp[3] = this.val[9] * this.val[6] * this.val[3] - this.val[5] * this.val[10] * this.val[3] - this.val[9] * this.val[2] * this.val[7] + this.val[1] * this.val[10] * this.val[7] + this.val[5] * this.val[2] * this.val[11] - this.val[1] * this.val[6] * this.val[11];
        this.tmp[7] = this.val[4] * this.val[10] * this.val[3] - this.val[8] * this.val[6] * this.val[3] + this.val[8] * this.val[2] * this.val[7] - this.val[0] * this.val[10] * this.val[7] - this.val[4] * this.val[2] * this.val[11] + this.val[0] * this.val[6] * this.val[11];
        this.tmp[11] = this.val[8] * this.val[5] * this.val[3] - this.val[4] * this.val[9] * this.val[3] - this.val[8] * this.val[1] * this.val[7] + this.val[0] * this.val[9] * this.val[7] + this.val[4] * this.val[1] * this.val[11] - this.val[0] * this.val[5] * this.val[11];
        this.tmp[15] = this.val[4] * this.val[9] * this.val[2] - this.val[8] * this.val[5] * this.val[2] + this.val[8] * this.val[1] * this.val[6] - this.val[0] * this.val[9] * this.val[6] - this.val[4] * this.val[1] * this.val[10] + this.val[0] * this.val[5] * this.val[10];
        this.val[0] = this.tmp[0] * inv_det;
        this.val[4] = this.tmp[4] * inv_det;
        this.val[8] = this.tmp[8] * inv_det;
        this.val[12] = this.tmp[12] * inv_det;
        this.val[1] = this.tmp[1] * inv_det;
        this.val[5] = this.tmp[5] * inv_det;
        this.val[9] = this.tmp[9] * inv_det;
        this.val[13] = this.tmp[13] * inv_det;
        this.val[2] = this.tmp[2] * inv_det;
        this.val[6] = this.tmp[6] * inv_det;
        this.val[10] = this.tmp[10] * inv_det;
        this.val[14] = this.tmp[14] * inv_det;
        this.val[3] = this.tmp[3] * inv_det;
        this.val[7] = this.tmp[7] * inv_det;
        this.val[11] = this.tmp[11] * inv_det;
        this.val[15] = this.tmp[15] * inv_det;
        return this;
    }

    public float det() {
        return this.val[3] * this.val[6] * this.val[9] * this.val[12] - this.val[2] * this.val[7] * this.val[9] * this.val[12] - this.val[3] * this.val[5] * this.val[10] * this.val[12] + this.val[1] * this.val[7] * this.val[10] * this.val[12] + this.val[2] * this.val[5] * this.val[11] * this.val[12] - this.val[1] * this.val[6] * this.val[11] * this.val[12] - this.val[3] * this.val[6] * this.val[8] * this.val[13] + this.val[2] * this.val[7] * this.val[8] * this.val[13] + this.val[3] * this.val[4] * this.val[10] * this.val[13] - this.val[0] * this.val[7] * this.val[10] * this.val[13] - this.val[2] * this.val[4] * this.val[11] * this.val[13] + this.val[0] * this.val[6] * this.val[11] * this.val[13] + this.val[3] * this.val[5] * this.val[8] * this.val[14] - this.val[1] * this.val[7] * this.val[8] * this.val[14] - this.val[3] * this.val[4] * this.val[9] * this.val[14] + this.val[0] * this.val[7] * this.val[9] * this.val[14] + this.val[1] * this.val[4] * this.val[11] * this.val[14] - this.val[0] * this.val[5] * this.val[11] * this.val[14] - this.val[2] * this.val[5] * this.val[8] * this.val[15] + this.val[1] * this.val[6] * this.val[8] * this.val[15] + this.val[2] * this.val[4] * this.val[9] * this.val[15] - this.val[0] * this.val[6] * this.val[9] * this.val[15] - this.val[1] * this.val[4] * this.val[10] * this.val[15] + this.val[0] * this.val[5] * this.val[10] * this.val[15];
    }

    public Matrix4 setToProjection(float near, float far, float fov, float aspectRatio) {
        this.idt();
        float l_fd = (float)(1.0 / Math.tan((double)fov * (Math.PI / 180) / 2.0));
        float l_a1 = (far + near) / (near - far);
        float l_a2 = 2.0f * far * near / (near - far);
        this.val[0] = l_fd / aspectRatio;
        this.val[1] = 0.0f;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = 0.0f;
        this.val[5] = l_fd;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = l_a1;
        this.val[11] = -1.0f;
        this.val[12] = 0.0f;
        this.val[13] = 0.0f;
        this.val[14] = l_a2;
        this.val[15] = 0.0f;
        return this;
    }

    public Matrix4 setToOrtho2D(float x, float y, float width, float height) {
        this.setToOrtho(x, x + width, y, y + height, 0.0f, 1.0f);
        return this;
    }

    public Matrix4 setToOrtho2D(float x, float y, float width, float height, float near, float far) {
        this.setToOrtho(x, x + width, y, y + height, near, far);
        return this;
    }

    public Matrix4 setToOrtho(float left, float right, float bottom, float top, float near, float far) {
        this.idt();
        float x_orth = 2.0f / (right - left);
        float y_orth = 2.0f / (top - bottom);
        float z_orth = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        this.val[0] = x_orth;
        this.val[1] = 0.0f;
        this.val[2] = 0.0f;
        this.val[3] = 0.0f;
        this.val[4] = 0.0f;
        this.val[5] = y_orth;
        this.val[6] = 0.0f;
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = z_orth;
        this.val[11] = 0.0f;
        this.val[12] = tx;
        this.val[13] = ty;
        this.val[14] = tz;
        this.val[15] = 1.0f;
        return this;
    }

    public Matrix4 setToTranslation(Vector3 vector) {
        this.idt();
        this.val[12] = vector.x;
        this.val[13] = vector.y;
        this.val[14] = vector.z;
        return this;
    }

    public Matrix4 setToTranslation(float x, float y, float z) {
        this.idt();
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
        return this;
    }

    public Matrix4 setToTranslationAndScaling(Vector3 translation, Vector3 scaling) {
        this.idt();
        this.val[12] = translation.x;
        this.val[13] = translation.y;
        this.val[14] = translation.z;
        this.val[0] = scaling.x;
        this.val[5] = scaling.y;
        this.val[10] = scaling.z;
        return this;
    }

    public Matrix4 setToTranslationAndScaling(float translationX, float translationY, float translationZ, float scalingX, float scalingY, float scalingZ) {
        this.idt();
        this.val[12] = translationX;
        this.val[13] = translationY;
        this.val[14] = translationZ;
        this.val[0] = scalingX;
        this.val[5] = scalingY;
        this.val[10] = scalingZ;
        return this;
    }

    public Matrix4 setToRotation(Vector3 axis, float angle) {
        this.idt();
        if (angle == 0.0f) {
            return this;
        }
        return this.set(quat.set(axis, angle));
    }

    public Matrix4 setToRotation(float axisX, float axisY, float axisZ, float angle) {
        this.idt();
        if (angle == 0.0f) {
            return this;
        }
        return this.set(quat.set(tmpV.set(axisX, axisY, axisZ), angle));
    }

    public Matrix4 setFromEulerAngles(float yaw, float pitch, float roll) {
        this.idt();
        quat.setEulerAngles(yaw, pitch, roll);
        return this.set(quat);
    }

    public Matrix4 setToScaling(Vector3 vector) {
        this.idt();
        this.val[0] = vector.x;
        this.val[5] = vector.y;
        this.val[10] = vector.z;
        return this;
    }

    public Matrix4 setToScaling(float x, float y, float z) {
        this.idt();
        this.val[0] = x;
        this.val[5] = y;
        this.val[10] = z;
        return this;
    }

    public Matrix4 setToLookAt(Vector3 direction, Vector3 up) {
        l_vez.set(direction).nor();
        l_vex.set(direction).nor();
        l_vex.crs(up).nor();
        l_vey.set(l_vex).crs(l_vez).nor();
        this.idt();
        this.val[0] = Matrix4.l_vex.x;
        this.val[4] = Matrix4.l_vex.y;
        this.val[8] = Matrix4.l_vex.z;
        this.val[1] = Matrix4.l_vey.x;
        this.val[5] = Matrix4.l_vey.y;
        this.val[9] = Matrix4.l_vey.z;
        this.val[2] = -Matrix4.l_vez.x;
        this.val[6] = -Matrix4.l_vez.y;
        this.val[10] = -Matrix4.l_vez.z;
        return this;
    }

    public Matrix4 setToLookAt(Vector3 position, Vector3 target, Vector3 up) {
        tmpVec.set(target).sub(position);
        this.setToLookAt(tmpVec, up);
        this.mul(tmpMat.setToTranslation(position.tmp().mul(-1.0f)));
        return this;
    }

    public Matrix4 setToWorld(Vector3 position, Vector3 forward, Vector3 up) {
        tmpForward.set(forward).nor();
        right.set(tmpForward).crs(up).nor();
        tmpUp.set(right).crs(tmpForward).nor();
        this.set(right, tmpUp, tmpForward, position);
        return this;
    }

    public String toString() {
        return "[" + this.val[0] + "|" + this.val[4] + "|" + this.val[8] + "|" + this.val[12] + "]\n" + "[" + this.val[1] + "|" + this.val[5] + "|" + this.val[9] + "|" + this.val[13] + "]\n" + "[" + this.val[2] + "|" + this.val[6] + "|" + this.val[10] + "|" + this.val[14] + "]\n" + "[" + this.val[3] + "|" + this.val[7] + "|" + this.val[11] + "|" + this.val[15] + "]\n";
    }

    public void lerp(Matrix4 matrix, float alpha) {
        for (int i = 0; i < 16; ++i) {
            this.val[i] = this.val[i] * (1.0f - alpha) + matrix.val[i] * alpha;
        }
    }

    public Matrix4 set(Matrix3 mat) {
        this.val[0] = mat.val[0];
        this.val[1] = mat.val[1];
        this.val[2] = mat.val[2];
        this.val[3] = 0.0f;
        this.val[4] = mat.val[3];
        this.val[5] = mat.val[4];
        this.val[6] = mat.val[5];
        this.val[7] = 0.0f;
        this.val[8] = 0.0f;
        this.val[9] = 0.0f;
        this.val[10] = 1.0f;
        this.val[11] = 0.0f;
        this.val[12] = mat.val[6];
        this.val[13] = mat.val[7];
        this.val[14] = 0.0f;
        this.val[15] = mat.val[8];
        return this;
    }

    public Matrix4 scl(Vector3 scale) {
        this.val[0] = this.val[0] * scale.x;
        this.val[5] = this.val[5] * scale.y;
        this.val[10] = this.val[10] * scale.z;
        return this;
    }

    public Matrix4 scl(float x, float y, float z) {
        this.val[0] = this.val[0] * x;
        this.val[5] = this.val[5] * y;
        this.val[10] = this.val[10] * z;
        return this;
    }

    public Matrix4 scl(float scale) {
        this.val[0] = this.val[0] * scale;
        this.val[5] = this.val[5] * scale;
        this.val[10] = this.val[10] * scale;
        return this;
    }

    public void getTranslation(Vector3 position) {
        position.x = this.val[12];
        position.y = this.val[13];
        position.z = this.val[14];
    }

    public void getRotation(Quaternion rotation) {
        rotation.setFromMatrix(this);
    }

    public Matrix4 toNormalMatrix() {
        this.val[12] = 0.0f;
        this.val[13] = 0.0f;
        this.val[14] = 0.0f;
        this.inv();
        return this.tra();
    }

    static void matrix4_mul(float[] mata, float[] matb) {
        float[] tmp = new float[16];
        tmp[0] = mata[0] * matb[0] + mata[4] * matb[1] + mata[8] * matb[2] + mata[12] * matb[3];
        tmp[4] = mata[0] * matb[4] + mata[4] * matb[5] + mata[8] * matb[6] + mata[12] * matb[7];
        tmp[8] = mata[0] * matb[8] + mata[4] * matb[9] + mata[8] * matb[10] + mata[12] * matb[11];
        tmp[12] = mata[0] * matb[12] + mata[4] * matb[13] + mata[8] * matb[14] + mata[12] * matb[15];
        tmp[1] = mata[1] * matb[0] + mata[5] * matb[1] + mata[9] * matb[2] + mata[13] * matb[3];
        tmp[5] = mata[1] * matb[4] + mata[5] * matb[5] + mata[9] * matb[6] + mata[13] * matb[7];
        tmp[9] = mata[1] * matb[8] + mata[5] * matb[9] + mata[9] * matb[10] + mata[13] * matb[11];
        tmp[13] = mata[1] * matb[12] + mata[5] * matb[13] + mata[9] * matb[14] + mata[13] * matb[15];
        tmp[2] = mata[2] * matb[0] + mata[6] * matb[1] + mata[10] * matb[2] + mata[14] * matb[3];
        tmp[6] = mata[2] * matb[4] + mata[6] * matb[5] + mata[10] * matb[6] + mata[14] * matb[7];
        tmp[10] = mata[2] * matb[8] + mata[6] * matb[9] + mata[10] * matb[10] + mata[14] * matb[11];
        tmp[14] = mata[2] * matb[12] + mata[6] * matb[13] + mata[10] * matb[14] + mata[14] * matb[15];
        tmp[3] = mata[3] * matb[0] + mata[7] * matb[1] + mata[11] * matb[2] + mata[15] * matb[3];
        tmp[7] = mata[3] * matb[4] + mata[7] * matb[5] + mata[11] * matb[6] + mata[15] * matb[7];
        tmp[11] = mata[3] * matb[8] + mata[7] * matb[9] + mata[11] * matb[10] + mata[15] * matb[11];
        tmp[15] = mata[3] * matb[12] + mata[7] * matb[13] + mata[11] * matb[14] + mata[15] * matb[15];
        System.arraycopy(tmp, 0, mata, 0, 16);
    }

    static float matrix4_det(float[] val) {
        return val[3] * val[6] * val[9] * val[12] - val[2] * val[7] * val[9] * val[12] - val[3] * val[5] * val[10] * val[12] + val[1] * val[7] * val[10] * val[12] + val[2] * val[5] * val[11] * val[12] - val[1] * val[6] * val[11] * val[12] - val[3] * val[6] * val[8] * val[13] + val[2] * val[7] * val[8] * val[13] + val[3] * val[4] * val[10] * val[13] - val[0] * val[7] * val[10] * val[13] - val[2] * val[4] * val[11] * val[13] + val[0] * val[6] * val[11] * val[13] + val[3] * val[5] * val[8] * val[14] - val[1] * val[7] * val[8] * val[14] - val[3] * val[4] * val[9] * val[14] + val[0] * val[7] * val[9] * val[14] + val[1] * val[4] * val[11] * val[14] - val[0] * val[5] * val[11] * val[14] - val[2] * val[5] * val[8] * val[15] + val[1] * val[6] * val[8] * val[15] + val[2] * val[4] * val[9] * val[15] - val[0] * val[6] * val[9] * val[15] - val[1] * val[4] * val[10] * val[15] + val[0] * val[5] * val[10] * val[15];
    }

    static boolean matrix4_inv(float[] val) {
        float[] tmp = new float[16];
        float l_det = Matrix4.matrix4_det(val);
        if (l_det == 0.0f) {
            return false;
        }
        tmp[0] = val[9] * val[14] * val[7] - val[13] * val[10] * val[7] + val[13] * val[6] * val[11] - val[5] * val[14] * val[11] - val[9] * val[6] * val[15] + val[5] * val[10] * val[15];
        tmp[4] = val[12] * val[10] * val[7] - val[8] * val[14] * val[7] - val[12] * val[6] * val[11] + val[4] * val[14] * val[11] + val[8] * val[6] * val[15] - val[4] * val[10] * val[15];
        tmp[8] = val[8] * val[13] * val[7] - val[12] * val[9] * val[7] + val[12] * val[5] * val[11] - val[4] * val[13] * val[11] - val[8] * val[5] * val[15] + val[4] * val[9] * val[15];
        tmp[12] = val[12] * val[9] * val[6] - val[8] * val[13] * val[6] - val[12] * val[5] * val[10] + val[4] * val[13] * val[10] + val[8] * val[5] * val[14] - val[4] * val[9] * val[14];
        tmp[1] = val[13] * val[10] * val[3] - val[9] * val[14] * val[3] - val[13] * val[2] * val[11] + val[1] * val[14] * val[11] + val[9] * val[2] * val[15] - val[1] * val[10] * val[15];
        tmp[5] = val[8] * val[14] * val[3] - val[12] * val[10] * val[3] + val[12] * val[2] * val[11] - val[0] * val[14] * val[11] - val[8] * val[2] * val[15] + val[0] * val[10] * val[15];
        tmp[9] = val[12] * val[9] * val[3] - val[8] * val[13] * val[3] - val[12] * val[1] * val[11] + val[0] * val[13] * val[11] + val[8] * val[1] * val[15] - val[0] * val[9] * val[15];
        tmp[13] = val[8] * val[13] * val[2] - val[12] * val[9] * val[2] + val[12] * val[1] * val[10] - val[0] * val[13] * val[10] - val[8] * val[1] * val[14] + val[0] * val[9] * val[14];
        tmp[2] = val[5] * val[14] * val[3] - val[13] * val[6] * val[3] + val[13] * val[2] * val[7] - val[1] * val[14] * val[7] - val[5] * val[2] * val[15] + val[1] * val[6] * val[15];
        tmp[6] = val[12] * val[6] * val[3] - val[4] * val[14] * val[3] - val[12] * val[2] * val[7] + val[0] * val[14] * val[7] + val[4] * val[2] * val[15] - val[0] * val[6] * val[15];
        tmp[10] = val[4] * val[13] * val[3] - val[12] * val[5] * val[3] + val[12] * val[1] * val[7] - val[0] * val[13] * val[7] - val[4] * val[1] * val[15] + val[0] * val[5] * val[15];
        tmp[14] = val[12] * val[5] * val[2] - val[4] * val[13] * val[2] - val[12] * val[1] * val[6] + val[0] * val[13] * val[6] + val[4] * val[1] * val[14] - val[0] * val[5] * val[14];
        tmp[3] = val[9] * val[6] * val[3] - val[5] * val[10] * val[3] - val[9] * val[2] * val[7] + val[1] * val[10] * val[7] + val[5] * val[2] * val[11] - val[1] * val[6] * val[11];
        tmp[7] = val[4] * val[10] * val[3] - val[8] * val[6] * val[3] + val[8] * val[2] * val[7] - val[0] * val[10] * val[7] - val[4] * val[2] * val[11] + val[0] * val[6] * val[11];
        tmp[11] = val[8] * val[5] * val[3] - val[4] * val[9] * val[3] - val[8] * val[1] * val[7] + val[0] * val[9] * val[7] + val[4] * val[1] * val[11] - val[0] * val[5] * val[11];
        tmp[15] = val[4] * val[9] * val[2] - val[8] * val[5] * val[2] + val[8] * val[1] * val[6] - val[0] * val[9] * val[6] - val[4] * val[1] * val[10] + val[0] * val[5] * val[10];
        float inv_det = 1.0f / l_det;
        val[0] = tmp[0] * inv_det;
        val[4] = tmp[4] * inv_det;
        val[8] = tmp[8] * inv_det;
        val[12] = tmp[12] * inv_det;
        val[1] = tmp[1] * inv_det;
        val[5] = tmp[5] * inv_det;
        val[9] = tmp[9] * inv_det;
        val[13] = tmp[13] * inv_det;
        val[2] = tmp[2] * inv_det;
        val[6] = tmp[6] * inv_det;
        val[10] = tmp[10] * inv_det;
        val[14] = tmp[14] * inv_det;
        val[3] = tmp[3] * inv_det;
        val[7] = tmp[7] * inv_det;
        val[11] = tmp[11] * inv_det;
        val[15] = tmp[15] * inv_det;
        return true;
    }

    static void matrix4_mulVec(float[] mat, float[] vec, int offset) {
        float x = vec[offset + 0] * mat[0] + vec[offset + 1] * mat[4] + vec[offset + 2] * mat[8] + mat[12];
        float y = vec[offset + 0] * mat[1] + vec[offset + 1] * mat[5] + vec[offset + 2] * mat[9] + mat[13];
        float z = vec[offset + 0] * mat[2] + vec[offset + 1] * mat[6] + vec[offset + 2] * mat[10] + mat[14];
        vec[offset + 0] = x;
        vec[offset + 1] = y;
        vec[offset + 2] = z;
    }

    static void matrix4_proj(float[] mat, float[] vec, int offset) {
        float inv_w = 1.0f / (vec[offset + 0] * mat[3] + vec[offset + 1] * mat[7] + vec[offset + 2] * mat[11] + mat[15]);
        float x = (vec[offset + 0] * mat[0] + vec[offset + 1] * mat[4] + vec[offset + 2] * mat[8] + mat[12]) * inv_w;
        float y = (vec[offset + 0] * mat[1] + vec[offset + 1] * mat[5] + vec[offset + 2] * mat[9] + mat[13]) * inv_w;
        float z = (vec[offset + 0] * mat[2] + vec[offset + 1] * mat[6] + vec[offset + 2] * mat[10] + mat[14]) * inv_w;
        vec[offset + 0] = x;
        vec[offset + 1] = y;
        vec[offset + 2] = z;
    }

    static void matrix4_rot(float[] mat, float[] vec, int offset) {
        float x = vec[offset + 0] * mat[0] + vec[offset + 1] * mat[4] + vec[offset + 2] * mat[8];
        float y = vec[offset + 0] * mat[1] + vec[offset + 1] * mat[5] + vec[offset + 2] * mat[9];
        float z = vec[offset + 0] * mat[2] + vec[offset + 1] * mat[6] + vec[offset + 2] * mat[10];
        vec[offset + 0] = x;
        vec[offset + 1] = y;
        vec[offset + 2] = z;
    }

    public static void mul(float[] mata, float[] matb) {
        Matrix4.matrix4_mul(mata, matb);
    }

    public static void mulVec(float[] mat, float[] vec) {
        Matrix4.matrix4_mulVec(mat, vec, 0);
    }

    public static void mulVec(float[] mat, float[] vecs, int offset, int numVecs, int stride) {
        for (int i = 0; i < numVecs; ++i) {
            Matrix4.matrix4_mulVec(mat, vecs, offset);
            offset += stride;
        }
    }

    public static void prj(float[] mat, float[] vec) {
        Matrix4.matrix4_proj(mat, vec, 0);
    }

    public static void prj(float[] mat, float[] vecs, int offset, int numVecs, int stride) {
        for (int i = 0; i < numVecs; ++i) {
            Matrix4.matrix4_proj(mat, vecs, offset);
            offset += stride;
        }
    }

    public static void rot(float[] mat, float[] vec) {
        Matrix4.matrix4_rot(mat, vec, 0);
    }

    public static void rot(float[] mat, float[] vecs, int offset, int numVecs, int stride) {
        for (int i = 0; i < numVecs; ++i) {
            Matrix4.matrix4_rot(mat, vecs, offset);
            offset += stride;
        }
    }

    public static boolean inv(float[] values) {
        return Matrix4.matrix4_inv(values);
    }

    public static float det(float[] values) {
        return Matrix4.matrix4_det(values);
    }

    public Matrix4 translate(Vector3 translation) {
        return this.translate(translation.x, translation.y, translation.z);
    }

    public Matrix4 translate(float x, float y, float z) {
        this.tmp[0] = 1.0f;
        this.tmp[4] = 0.0f;
        this.tmp[8] = 0.0f;
        this.tmp[12] = x;
        this.tmp[1] = 0.0f;
        this.tmp[5] = 1.0f;
        this.tmp[9] = 0.0f;
        this.tmp[13] = y;
        this.tmp[2] = 0.0f;
        this.tmp[6] = 0.0f;
        this.tmp[10] = 1.0f;
        this.tmp[14] = z;
        this.tmp[3] = 0.0f;
        this.tmp[7] = 0.0f;
        this.tmp[11] = 0.0f;
        this.tmp[15] = 1.0f;
        Matrix4.mul(this.val, this.tmp);
        return this;
    }

    public Matrix4 rotate(Vector3 axis, float angle) {
        if (angle == 0.0f) {
            return this;
        }
        quat.set(axis, angle);
        return this.rotate(quat);
    }

    public Matrix4 rotate(float axisX, float axisY, float axisZ, float angle) {
        if (angle == 0.0f) {
            return this;
        }
        quat.set(tmpV.set(axisX, axisY, axisZ), angle);
        return this.rotate(quat);
    }

    public Matrix4 rotate(Quaternion rotation) {
        rotation.toMatrix(this.tmp);
        Matrix4.mul(this.val, this.tmp);
        return this;
    }

    public Matrix4 scale(float scaleX, float scaleY, float scaleZ) {
        this.tmp[0] = scaleX;
        this.tmp[4] = 0.0f;
        this.tmp[8] = 0.0f;
        this.tmp[12] = 0.0f;
        this.tmp[1] = 0.0f;
        this.tmp[5] = scaleY;
        this.tmp[9] = 0.0f;
        this.tmp[13] = 0.0f;
        this.tmp[2] = 0.0f;
        this.tmp[6] = 0.0f;
        this.tmp[10] = scaleZ;
        this.tmp[14] = 0.0f;
        this.tmp[3] = 0.0f;
        this.tmp[7] = 0.0f;
        this.tmp[11] = 0.0f;
        this.tmp[15] = 1.0f;
        Matrix4.mul(this.val, this.tmp);
        return this;
    }
}

