/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import org.jbox2d.collision.Manifold;

public class Manifold {
    org.jbox2d.collision.Manifold manifold;
    final ManifoldPoint[] points = new ManifoldPoint[]{new ManifoldPoint(), new ManifoldPoint()};
    final Vector2 localNormal = new Vector2();
    final Vector2 localPoint = new Vector2();
    final int[] tmpInt = new int[2];
    final float[] tmpFloat = new float[4];

    Manifold() {
    }

    protected Manifold(org.jbox2d.collision.Manifold manifold) {
        this.manifold = manifold;
    }

    public ManifoldType getType() {
        Manifold.ManifoldType type = this.manifold.type;
        if (type == Manifold.ManifoldType.CIRCLES) {
            return ManifoldType.Circle;
        }
        if (type == Manifold.ManifoldType.FACE_A) {
            return ManifoldType.FaceA;
        }
        if (type == Manifold.ManifoldType.FACE_B) {
            return ManifoldType.FaceB;
        }
        return ManifoldType.Circle;
    }

    public int getPointCount() {
        return this.manifold.pointCount;
    }

    public Vector2 getLocalNormal() {
        return this.localNormal.set(this.manifold.localNormal.x, this.manifold.localNormal.y);
    }

    public Vector2 getLocalPoint() {
        return this.localPoint.set(this.manifold.localPoint.x, this.manifold.localPoint.y);
    }

    public ManifoldPoint[] getPoints() {
        for (int i = 0; i < this.manifold.points.length; ++i) {
            this.points[i].contactID = this.manifold.points[i].id.getKey();
            this.points[i].localPoint.set(this.manifold.points[i].localPoint.x, this.manifold.points[i].localPoint.y);
            this.points[i].normalImpulse = this.manifold.points[i].normalImpulse;
            this.points[i].tangentImpulse = this.manifold.points[i].tangentImpulse;
        }
        return this.points;
    }

    public static enum ManifoldType {
        Circle,
        FaceA,
        FaceB;

    }

    public class ManifoldPoint {
        public final Vector2 localPoint = new Vector2();
        public float normalImpulse;
        public float tangentImpulse;
        public int contactID = 0;
    }
}

