/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d.joints;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.JointDef;
import org.jbox2d.dynamics.joints.JointType;

public class PulleyJointDef
extends JointDef {
    private static final float minPulleyLength = 2.0f;
    public final Vector2 groundAnchorA = new Vector2(-1.0f, 1.0f);
    public final Vector2 groundAnchorB = new Vector2(1.0f, 1.0f);
    public final Vector2 localAnchorA = new Vector2(-1.0f, 0.0f);
    public final Vector2 localAnchorB = new Vector2(1.0f, 0.0f);
    public float lengthA = 0.0f;
    public float lengthB = 0.0f;
    public float ratio = 1.0f;

    public PulleyJointDef() {
        this.type = JointDef.JointType.PulleyJoint;
        this.collideConnected = true;
    }

    public void initialize(Body bodyA, Body bodyB, Vector2 groundAnchorA, Vector2 groundAnchorB, Vector2 anchorA, Vector2 anchorB, float ratio) {
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.groundAnchorA.set(groundAnchorA);
        this.groundAnchorB.set(groundAnchorB);
        this.localAnchorA.set(bodyA.getLocalPoint(anchorA));
        this.localAnchorB.set(bodyB.getLocalPoint(anchorB));
        this.lengthA = anchorA.dst(groundAnchorA);
        this.lengthB = anchorB.dst(groundAnchorB);
        this.ratio = ratio;
        float C2 = this.lengthA + ratio * this.lengthB;
    }

    @Override
    public org.jbox2d.dynamics.joints.JointDef toJBox2d() {
        org.jbox2d.dynamics.joints.PulleyJointDef jd = new org.jbox2d.dynamics.joints.PulleyJointDef();
        jd.bodyA = this.bodyA.body;
        jd.bodyB = this.bodyB.body;
        jd.collideConnected = this.collideConnected;
        jd.groundAnchorA.set(this.groundAnchorA.x, this.groundAnchorB.y);
        jd.groundAnchorB.set(this.groundAnchorB.x, this.groundAnchorB.y);
        jd.lengthA = this.lengthA;
        jd.lengthB = this.lengthB;
        jd.localAnchorA.set(this.localAnchorA.x, this.localAnchorA.y);
        jd.localAnchorB.set(this.localAnchorB.x, this.localAnchorB.y);
        jd.ratio = this.ratio;
        jd.type = JointType.PULLEY;
        return jd;
    }
}

