/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TableLayout;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gwtref.client.Method;
import com.badlogic.gwtref.client.ReflectionCache;
import com.esotericsoftware.tablelayout.BaseTableLayout;
import com.esotericsoftware.tablelayout.Toolkit;

class TableToolkit
extends Toolkit<Actor, Table, TableLayout> {
    static boolean drawDebug;

    TableToolkit() {
    }

    public void addChild(Actor parent, Actor child) {
        child.remove();
        try {
            Method method = ReflectionCache.getType(parent.getClass()).getMethod("setWidget", Actor.class);
            method.invoke(parent, child);
            return;
        }
        catch (Exception ignored) {
            Gdx.app.log("TableToolkit", "Couldn't call setWidget", ignored);
            ((Group)parent).addActor(child);
            return;
        }
    }

    public void removeChild(Actor parent, Actor child) {
        ((Group)parent).removeActor(child);
    }

    public float getMinWidth(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)actor).getMinWidth();
        }
        return actor.getWidth();
    }

    public float getMinHeight(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)actor).getMinHeight();
        }
        return actor.getHeight();
    }

    public float getPrefWidth(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)actor).getPrefWidth();
        }
        return actor.getWidth();
    }

    public float getPrefHeight(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)actor).getPrefHeight();
        }
        return actor.getHeight();
    }

    public float getMaxWidth(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)actor).getMaxWidth();
        }
        return 0.0f;
    }

    public float getMaxHeight(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)actor).getMaxHeight();
        }
        return 0.0f;
    }

    public float getWidth(Actor widget) {
        return widget.getWidth();
    }

    public float getHeight(Actor widget) {
        return widget.getHeight();
    }

    public void clearDebugRectangles(TableLayout layout) {
        if (layout.debugRects != null) {
            layout.debugRects.clear();
        }
    }

    public void addDebugRectangle(TableLayout layout, BaseTableLayout.Debug type, float x, float y, float w, float h) {
        drawDebug = true;
        if (layout.debugRects == null) {
            layout.debugRects = new Array();
        }
        layout.debugRects.add(new DebugRect(type, x, ((Table)layout.getTable()).getHeight() - y, w, h));
    }

    static class DebugRect
    extends Rectangle {
        final BaseTableLayout.Debug type;

        public DebugRect(BaseTableLayout.Debug type, float x, float y, float width, float height) {
            super(x, y, width, height);
            this.type = type;
        }
    }
}

