/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.client.GWT;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferUtils {
    public static void copy(float[] src, Buffer dst, int numFloats, int offset) {
        FloatBuffer floatBuffer = null;
        if (dst instanceof ByteBuffer) {
            floatBuffer = ((ByteBuffer)dst).asFloatBuffer();
        } else if (dst instanceof FloatBuffer) {
            floatBuffer = (FloatBuffer)dst;
        } else {
            throw new GdxRuntimeException("dst must be a ByteBuffer or FloatBuffer");
        }
        floatBuffer.clear();
        dst.position(0);
        floatBuffer.put(src, offset, numFloats);
        dst.position(0);
        if (dst instanceof ByteBuffer) {
            dst.limit(numFloats << 2);
        } else {
            dst.limit(numFloats);
        }
    }

    public static void copy(byte[] src, int srcOffset, Buffer dst, int numElements) {
        if (!(dst instanceof ByteBuffer)) {
            throw new GdxRuntimeException("dst must be a ByteBuffer");
        }
        ByteBuffer byteBuffer = (ByteBuffer)dst;
        int oldPosition = byteBuffer.position();
        byteBuffer.put(src, srcOffset, numElements);
        byteBuffer.position(oldPosition);
        byteBuffer.limit(oldPosition + numElements);
    }

    public static void copy(short[] src, int srcOffset, Buffer dst, int numElements) {
        ShortBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asShortBuffer();
        } else if (dst instanceof ShortBuffer) {
            buffer = (ShortBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or ShortBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
        buffer.limit(oldPosition + numElements);
    }

    public static void copy(char[] src, int srcOffset, Buffer dst, int numElements) {
        CharBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asCharBuffer();
        } else if (dst instanceof CharBuffer) {
            buffer = (CharBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or CharBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
        buffer.limit(oldPosition + numElements);
    }

    public static void copy(int[] src, int srcOffset, Buffer dst, int numElements) {
        IntBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asIntBuffer();
        } else if (dst instanceof IntBuffer) {
            buffer = (IntBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or IntBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
        buffer.limit(oldPosition + numElements);
    }

    public static void copy(long[] src, int srcOffset, Buffer dst, int numElements) {
        LongBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asLongBuffer();
        } else if (dst instanceof LongBuffer) {
            buffer = (LongBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or LongBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
        buffer.limit(oldPosition + numElements);
    }

    public static void copy(float[] src, int srcOffset, Buffer dst, int numElements) {
        FloatBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asFloatBuffer();
        } else if (dst instanceof FloatBuffer) {
            buffer = (FloatBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or FloatBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
        buffer.limit(oldPosition + numElements);
    }

    public static void copy(double[] src, int srcOffset, Buffer dst, int numElements) {
        DoubleBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asDoubleBuffer();
        } else if (dst instanceof DoubleBuffer) {
            buffer = (DoubleBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or DoubleBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
        buffer.limit(oldPosition + numElements);
    }

    public static FloatBuffer newFloatBuffer(int numFloats) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numFloats * 4);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asFloatBuffer();
        }
        return FloatBuffer.wrap(new float[numFloats]);
    }

    public static DoubleBuffer newDoubleBuffer(int numDoubles) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numDoubles * 8);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asDoubleBuffer();
        }
        return DoubleBuffer.wrap(new double[numDoubles]);
    }

    public static ByteBuffer newByteBuffer(int numBytes) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numBytes);
            buffer.order(ByteOrder.nativeOrder());
            return buffer;
        }
        return ByteBuffer.wrap(new byte[numBytes]);
    }

    public static ShortBuffer newShortBuffer(int numShorts) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numShorts * 2);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asShortBuffer();
        }
        return ShortBuffer.wrap(new short[numShorts]);
    }

    public static CharBuffer newCharBuffer(int numChars) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numChars * 2);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asCharBuffer();
        }
        return CharBuffer.wrap(new char[numChars]);
    }

    public static IntBuffer newIntBuffer(int numInts) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numInts * 4);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asIntBuffer();
        }
        return IntBuffer.wrap(new int[numInts]);
    }

    public static LongBuffer newLongBuffer(int numLongs) {
        return LongBuffer.wrap(new long[numLongs]);
    }
}

