/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gwtref.client.ReflectionCache;
import com.badlogic.gwtref.client.Type;

public class ReflectionPool<T>
extends Pool<T> {
    private final Class<T> type;

    public ReflectionPool(Class<T> type) {
        this.type = type;
    }

    public ReflectionPool(Class<T> type, int initialCapacity, int max) {
        super(initialCapacity, max);
        this.type = type;
    }

    public ReflectionPool(Class<T> type, int initialCapacity) {
        super(initialCapacity);
        this.type = type;
    }

    protected T newObject() {
        Type t = ReflectionCache.getType(this.type);
        try {
            return (T)t.newInstance();
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Unable to create new instance: " + this.type.getName(), (Throwable)ex);
        }
    }
}

