/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.gen;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumConstant;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReflectionCacheSourceCreator {
    final TreeLogger logger;
    final GeneratorContext context;
    final JClassType type;
    final String simpleName;
    final String packageName;
    SourceWriter sw;
    StringBuffer source = new StringBuffer();
    Set<JType> types = new HashSet<JType>();
    List<SetterGetterStub> setterGetterStubs = new ArrayList<SetterGetterStub>();
    List<MethodStub> methodStubs = new ArrayList<MethodStub>();
    int nextStub = 0;
    int nesting = 0;
    StringBuffer buffer = new StringBuffer();

    public ReflectionCacheSourceCreator(TreeLogger logger, GeneratorContext context, JClassType type) {
        this.logger = logger;
        this.context = context;
        this.type = type;
        this.packageName = type.getPackage().getName();
        this.simpleName = type.getSimpleSourceName() + "Generated";
        logger.log(TreeLogger.Type.INFO, type.getQualifiedSourceName());
    }

    public String create() {
        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(this.packageName, this.simpleName);
        composer.addImplementedInterface("com.badlogic.gwtref.client.IReflectionCache");
        this.imports(composer);
        PrintWriter printWriter = this.context.tryCreate(this.logger, this.packageName, this.simpleName);
        if (printWriter == null) {
            return this.packageName + "." + this.simpleName;
        }
        this.sw = composer.createSourceWriter(this.context, printWriter);
        this.generateLookups();
        this.getKnownTypesC();
        this.forNameC();
        this.newArrayC();
        this.newInstanceT();
        this.getArrayLengthT();
        this.getArrayElementT();
        this.setArrayElementT();
        this.getF();
        this.setF();
        this.invokeM();
        this.sw.commit(this.logger);
        this.createProxy(this.type);
        return this.packageName + "." + this.simpleName;
    }

    private void createProxy(JClassType type) {
        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(type.getPackage().getName(), type.getSimpleSourceName() + "Proxy");
        PrintWriter printWriter = this.context.tryCreate(this.logger, this.packageName, this.simpleName);
        if (printWriter == null) {
            return;
        }
        SourceWriter writer = composer.createSourceWriter(this.context, printWriter);
        writer.commit(this.logger);
    }

    private void generateLookups() {
        String stubSource;
        JPackage[] packages;
        this.p("Map<String, Type> types = new HashMap<String, Type>();");
        TypeOracle typeOracle = this.context.getTypeOracle();
        for (JPackage p : packages = typeOracle.getPackages()) {
            for (JClassType t : p.getTypes()) {
                this.gatherTypes((JType)t.getErasedType(), this.types);
            }
        }
        this.gatherTypes((JType)typeOracle.findType("java.util.ArrayList").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.util.HashMap").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.util.Map").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.String").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Boolean").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Byte").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Character").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Short").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Integer").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Float").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.CharSequence").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Double").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Object").getErasedType(), this.types);
        int id = 0;
        for (JType t : this.types) {
            String typeGen = this.createTypeGenerator(t);
            this.p("public void c" + id++ + "() {");
            this.p(typeGen);
            this.p("}\n");
        }
        this.p("public " + this.simpleName + "() {");
        for (int i = 0; i < id; ++i) {
            this.p("c" + i + "();");
        }
        this.p("}");
        for (SetterGetterStub stub : this.setterGetterStubs) {
            stubSource = this.generateSetterGetterStub(stub);
            if (stubSource.equals("")) {
                stub.unused = true;
            }
            this.p(stubSource);
        }
        for (MethodStub stub : this.methodStubs) {
            stubSource = this.generateMethodStub(stub);
            if (stubSource.equals("")) {
                stub.unused = true;
            }
            this.p(stubSource);
        }
        this.logger.log(TreeLogger.Type.INFO, this.types.size() + " types reflected");
    }

    private void out(String message, int nesting) {
        for (int i = 0; i < nesting; ++i) {
            System.out.print("  ");
        }
        System.out.println(message);
    }

    private void gatherTypes(JType type, Set<JType> types) {
        JClassType[] inner;
        JMethod[] methods;
        ++this.nesting;
        if (type == null) {
            --this.nesting;
            return;
        }
        if (type.getQualifiedSourceName().contains("-")) {
            --this.nesting;
            return;
        }
        if (!this.isVisible(type)) {
            --this.nesting;
            return;
        }
        String name = type.getQualifiedSourceName();
        if (!(name.contains("com.badlogic.gdx.scenes.scene2d") || name.contains("com.badlogic.gdx.graphics.g2d.TextureRegion") || name.contains("com.badlogic.gdx.graphics.g2d.BitmapFont") || name.contains("com.badlogic.gdx.graphics.g2d.NinePatch") || name.contains("com.badlogic.gdx.graphics.Color") || name.contains("com.badlogic.gdx.utils.Array") || name.contains("com.badlogic.gdx.utils.ObjectMap") || name.contains("com.badlogic.gdx.utils.OrderedMap") || name.contains("com.badlogic.gdx.utils.Disposable") || name.contains("java.util.ArrayList") || name.contains("java.util.Map") || name.contains("java.util.HashMap") || name.contains("java.lang.String") || name.contains("java.lang.Boolean") || name.contains("java.lang.Byte") || name.contains("java.lang.Short") || name.contains("java.lang.Character") || name.contains("java.lang.Integer") || name.contains("java.lang.Float") || name.contains("java.lang.Double") || name.contains("java.lang.CharSequence") || name.contains("java.lang.Object") || !name.contains("."))) {
            --this.nesting;
            return;
        }
        if (types.contains(type.getErasedType())) {
            --this.nesting;
            return;
        }
        types.add(type.getErasedType());
        this.out(type.getErasedType().getQualifiedSourceName(), this.nesting);
        if (type instanceof JPrimitiveType) {
            --this.nesting;
            return;
        }
        JClassType c = (JClassType)type;
        JField[] fields = c.getFields();
        if (fields != null) {
            for (JField field : fields) {
                this.gatherTypes(field.getType().getErasedType(), types);
            }
        }
        this.gatherTypes((JType)c.getSuperclass(), types);
        JClassType[] interfaces = c.getImplementedInterfaces();
        if (interfaces != null) {
            for (JClassType i : interfaces) {
                this.gatherTypes((JType)i.getErasedType(), types);
            }
        }
        if ((methods = c.getMethods()) != null) {
            for (JMethod m : methods) {
                this.gatherTypes(m.getReturnType().getErasedType(), types);
                if (m.getParameterTypes() == null) continue;
                for (JType p : m.getParameterTypes()) {
                    this.gatherTypes(p.getErasedType(), types);
                }
            }
        }
        if ((inner = c.getNestedTypes()) != null) {
            for (JClassType i : inner) {
                this.gatherTypes((JType)i.getErasedType(), types);
            }
        }
        --this.nesting;
    }

    private String generateMethodStub(MethodStub stub) {
        int i;
        this.buffer.setLength(0);
        if (stub.enclosingType == null) {
            this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of invisible class is not invokable");
            return "";
        }
        if (stub.enclosingType.startsWith("java") || stub.enclosingType.contains("google")) {
            this.logger.log(TreeLogger.Type.INFO, "not emitting code for accessing method " + stub.name + " in class '" + stub.enclosingType + ", either in java.* or GWT related class");
            return "";
        }
        if (stub.enclosingType.contains("[]")) {
            this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + "' is not invokable because the class is an array type");
            return "";
        }
        for (i = 0; i < stub.parameterTypes.size(); ++i) {
            String paramType = stub.parameterTypes.get(i);
            if (paramType == null) {
                this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + "' is not invokable because one of its argument types is not visible");
                return "";
            }
            if (paramType.startsWith("long") || paramType.contains("java.lang.Long")) {
                this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + " has long parameter, prohibited in JSNI");
                return "";
            }
            stub.parameterTypes.set(i, paramType.replace(".class", ""));
        }
        if (stub.returnType == null) {
            this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + "' is not invokable because its return type is not visible");
            return "";
        }
        if (stub.returnType.startsWith("long") || stub.returnType.contains("java.lang.Long")) {
            this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + " has long return type, prohibited in JSNI");
            return "";
        }
        stub.enclosingType = stub.enclosingType.replace(".class", "");
        stub.returnType = stub.returnType.replace(".class", "");
        this.pbn("public native " + stub.returnType + " " + stub.methodId + "(");
        this.pbn(stub.enclosingType + " obj" + (stub.parameterTypes.size() > 0 ? ", " : ""));
        i = 0;
        for (String paramType : stub.parameterTypes) {
            this.pbn(paramType + " p" + i + (i < stub.parameterTypes.size() - 1 ? "," : ""));
            ++i;
        }
        this.pb(") /*-{");
        if (!stub.returnType.equals("void")) {
            this.pbn("return ");
        }
        if (stub.isStatic) {
            this.pbn("@" + stub.enclosingType + "::" + stub.name + "(" + stub.jnsi + ")(");
        } else {
            this.pbn("obj.@" + stub.enclosingType + "::" + stub.name + "(" + stub.jnsi + ")(");
        }
        for (i = 0; i < stub.parameterTypes.size(); ++i) {
            this.pbn("p" + i + (i < stub.parameterTypes.size() - 1 ? ", " : ""));
        }
        this.pb(");");
        this.pb("}-*/;");
        return this.buffer.toString();
    }

    private String generateSetterGetterStub(SetterGetterStub stub) {
        this.buffer.setLength(0);
        if (stub.enclosingType == null || stub.type == null) {
            this.logger.log(TreeLogger.Type.INFO, "field '" + stub.name + "' in class '" + stub.enclosingType + "' is not accessible as its type '" + stub.type + "' is not public");
            return "";
        }
        if (stub.enclosingType.startsWith("java") || stub.enclosingType.contains("google")) {
            this.logger.log(TreeLogger.Type.INFO, "not emitting code for accessing field " + stub.name + " in class '" + stub.enclosingType + ", either in java.* or GWT related class");
            return "";
        }
        if (stub.type.startsWith("long") || stub.type.contains("java.lang.Long")) {
            this.logger.log(TreeLogger.Type.INFO, "not emitting code for accessing field " + stub.name + " in class '" + stub.enclosingType + " as its of type long which can't be used with JSNI");
            return "";
        }
        stub.enclosingType = stub.enclosingType.replace(".class", "");
        stub.type = stub.type.replace(".class", "");
        this.pb("public native Object " + stub.getter + "(" + stub.enclosingType + " obj) /*-{");
        if (stub.isStatic) {
            this.pb("   return @" + stub.enclosingType + "::" + stub.name + ";");
        } else {
            this.pb("   return obj.@" + stub.enclosingType + "::" + stub.name + ";");
        }
        this.pb("}-*/;");
        if (!stub.isFinal) {
            this.pb("public native void " + stub.setter + "(" + stub.enclosingType + " obj, Object value)  /*-{");
            if (stub.isStatic) {
                this.pb("    @" + stub.enclosingType + "::" + stub.name + " = value");
            } else {
                this.pb("    obj.@" + stub.enclosingType + "::" + stub.name + " = value;");
            }
            this.pb("}-*/;");
        }
        return this.buffer.toString();
    }

    private boolean isVisible(JType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JClassType) {
            if (type instanceof JArrayType) {
                JType componentType = ((JArrayType)type).getComponentType();
                while (componentType instanceof JArrayType) {
                    componentType = ((JArrayType)componentType).getComponentType();
                }
                if (componentType instanceof JClassType) {
                    return ((JClassType)componentType).isPublic();
                }
            } else {
                return ((JClassType)type).isPublic();
            }
        }
        return true;
    }

    private String createTypeGenerator(JType t) {
        this.buffer.setLength(0);
        String varName = "t";
        if (t instanceof JPrimitiveType) {
            varName = "p";
        }
        this.pb("Type " + varName + " = new Type();");
        this.pb(varName + ".name = \"" + t.getErasedType().getQualifiedSourceName() + "\";");
        this.pb(varName + ".clazz = " + t.getErasedType().getQualifiedSourceName() + ".class;");
        if (t instanceof JClassType) {
            JEnumConstant[] enumConstants;
            String enclosingType;
            JClassType c = (JClassType)t;
            if (this.isVisible((JType)c.getSuperclass())) {
                this.pb(varName + ".superClass = " + c.getSuperclass().getErasedType().getQualifiedSourceName() + ".class;");
            }
            if (c.getFlattenedSupertypeHierarchy() != null) {
                this.pb("Set<Class> " + varName + "Assignables = new HashSet<Class>();");
                for (JClassType i : c.getFlattenedSupertypeHierarchy()) {
                    if (!this.isVisible((JType)i)) continue;
                    this.pb(varName + "Assignables.add(" + i.getErasedType().getQualifiedSourceName() + ".class);");
                }
                this.pb(varName + ".assignables = " + varName + "Assignables;");
            }
            if (c.isInterface() != null) {
                this.pb(varName + ".isInterface = true;");
            }
            if (c.isEnum() != null) {
                this.pb(varName + ".isEnum = true;");
            }
            if (c.isArray() != null) {
                this.pb(varName + ".isArray = true;");
            }
            if (c.isMemberType()) {
                this.pb(varName + ".isMemberClass = true;");
            }
            this.pb(varName + ".isStatic = " + c.isStatic() + ";");
            this.pb(varName + ".isAbstract = " + c.isAbstract() + ";");
            if (c.getFields() != null) {
                this.pb(varName + ".fields = new Field[] {");
                for (JField jField : c.getFields()) {
                    enclosingType = this.getType((JType)c);
                    String fieldType = this.getType(jField.getType());
                    String setter = "s" + this.nextStub++;
                    String getter = "g" + this.nextStub++;
                    this.pb("new Field(\"" + jField.getName() + "\", " + enclosingType + ", " + fieldType + ", " + jField.isFinal() + ", " + jField.isDefaultAccess() + ", " + jField.isPrivate() + ", " + jField.isProtected() + ", " + jField.isPublic() + ", " + jField.isStatic() + ", " + jField.isTransient() + ", " + jField.isVolatile() + ", " + "\"" + getter + "\", " + "\"" + setter + "\" " + "), ");
                    SetterGetterStub stub = new SetterGetterStub();
                    stub.name = jField.getName();
                    stub.enclosingType = enclosingType;
                    stub.type = fieldType;
                    stub.isStatic = jField.isStatic();
                    stub.isFinal = jField.isFinal();
                    if (enclosingType != null && fieldType != null) {
                        stub.getter = getter;
                        stub.setter = setter;
                    }
                    this.setterGetterStubs.add(stub);
                }
                this.pb("};");
            }
            if (c.getMethods() != null) {
                this.pb(varName + ".methods = new Method[] {");
                for (JField jField : c.getMethods()) {
                    enclosingType = this.getType((JType)c);
                    String returnType = this.getType(jField.getReturnType());
                    String methodId = "m" + this.nextStub++;
                    MethodStub stub = new MethodStub();
                    stub.enclosingType = enclosingType;
                    stub.returnType = returnType;
                    stub.jnsi = "";
                    stub.isStatic = jField.isStatic();
                    stub.isAbstract = jField.isAbstract();
                    stub.methodId = methodId;
                    stub.name = jField.getName();
                    this.methodStubs.add(stub);
                    this.pb("new Method(\"" + jField.getName() + "\", ");
                    this.pb(enclosingType + ", ");
                    this.pb(returnType + ", ");
                    if (jField.getParameters() != null) {
                        this.pb("new Parameter[] {");
                        for (JParameter p : jField.getParameters()) {
                            String paramType = this.getType(p.getType());
                            stub.parameterTypes.add(paramType);
                            stub.jnsi = stub.jnsi + p.getType().getErasedType().getJNISignature();
                            this.pb("new Parameter(\"" + p.getName() + "\", " + paramType + ", \"" + p.getType().getJNISignature() + "\"), ");
                        }
                        this.pb("}, ");
                    } else {
                        this.pb("new Parameter[0], ");
                    }
                    this.pb(jField.isAbstract() + ", " + jField.isFinal() + ", " + jField.isStatic() + ", " + jField.isDefaultAccess() + ", " + jField.isPrivate() + ", " + jField.isProtected() + ", " + jField.isPublic() + ", " + jField.isNative() + ", " + jField.isVarArgs() + ", " + (jField.isMethod() != null) + ", " + (jField.isConstructor() != null) + ", " + "\"" + methodId + "\"" + "),");
                }
                this.pb("};");
            }
            if (c.isArray() != null) {
                this.pb(varName + ".componentType = " + this.getType(c.isArray().getComponentType()) + ";");
            }
            if (c.isEnum() != null && (enumConstants = c.isEnum().getEnumConstants()) != null) {
                this.pb(varName + ".enumConstants = new Object[" + enumConstants.length + "];");
                for (int i = 0; i < enumConstants.length; ++i) {
                    this.pb(varName + ".enumConstants[" + i + "] = " + c.getErasedType().getQualifiedSourceName() + "." + enumConstants[i].getName() + ";");
                }
            }
        } else {
            this.pb(varName + ".isPrimitive = true;");
        }
        this.pb("types.put(\"" + t.getErasedType().getQualifiedSourceName() + "\", " + varName + ");");
        return this.buffer.toString();
    }

    private String getType(JType type) {
        if (!this.isVisible(type)) {
            return null;
        }
        return type.getErasedType().getQualifiedSourceName() + ".class";
    }

    private void imports(ClassSourceFileComposerFactory composer) {
        composer.addImport("java.security.AccessControlException");
        composer.addImport("java.util.*");
        composer.addImport("com.badlogic.gwtref.client.*");
    }

    private void invokeM() {
        this.p("public Object invoke(Method m, Object obj, Object[] params) {");
        for (MethodStub stub : this.methodStubs) {
            if (stub.enclosingType == null || stub.enclosingType.contains("[]") || stub.returnType == null || stub.unused) continue;
            boolean paramsOk = true;
            for (String paramType : stub.parameterTypes) {
                if (paramType != null) continue;
                paramsOk = false;
                break;
            }
            if (!paramsOk) continue;
            this.p("   if(m.methodId.equals(\"" + stub.methodId + "\")) {");
            if (stub.returnType.equals("void")) {
                this.pn("      " + stub.methodId + "(");
                this.addParameters(stub);
                this.p(");");
                this.p("      return null;");
            } else {
                this.pn("      return " + stub.methodId + "(");
                this.addParameters(stub);
                this.pn(");");
            }
            this.p("   }");
        }
        this.p("   return null;");
        this.p("}");
    }

    private void addParameters(MethodStub stub) {
        this.pn("(" + stub.enclosingType + ")obj" + (stub.parameterTypes.size() > 0 ? "," : ""));
        for (int i = 0; i < stub.parameterTypes.size(); ++i) {
            String paramType = stub.parameterTypes.get(i);
            if (this.isPrimitive(paramType)) {
                this.pn(this.castPrimitive(paramType, "params[" + i + "]") + (i < stub.parameterTypes.size() - 1 ? ", " : ""));
                continue;
            }
            this.pn("(" + stub.parameterTypes.get(i) + ")params[" + i + "]" + (i < stub.parameterTypes.size() - 1 ? ", " : ""));
        }
    }

    private boolean isPrimitive(String paramType) {
        return paramType.equals("boolean") || paramType.equals("byte") || paramType.equals("char") || paramType.equals("short") || paramType.equals("int") || paramType.equals("long") || paramType.equals("float") || paramType.equals("double");
    }

    private String castPrimitive(String paramType, String arg) {
        if (paramType.equals("byte") || paramType.equals("short") || paramType.equals("int") || paramType.equals("long") || paramType.equals("float") || paramType.equals("double")) {
            return "((Number)" + arg + ")." + paramType + "Value()";
        }
        if (paramType.equals("boolean")) {
            return "((Boolean)" + arg + ")." + paramType + "Value()";
        }
        return "((Character)" + arg + ")." + paramType + "Value()";
    }

    private void setF() {
        this.p("public void set(Field field, Object obj, Object value) throws IllegalAccessException {");
        for (SetterGetterStub stub : this.setterGetterStubs) {
            if (stub.enclosingType == null || stub.type == null || stub.isFinal || stub.unused) continue;
            this.p("   if(field.setter.equals(\"" + stub.setter + "\")) " + stub.setter + "((" + stub.enclosingType + ")obj, value);");
        }
        this.p("}");
    }

    private void getF() {
        this.p("public Object get(Field field, Object obj) throws IllegalAccessException {");
        for (SetterGetterStub stub : this.setterGetterStubs) {
            if (stub.enclosingType == null || stub.type == null || stub.unused) continue;
            this.p("   if(field.getter.equals(\"" + stub.getter + "\")) return " + stub.getter + "((" + stub.enclosingType + ")obj);");
        }
        this.p("   return null;");
        this.p("}");
    }

    private void newInstanceT() {
        this.p("public Object newInstance (Type type) {");
        for (JType type : this.types) {
            if (type instanceof JClassType) {
                JClassType clazzType = (JClassType)type;
                if (clazzType.isDefaultInstantiable() && !(clazzType instanceof JArrayType) && !(clazzType instanceof JEnumType)) {
                    this.p("if(type.getName().equals(\"" + type.getErasedType().getQualifiedSourceName() + "\")) return new " + type.getErasedType().getQualifiedSourceName() + "();");
                    continue;
                }
                this.logger.log(TreeLogger.Type.INFO, "No public default constructor for '" + type.getQualifiedSourceName() + "', or type is an array, enum, abstract class or interface type");
                continue;
            }
            this.logger.log(TreeLogger.Type.INFO, "No public default constructor for primitive type '" + type.getQualifiedSourceName() + "'");
        }
        this.p("return null;");
        this.p("}");
    }

    private void setArrayElementT() {
        this.p("public void setArrayElement(Type type, Object obj, int i, Object value) {");
        for (JType type : this.types) {
            if (!(type instanceof JArrayType)) continue;
            String value = ((JArrayType)type).getComponentType().getErasedType().getQualifiedSourceName();
            value = this.isPrimitive(value) ? this.castPrimitive(value, "value") : "(" + value + ")value";
            this.p("   if(type.getName().equals(\"" + type.getQualifiedSourceName() + "\")) ((" + type.getQualifiedSourceName() + ")obj)[i] = " + value + ";");
        }
        this.p("}");
    }

    private void getArrayElementT() {
        this.p("public Object getArrayElement(Type type, Object obj, int i) {");
        for (JType type : this.types) {
            if (!(type instanceof JArrayType)) continue;
            this.p("   if(type.getName().equals(\"" + type.getQualifiedSourceName() + "\")) return ((" + type.getQualifiedSourceName() + ")obj)[i];");
        }
        this.p("\treturn null;");
        this.p("}");
    }

    private void getArrayLengthT() {
        this.p("public int getArrayLength(Type type, Object obj) {");
        for (JType type : this.types) {
            if (!(type instanceof JArrayType)) continue;
            this.p("   if(type.getName().equals(\"" + type.getQualifiedSourceName() + "\")) return ((" + type.getQualifiedSourceName() + ")obj).length;");
        }
        this.p("\treturn 0;");
        this.p("}");
    }

    private void newArrayC() {
        this.p("public Object newArray (Class componentType, int size) {");
        this.p("    String typeName = componentType.getName().replace('$', '.');");
        for (JType type : this.types) {
            if (type.getQualifiedSourceName().equals("void") || type.getQualifiedSourceName().endsWith("Void")) continue;
            String arrayType = type.getErasedType().getQualifiedSourceName() + "[size]";
            if (arrayType.contains("[]")) {
                arrayType = type.getErasedType().getQualifiedSourceName();
                arrayType = arrayType.replaceFirst("\\[\\]", "[size]") + "[]";
            }
            this.p("   if(typeName.equals(\"" + type.getQualifiedSourceName() + "\")) return new " + arrayType + ";");
        }
        this.p("\tthrow new RuntimeException(\"Couldn't create array with element type \" + componentType.getName());");
        this.p("}");
    }

    private void forNameC() {
        this.p("public Type forName(String name) {");
        this.p("\treturn types.get(name);");
        this.p("}");
    }

    private void getKnownTypesC() {
        this.p("public Collection<Type> getKnownTypes() {");
        this.p("\treturn types.values();");
        this.p("}");
    }

    private void p(String line) {
        this.sw.println(line);
        this.source.append(line);
        this.source.append("\n");
    }

    private void pn(String line) {
        this.sw.print(line);
        this.source.append(line);
    }

    private void pb(String line) {
        this.buffer.append(line);
        this.buffer.append("\n");
    }

    private void pbn(String line) {
        this.buffer.append(line);
    }

    class MethodStub {
        String enclosingType;
        String returnType;
        List<String> parameterTypes = new ArrayList<String>();
        String jnsi;
        String methodId;
        boolean isStatic;
        boolean isAbstract;
        String name;
        boolean unused;

        MethodStub() {
        }
    }

    class SetterGetterStub {
        String getter;
        String setter;
        String name;
        String enclosingType;
        String type;
        boolean isStatic;
        boolean isFinal;
        boolean unused;

        SetterGetterStub() {
        }
    }
}

