/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.webgl.client;

import com.google.gwt.webgl.client.WebGLProgram;
import com.google.gwt.webgl.client.WebGLRenderingContext;
import com.google.gwt.webgl.client.WebGLShader;

public class WebGLUtil {
    public static float[] createPerspectiveMatrix(int fieldOfViewVertical, float aspectRatio, float minimumClearance, float maximumClearance) {
        double fieldOfViewInRad = (double)fieldOfViewVertical * Math.PI / 180.0;
        return new float[]{(float)(Math.tan(fieldOfViewInRad) / (double)aspectRatio), 0.0f, 0.0f, 0.0f, 0.0f, (float)(1.0 / Math.tan((double)fieldOfViewVertical * Math.PI / 180.0)), 0.0f, 0.0f, 0.0f, 0.0f, (minimumClearance + maximumClearance) / (minimumClearance - maximumClearance), -1.0f, 0.0f, 0.0f, 2.0f * minimumClearance * maximumClearance / (minimumClearance - maximumClearance), 0.0f};
    }

    public static WebGLProgram createShaderProgram(WebGLRenderingContext gl, String vertexSource, String fragmentSource) {
        WebGLShader vertexShader = WebGLUtil.getShader(gl, 35633, vertexSource);
        WebGLShader fragmentShader = WebGLUtil.getShader(gl, 35632, fragmentSource);
        WebGLProgram shaderProgram = gl.createProgram();
        gl.attachShader(shaderProgram, fragmentShader);
        gl.attachShader(shaderProgram, vertexShader);
        gl.linkProgram(shaderProgram);
        if (!gl.getProgramParameterb(shaderProgram, 35714)) {
            throw new RuntimeException("Could not initialize shaders");
        }
        return shaderProgram;
    }

    private static WebGLShader getShader(WebGLRenderingContext gl, int shaderType, String source) {
        WebGLShader shader = gl.createShader(shaderType);
        gl.shaderSource(shader, source);
        gl.compileShader(shader);
        if (!gl.getShaderParameterb(shader, 35713)) {
            throw new RuntimeException(gl.getShaderInfoLog(shader));
        }
        return shader;
    }
}

