/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    protected int count;
    protected byte[] buf;

    public ByteArrayOutputStream() {
        this(16);
    }

    public ByteArrayOutputStream(int initialSize) {
        this.buf = new byte[initialSize];
    }

    @Override
    public void write(int b) {
        if (this.buf.length == this.count) {
            byte[] newBuf = new byte[this.buf.length * 3 / 2];
            System.arraycopy(this.buf, 0, newBuf, 0, this.count);
            this.buf = newBuf;
        }
        this.buf[this.count++] = (byte)b;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.count];
        System.arraycopy(this.buf, 0, result, 0, this.count);
        return result;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }
}

