/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.google.gwt.corp.localstorage.LocalStorage;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class File {
    public static final File ROOT = new File("");
    public static final char separatorChar = '/';
    public static final String separator = "/";
    public static final char pathSeparatorChar = ':';
    public static final String pathSeparator = ":";
    File parent;
    String name;
    boolean absolute;

    public File(String pathname) {
        while (pathname.endsWith(separator) && pathname.length() > 0) {
            pathname = pathname.substring(0, pathname.length() - 1);
        }
        int cut = pathname.lastIndexOf(47);
        if (cut == -1) {
            this.name = pathname;
        } else if (cut == 0) {
            this.name = pathname.substring(cut);
            this.parent = this.name.equals("") ? null : ROOT;
        } else {
            this.name = pathname.substring(cut + 1);
            this.parent = new File(pathname.substring(0, cut));
        }
    }

    public File(String parent, String child) {
        this(new File(parent), child);
    }

    public File(File parent, String child) {
        this.parent = parent;
        this.name = child;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent == null ? "" : this.parent.getPath();
    }

    public File getParentFile() {
        return this.parent;
    }

    public String getPath() {
        return this.parent == null ? this.name : this.parent.getPath() + '/' + this.name;
    }

    private boolean isRoot() {
        return this.name.equals("") && this.parent == null;
    }

    public boolean isAbsolute() {
        if (this.isRoot()) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.isAbsolute();
    }

    public String getAbsolutePath() {
        String path = this.getAbsoluteFile().getPath();
        return path.length() == 0 ? separator : path;
    }

    public File getAbsoluteFile() {
        if (this.isAbsolute()) {
            return this;
        }
        if (this.parent == null) {
            return new File(ROOT, this.name);
        }
        return new File(this.parent.getAbsoluteFile(), this.name);
    }

    public String getCanonicalPath() {
        return this.getCanonicalFile().getAbsolutePath();
    }

    public File getCanonicalFile() {
        File cParent;
        File file = cParent = this.parent == null ? null : this.parent.getCanonicalFile();
        if (this.name.equals(".")) {
            return cParent == null ? ROOT : cParent;
        }
        if (cParent != null && cParent.name.equals("")) {
            cParent = null;
        }
        if (this.name.equals("..")) {
            if (cParent == null) {
                return ROOT;
            }
            if (cParent.parent == null) {
                return ROOT;
            }
            return cParent.parent;
        }
        if (cParent == null && !this.name.equals("")) {
            return new File(ROOT, this.name);
        }
        return new File(cParent, this.name);
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean exists() {
        try {
            return LocalStorage.getItem(this.getCanonicalPath()) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isDirectory() {
        try {
            String s = LocalStorage.getItem(this.getCanonicalPath());
            return s != null && s.startsWith("{");
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isFile() {
        try {
            String s = LocalStorage.getItem(this.getCanonicalPath());
            return s != null && !s.startsWith("{");
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        try {
            if (!this.exists()) {
                return 0L;
            }
            RandomAccessFile raf = new RandomAccessFile(this, "r");
            long len = raf.length();
            raf.close();
            return len;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public boolean createNewFile() throws IOException {
        if (this.exists()) {
            return false;
        }
        if (!this.parent.exists()) {
            return false;
        }
        LocalStorage.setItem(this.getCanonicalPath(), RandomAccessFile.btoa(""));
        return true;
    }

    public boolean delete() {
        try {
            if (!this.exists()) {
                return false;
            }
            LocalStorage.removeItem(this.getCanonicalPath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void deleteOnExit() {
        throw new RuntimeException("NYI: File.deleteOnExit()");
    }

    public String[] list() {
        throw new RuntimeException("NYI: File.list()");
    }

    public File[] listFiles() {
        return this.listFiles(null);
    }

    public File[] listFiles(FilenameFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            String prefix = this.getCanonicalPath();
            if (!prefix.endsWith(separator)) {
                prefix = prefix + '/';
            }
            int cut = prefix.length();
            int cnt = LocalStorage.length();
            for (int i = 0; i < cnt; ++i) {
                String key = LocalStorage.key(i);
                if (!key.startsWith(prefix) || key.indexOf(47, cut) != -1) continue;
                String name = key.substring(cut);
                if (filter != null && !filter.accept(this, name)) continue;
                files.add(new File(this, name));
            }
        }
        catch (IOException e) {
            System.err.println("lisFiles() exception: " + e);
        }
        return files.toArray(new File[files.size()]);
    }

    public boolean mkdir() {
        try {
            if (this.parent != null && !this.parent.exists()) {
                return false;
            }
            if (this.exists()) {
                return false;
            }
            LocalStorage.setItem(this.getCanonicalPath(), "{}");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean mkdirs() {
        if (this.parent != null) {
            this.parent.mkdirs();
        }
        return this.mkdir();
    }

    public boolean renameTo(File dest) {
        throw new RuntimeException("renameTo()");
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public static File[] listRoots() {
        return new File[]{ROOT};
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        throw new RuntimeException("NYI: createTempFile");
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        throw new RuntimeException("NYI: createTempFile");
    }

    public int compareTo(File pathname) {
        throw new RuntimeException("NYI: File.compareTo()");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        return this.getPath().equals(((File)obj).getPath());
    }

    public int hashCode() {
        return this.parent != null ? this.parent.hashCode() + this.name.hashCode() : this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

