/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.InvalidMarkException;

public abstract class Buffer {
    static final int UNSET_MARK = -1;
    final int capacity;
    int limit;
    int mark = -1;
    int position = 0;

    Buffer(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = this.limit = capacity;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final Buffer clear() {
        this.position = 0;
        this.mark = -1;
        this.limit = this.capacity;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.capacity) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > newLimit) {
            this.position = newLimit;
        }
        if (this.mark != -1 && this.mark > newLimit) {
            this.mark = -1;
        }
        return this;
    }

    public final Buffer mark() {
        this.mark = this.position;
        return this;
    }

    public final int position() {
        return this.position;
    }

    public final Buffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        if (this.mark != -1 && this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final Buffer reset() {
        if (this.mark == -1) {
            throw new InvalidMarkException();
        }
        this.position = this.mark;
        return this;
    }

    public final Buffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }
}

