/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class CharSequenceAdapter
extends CharBuffer {
    final CharSequence sequence;

    static CharSequenceAdapter copy(CharSequenceAdapter other) {
        CharSequenceAdapter buf = new CharSequenceAdapter(other.sequence);
        buf.limit = other.limit;
        buf.position = other.position;
        buf.mark = other.mark;
        return buf;
    }

    CharSequenceAdapter(CharSequence chseq) {
        super(chseq.length());
        this.sequence = chseq;
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer duplicate() {
        return CharSequenceAdapter.copy(this);
    }

    @Override
    public char get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.sequence.charAt(this.position++);
    }

    @Override
    public char get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.sequence.charAt(index);
    }

    @Override
    public final CharBuffer get(char[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int newPosition = this.position + len;
        ((Object)this.sequence).toString().getChars(this.position, newPosition, dest, off);
        this.position = newPosition;
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    protected char[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public CharBuffer put(char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(int index, char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final CharBuffer put(char[] src, int off, int len) {
        if (off < 0 || len < 0 || (long)off + (long)len > (long)src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(String src, int start, int end) {
        if (start < 0 || end < 0 || (long)start + (long)end > (long)src.length()) {
            throw new IndexOutOfBoundsException();
        }
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer slice() {
        return new CharSequenceAdapter(this.sequence.subSequence(this.position, this.limit));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end < start || start < 0 || end > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        CharSequenceAdapter result = CharSequenceAdapter.copy(this);
        result.position = this.position + start;
        result.limit = this.position + end;
        return result;
    }
}

