/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.corp.compatibility.Endianness;
import com.google.gwt.corp.compatibility.Numbers;
import com.google.gwt.typedarrays.client.ArrayBuffer;
import com.google.gwt.typedarrays.client.ArrayBufferView;
import com.google.gwt.typedarrays.client.Int8Array;
import java.nio.BaseByteBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.HasArrayBufferView;

abstract class DirectByteBuffer
extends BaseByteBuffer
implements HasArrayBufferView {
    Int8Array byteArray;

    DirectByteBuffer(int capacity) {
        this(ArrayBuffer.create(capacity), capacity, 0);
    }

    DirectByteBuffer(ArrayBuffer buf) {
        this(buf, buf.getByteLength(), 0);
    }

    DirectByteBuffer(ArrayBuffer buffer, int capacity, int offset) {
        super(capacity);
        this.byteArray = Int8Array.create(buffer, offset, capacity);
    }

    @Override
    public ArrayBufferView getTypedArray() {
        return this.byteArray;
    }

    @Override
    public int getElementSize() {
        return 1;
    }

    @Override
    public final ByteBuffer get(byte[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = 0; i < len; ++i) {
            dest[i + off] = this.get(this.position + i);
        }
        this.position += len;
        return this;
    }

    @Override
    public final byte get() {
        return (byte)this.byteArray.get(this.position++);
    }

    @Override
    public final byte get(int index) {
        return (byte)this.byteArray.get(index);
    }

    @Override
    public final double getDouble() {
        return Numbers.longBitsToDouble(this.getLong());
    }

    @Override
    public final double getDouble(int index) {
        return Numbers.longBitsToDouble(this.getLong(index));
    }

    @Override
    public final float getFloat() {
        return Numbers.intBitsToFloat(this.getInt());
    }

    @Override
    public final float getFloat(int index) {
        return Numbers.intBitsToFloat(this.getInt(index));
    }

    @Override
    public final int getInt() {
        int newPosition = this.position + 4;
        int result = this.loadInt(this.position);
        this.position = newPosition;
        return result;
    }

    @Override
    public final int getInt(int index) {
        return this.loadInt(index);
    }

    @Override
    public final long getLong() {
        int newPosition = this.position + 8;
        long result = this.loadLong(this.position);
        this.position = newPosition;
        return result;
    }

    @Override
    public final long getLong(int index) {
        return this.loadLong(index);
    }

    @Override
    public final short getShort() {
        int newPosition = this.position + 2;
        short result = this.loadShort(this.position);
        this.position = newPosition;
        return result;
    }

    @Override
    public final short getShort(int index) {
        return this.loadShort(index);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    protected final int loadInt(int baseOffset) {
        int bytes = 0;
        if (this.order == Endianness.BIG_ENDIAN) {
            for (int i = 0; i < 4; ++i) {
                bytes <<= 8;
                bytes |= this.byteArray.get(baseOffset + i) & 0xFF;
            }
        } else {
            for (int i = 3; i >= 0; --i) {
                bytes <<= 8;
                bytes |= this.byteArray.get(baseOffset + i) & 0xFF;
            }
        }
        return bytes;
    }

    protected final long loadLong(int baseOffset) {
        long bytes = 0L;
        if (this.order == Endianness.BIG_ENDIAN) {
            for (int i = 0; i < 8; ++i) {
                bytes <<= 8;
                bytes |= (long)(this.byteArray.get(baseOffset + i) & 0xFF);
            }
        } else {
            for (int i = 7; i >= 0; --i) {
                bytes <<= 8;
                bytes |= (long)(this.byteArray.get(baseOffset + i) & 0xFF);
            }
        }
        return bytes;
    }

    protected final short loadShort(int baseOffset) {
        short bytes = 0;
        if (this.order == Endianness.BIG_ENDIAN) {
            bytes = (short)(this.byteArray.get(baseOffset) << 8);
            bytes = (short)(bytes | this.byteArray.get(baseOffset + 1) & 0xFF);
        } else {
            bytes = (short)(this.byteArray.get(baseOffset + 1) << 8);
            bytes = (short)(bytes | this.byteArray.get(baseOffset) & 0xFF);
        }
        return bytes;
    }

    protected final void store(int baseOffset, int value) {
        if (this.order == Endianness.BIG_ENDIAN) {
            for (int i = 3; i >= 0; --i) {
                this.byteArray.set(baseOffset + i, (int)((byte)(value & 0xFF)));
                value >>= 8;
            }
        } else {
            for (int i = 0; i <= 3; ++i) {
                this.byteArray.set(baseOffset + i, (int)((byte)(value & 0xFF)));
                value >>= 8;
            }
        }
    }

    protected final void store(int baseOffset, long value) {
        if (this.order == Endianness.BIG_ENDIAN) {
            for (int i = 7; i >= 0; --i) {
                this.byteArray.set(baseOffset + i, (int)((byte)(value & 0xFFL)));
                value >>= 8;
            }
        } else {
            for (int i = 0; i <= 7; ++i) {
                this.byteArray.set(baseOffset + i, (int)((byte)(value & 0xFFL)));
                value >>= 8;
            }
        }
    }

    protected final void store(int baseOffset, short value) {
        if (this.order == Endianness.BIG_ENDIAN) {
            this.byteArray.set(baseOffset, (int)((byte)(value >> 8 & 0xFF)));
            this.byteArray.set(baseOffset + 1, (int)((byte)(value & 0xFF)));
        } else {
            this.byteArray.set(baseOffset + 1, (int)((byte)(value >> 8 & 0xFF)));
            this.byteArray.set(baseOffset, (int)((byte)(value & 0xFF)));
        }
    }
}

