/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.typedarrays.client.ArrayBufferView;
import com.google.gwt.typedarrays.client.Int32Array;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.HasArrayBufferView;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;

final class DirectReadOnlyIntBufferAdapter
extends IntBuffer
implements HasArrayBufferView {
    private final DirectByteBuffer byteBuffer;
    private final Int32Array intArray;

    static IntBuffer wrap(DirectByteBuffer byteBuffer) {
        return new DirectReadOnlyIntBufferAdapter((DirectByteBuffer)byteBuffer.slice());
    }

    DirectReadOnlyIntBufferAdapter(DirectByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 2);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.intArray = Int32Array.create(byteBuffer.byteArray.getBuffer(), byteBuffer.byteArray.getByteOffset(), this.capacity);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        DirectReadOnlyIntBufferAdapter buf = new DirectReadOnlyIntBufferAdapter(this.byteBuffer);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public IntBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer duplicate() {
        DirectReadOnlyIntBufferAdapter buf = new DirectReadOnlyIntBufferAdapter((DirectByteBuffer)this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public int get() {
        return this.intArray.get(this.position++);
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.intArray.get(index);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected int[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public IntBuffer put(int c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int index, int c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer slice() {
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        DirectReadOnlyIntBufferAdapter result = new DirectReadOnlyIntBufferAdapter((DirectByteBuffer)this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ArrayBufferView getTypedArray() {
        return this.intArray;
    }

    @Override
    public int getElementSize() {
        return 4;
    }
}

