/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.typedarrays.client.ArrayBufferView;
import com.google.gwt.typedarrays.client.Int32Array;
import java.nio.ByteOrder;
import java.nio.DirectReadOnlyIntBufferAdapter;
import java.nio.DirectReadWriteByteBuffer;
import java.nio.HasArrayBufferView;
import java.nio.IntBuffer;

final class DirectReadWriteIntBufferAdapter
extends IntBuffer
implements HasArrayBufferView {
    private final DirectReadWriteByteBuffer byteBuffer;
    private final Int32Array intArray;

    static IntBuffer wrap(DirectReadWriteByteBuffer byteBuffer) {
        return new DirectReadWriteIntBufferAdapter((DirectReadWriteByteBuffer)byteBuffer.slice());
    }

    DirectReadWriteIntBufferAdapter(DirectReadWriteByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 2);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.intArray = Int32Array.create(byteBuffer.byteArray.getBuffer(), byteBuffer.byteArray.getByteOffset(), this.capacity);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        DirectReadOnlyIntBufferAdapter buf = new DirectReadOnlyIntBufferAdapter(this.byteBuffer);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public IntBuffer compact() {
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public IntBuffer duplicate() {
        DirectReadWriteIntBufferAdapter buf = new DirectReadWriteIntBufferAdapter((DirectReadWriteByteBuffer)this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public int get() {
        return this.intArray.get(this.position++);
    }

    @Override
    public int get(int index) {
        return this.intArray.get(index);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected int[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public IntBuffer put(int c) {
        this.intArray.set(this.position++, c);
        return this;
    }

    @Override
    public IntBuffer put(int index, int c) {
        this.intArray.set(index, c);
        return this;
    }

    @Override
    public IntBuffer slice() {
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        DirectReadWriteIntBufferAdapter result = new DirectReadWriteIntBufferAdapter((DirectReadWriteByteBuffer)this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ArrayBufferView getTypedArray() {
        return this.intArray;
    }

    @Override
    public int getElementSize() {
        return 4;
    }
}

