/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

abstract class IntArrayBuffer
extends IntBuffer {
    protected final int[] backingArray;
    protected final int offset;

    IntArrayBuffer(int[] array) {
        this(array.length, array, 0);
    }

    IntArrayBuffer(int capacity) {
        this(capacity, new int[capacity], 0);
    }

    IntArrayBuffer(int capacity, int[] backingArray, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
    }

    @Override
    public final int get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    @Override
    public final int get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.backingArray[this.offset + index];
    }

    @Override
    public final IntBuffer get(int[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)len + (long)off > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dest, off, len);
        this.position += len;
        return this;
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

