/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.LongArrayBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyLongArrayBuffer;

final class ReadWriteLongArrayBuffer
extends LongArrayBuffer {
    static ReadWriteLongArrayBuffer copy(LongArrayBuffer other, int markOfOther) {
        ReadWriteLongArrayBuffer buf = new ReadWriteLongArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit();
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteLongArrayBuffer(long[] array) {
        super(array);
    }

    ReadWriteLongArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteLongArrayBuffer(int capacity, long[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return ReadOnlyLongArrayBuffer.copy(this, this.mark);
    }

    @Override
    public LongBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public LongBuffer duplicate() {
        return ReadWriteLongArrayBuffer.copy(this, this.mark);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected long[] protectedArray() {
        return this.backingArray;
    }

    @Override
    protected int protectedArrayOffset() {
        return this.offset;
    }

    @Override
    protected boolean protectedHasArray() {
        return true;
    }

    @Override
    public LongBuffer put(long c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    @Override
    public LongBuffer put(int index, long c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.backingArray[this.offset + index] = c;
        return this;
    }

    @Override
    public LongBuffer put(long[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, off, this.backingArray, this.offset + this.position, len);
        this.position += len;
        return this;
    }

    @Override
    public LongBuffer slice() {
        return new ReadWriteLongArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

