/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.corp.compatibility.Numbers;
import java.nio.BaseByteBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class StringByteBuffer
extends BaseByteBuffer {
    private String s;

    StringByteBuffer(String s) {
        super(s.length());
        this.s = s;
        this.order(ByteOrder.LITTLE_ENDIAN);
    }

    StringByteBuffer(String s, int position, int limit) {
        this(s);
        this.position = position;
        this.limit = limit;
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return this;
    }

    @Override
    byte[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean protectedHasArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer compact() {
        return this;
    }

    @Override
    public ByteBuffer duplicate() {
        return this;
    }

    @Override
    public byte get() {
        return this.get(this.position++);
    }

    @Override
    public byte get(int index) {
        return this.get(this.s, index);
    }

    @Override
    public final double getDouble() {
        return Numbers.longBitsToDouble(this.getLong());
    }

    @Override
    public final double getDouble(int index) {
        return Numbers.longBitsToDouble(this.getLong(index));
    }

    @Override
    public final float getFloat() {
        return Numbers.intBitsToFloat(this.getInt());
    }

    @Override
    public final float getFloat(int index) {
        return Numbers.intBitsToFloat(this.getInt(index));
    }

    @Override
    public final int getInt() {
        int newPosition = this.position + 4;
        int result = this.loadInt(this.position);
        this.position = newPosition;
        return result;
    }

    @Override
    public final int getInt(int index) {
        return this.loadInt(index);
    }

    @Override
    public final long getLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getLong(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final short getShort() {
        int newPosition = this.position + 2;
        short result = this.loadShort(this.position);
        this.position = newPosition;
        return result;
    }

    @Override
    public final short getShort(int index) {
        return this.loadShort(index);
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ByteBuffer put(byte b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer put(int index, byte b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putDouble(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putDouble(int index, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putFloat(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putFloat(int index, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putInt(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putInt(int index, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putLong(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putLong(int index, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putShort(short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer putShort(int index, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer slice() {
        StringByteBuffer slice = new StringByteBuffer(this.s, this.position, this.limit);
        slice.order = this.order;
        return slice;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private native byte get(String var1, int var2);

    protected final int loadInt(int baseOffset) {
        int bytes = 0;
        for (int i = 3; i >= 0; --i) {
            bytes <<= 8;
            bytes |= this.get(baseOffset + i) & 0xFF;
        }
        return bytes;
    }

    protected final short loadShort(int baseOffset) {
        short bytes = 0;
        bytes = (short)(this.get(baseOffset + 1) << 8);
        bytes = (short)(bytes | this.get(baseOffset) & 0xFF);
        return bytes;
    }
}

